/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.linenumbers;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.view.program.linenumbers.BreakpointSynchronizationService;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BreakpointSynchronizationServiceImpl
implements BreakpointSynchronizationService {
    private final ControllerInterface controllerInterface;
    private AtomicBoolean synchronizationActive = new AtomicBoolean(false);
    private String programName;

    @Inject
    BreakpointSynchronizationServiceImpl(ControllerInterface controllerInterface) {
        this.controllerInterface = controllerInterface;
    }

    @Override
    public void startSync(String scriptName, List<Integer> breakpointList) {
        boolean wasActive = this.synchronizationActive.getAndSet(true);
        if (!wasActive) {
            this.programName = scriptName;
            for (Integer breakpointLabel : breakpointList) {
                this.controllerInterface.runScript(String.format("breakpoint add %d \"%s\"", breakpointLabel, this.programName));
            }
        } else {
            throw new IllegalStateException("synchronization already active");
        }
    }

    @Override
    public void stopSync() {
        boolean wasActive = this.synchronizationActive.getAndSet(false);
        if (wasActive) {
            this.controllerInterface.runScript("breakpoint clear");
        }
    }

    @Override
    public void syncUpdate(int breakpointLabel, boolean isSet) {
        if (this.synchronizationActive.get()) {
            if (isSet) {
                this.controllerInterface.runScript(String.format("breakpoint add %d \"%s\"", breakpointLabel, this.programName));
            } else {
                this.controllerInterface.runScript(String.format("breakpoint remove %d \"%s\"", breakpointLabel, this.programName));
            }
        }
    }

    @Override
    public boolean isSyncActive() {
        return this.synchronizationActive.get();
    }
}

