/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.linenumbers;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.program.linenumbers.LineNumberDecorator;
import com.ur.view.program.linenumbers.NodeLineNumberCache;
import com.ur.view.program.linenumbers.ProgramTreeDecorated;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.program.ProgramRootNode;
import gui.program.SuppressedNode;
import java.util.Enumeration;
import javax.inject.Inject;

public class LineNumberDecoratorImpl
extends ProgramEventListener.Template
implements LineNumberDecorator,
ProgramTreeChangeObserver {
    private final ProgramLookupService programLookupService;
    private final NodeLineNumberCache nodeLineNumberCache;

    @Inject
    public LineNumberDecoratorImpl(ProgramLookupService programLookupService, NodeLineNumberCache nodeLineNumberCache) {
        this.programLookupService = programLookupService;
        this.nodeLineNumberCache = nodeLineNumberCache;
        EventNotificationService.register((Object)this, ProgramTreeChangeObserver.class, (Object)this);
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)this);
    }

    @Override
    public void handleProgramTreeEvent(ProgramTreeChangeObserver.ProgramTreeEvent event) {
        this.decorateTree();
    }

    public void onPostPostNewProgram(com.ur.polyscope.program.ProgramRootNode programRootNode) {
        this.decorateTree();
    }

    @Override
    public void decorateTree() {
        ProgramRootNode programRootNode = this.programLookupService.getProgramRootNode();
        if (programRootNode == null) {
            return;
        }
        int nodeId = 0;
        this.nodeLineNumberCache.clear();
        Enumeration<?> e = programRootNode.nodeEnumeration();
        while (e.hasMoreElements()) {
            AbstractProgramNode node = (AbstractProgramNode)e.nextElement();
            node.setId(nodeId);
            this.nodeLineNumberCache.add(node);
            if (node instanceof SuppressedNode) {
                int noOfChildren = this.countChildren(node);
                nodeId += noOfChildren + 1;
                int i = 0;
                while (i < noOfChildren) {
                    this.nodeLineNumberCache.add(null);
                    ++i;
                }
                continue;
            }
            ++nodeId;
        }
        this.notifyTreeDecorated();
    }

    private int countChildren(AbstractProgramNode node) {
        int count = 0;
        if (node instanceof SuppressedNode) {
            node = ((SuppressedNode)node).getSuppressedNode();
        }
        int i = 0;
        while (i < node.getChildCount()) {
            AbstractProgramNode child = (AbstractProgramNode)node.getChildAt(i);
            count += this.countChildren(child) + 1;
            ++i;
        }
        return count;
    }

    private void notifyTreeDecorated() {
        EventNotificationService.notify(ProgramTreeDecorated.class, (NotificationStrategy)new NotificationStrategy<ProgramTreeDecorated>(){

            public void notify(ProgramTreeDecorated programTreeDecorated) {
                programTreeDecorated.programNodesUpdatedWithIds();
            }
        });
    }
}

