/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.linenumbers;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.util.logging.Log;
import com.ur.view.program.linenumbers.LineNumberModel;
import gui.program.SuppressedNode;
import gui.tree.ProgramTreeProvider;
import java.awt.Rectangle;
import javax.inject.Inject;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class LineNumberModelImpl
implements LineNumberModel {
    private final ProgramTreeProvider programTreeProvider;

    @Inject
    public LineNumberModelImpl(ProgramTreeProvider treeProvider) {
        this.programTreeProvider = treeProvider;
    }

    private JTree getTree() {
        return this.programTreeProvider.getTree();
    }

    @Override
    public int getVisibleNumLines() {
        return this.getTree().getRowCount();
    }

    @Override
    public Rectangle getLineStart(int line) {
        return this.getTree().getRowBounds(line);
    }

    @Override
    public int getNumOfCollapsedLinesAtLine(int line) {
        TreePath nodePath = this.getTree().getPathForRow(line);
        if (nodePath == null) {
            Log.error((String)("NodePath is null for line: " + line));
        } else {
            AbstractProgramNode node = (AbstractProgramNode)nodePath.getLastPathComponent();
            if (node instanceof SuppressedNode || this.isNodeCollapsed(node, nodePath)) {
                return this.countChildren(node);
            }
        }
        return 0;
    }

    private int countChildren(AbstractProgramNode node) {
        if (node instanceof SuppressedNode) {
            node = ((SuppressedNode)node).getSuppressedNode();
        }
        int count = 0;
        int i = 0;
        while (i < node.getChildCount()) {
            AbstractProgramNode child = (AbstractProgramNode)node.getChildAt(i);
            count += this.countChildren(child) + 1;
            ++i;
        }
        return count;
    }

    private boolean isNodeCollapsed(AbstractProgramNode node, TreePath nodePath) {
        return node.getChildCount() > 0 && !this.getTree().isVisible(nodePath.pathByAddingChild(node.getFirstChild()));
    }
}

