/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.stepping;

import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.viewfacade.program.ProgramActionResult;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.program.ProgramExecutor;
import com.ur.view.program.stepping.StepProgramService;
import gui.program.ProgramRootNode;
import javax.inject.Inject;

public class StepProgramServiceImpl
implements StepProgramService {
    private final ProgramExecutor programExecutor;
    private final ProgramStateHolder programStateHolder;
    private final UserAccessControl accessControl;

    @Inject
    public StepProgramServiceImpl(ProgramExecutor programExecutor, ProgramStateHolder programStateHolder, UserAccessControl accessControl) {
        this.programExecutor = programExecutor;
        this.programStateHolder = programStateHolder;
        this.accessControl = accessControl;
    }

    @Override
    public ProgramActionResult canStepProgram(ProgramRootNode program) {
        if (this.programStateHolder.getProgramState() != ProgramState.PAUSED) {
            return ProgramActionResult.NO_WHERE_TO_STEP_FROM;
        }
        if (this.accessControl.getCurrentOperationalMode() == OperationalMode.AUTOMATIC) {
            return ProgramActionResult.NO_WHERE_TO_STEP_FROM;
        }
        return ProgramActionResult.SUCCESS;
    }

    @Override
    public ProgramActionResult stepProgram(ProgramRootNode program) {
        if (this.canStepProgram(program) == ProgramActionResult.SUCCESS && this.programExecutor.stepProgram()) {
            return ProgramActionResult.SUCCESS;
        }
        return ProgramActionResult.NO_WHERE_TO_STEP_FROM;
    }
}

