/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.stepping;

import com.ur.i18n.TextResource;
import com.ur.monitor.RobotState;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.dialog.WarningMessage;
import com.ur.util.logging.Log;
import com.ur.view.program.ProgramExecutor;
import com.ur.view.variables.domain.VariableLookupService;
import gui.program.ProgramRootNode;
import gui.program.position.PositionNode;
import gui.program.services.GeomFeatureVariable;
import gui.tools.DialogCreator;
import java.util.Set;

class WriteCodeForStepForward {
    private final ProgramRootNode programRootNode;
    private final ProgramExecutor executor;
    private final AbstractProgramNode currentNodeLocal;
    private final AbstractProgramNode nextNode;
    private final TextResource textResource;
    private final VariableLookupService variableLookupService;
    private final DialogCreator dialogCreator;
    private PositionNode posNode;
    private boolean myResult;

    WriteCodeForStepForward(ProgramRootNode programRootNode, ProgramExecutor executor, AbstractProgramNode currentNodeLocal, AbstractProgramNode nextNode, VariableLookupService variableLookupService, TextResource textResource, DialogCreator dialogCreator) {
        this.programRootNode = programRootNode;
        this.executor = executor;
        this.currentNodeLocal = currentNodeLocal;
        this.nextNode = nextNode;
        this.variableLookupService = variableLookupService;
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
    }

    boolean is() {
        return this.myResult;
    }

    PositionNode getPosNode() {
        return this.posNode;
    }

    WriteCodeForStepForward invoke() {
        ScriptWriter writer = new ScriptWriter();
        writer.defineFunction("step_forward");
        if (this.variableLookupService != null) {
            this.variableLookupService.generatePreambleScript(writer, (ScriptGenerator)this.programRootNode, GeomFeatureVariable.class, false, true);
        }
        if (this.currentNodeLocal instanceof PositionNode) {
            if (this.isPositionNode(writer)) {
                return this;
            }
        } else {
            this.currentNodeLocal.generateScriptCode(writer);
        }
        this.findLabelForNextProgramLineAndMoveRobotThere(writer);
        writer.end();
        this.executor.acceptScript(writer);
        this.myResult = false;
        return this;
    }

    private boolean isPositionNode(ScriptWriter writer) {
        this.posNode = (PositionNode)this.currentNodeLocal;
        if (this.posNode.getPositionNodeType() == PositionNodeType.FIXED) {
            if (this.fixedPositionNode(writer)) {
                return true;
            }
        } else if (this.posNode.getPositionNodeType() == PositionNodeType.RELATIVE) {
            this.posNode.generatePreambleScript(writer);
            this.posNode.generateScriptCodeNoBlend(writer);
        }
        return false;
    }

    private void findLabelForNextProgramLineAndMoveRobotThere(ScriptWriter writer) {
        if (this.nextNode == null) {
            this.dialogCreator.showWarningMessageDialog(new WarningMessage(this.textResource.cannotStep(), this.textResource.endOfProgram()), null);
        } else if (this.nextNode != this.currentNodeLocal) {
            writer.writeProgramLabel((ControllerInterfaceProgramNode)this.nextNode);
        }
    }

    private boolean fixedPositionNode(ScriptWriter writer) {
        boolean foundAFromNodeThatIsHere = this.posNode.getJointPositionVector().epsilonEquals(RobotState.getLatestRobotState().jointPosition, 0.05);
        Set fromPositionNodes = this.posNode.getPreviousPositionNodes(PositionNode.class);
        for (PositionNode pn : fromPositionNodes) {
            if (Log.canLog((Log.Level)Log.Level.TRACE)) {
                Log.trace((String)(" Checking " + pn.toString()));
            }
            if (pn.getPositionNodeType() != PositionNodeType.FIXED || !pn.getJointPositionVector().epsilonEquals(RobotState.getLatestRobotState().jointPosition, 0.01)) continue;
            foundAFromNodeThatIsHere = true;
        }
        if (!foundAFromNodeThatIsHere) {
            if (this.nextNode != null) {
                this.nextNode.setSelected();
            }
            this.myResult = true;
            return true;
        }
        this.posNode.generatePreambleScript(writer);
        this.posNode.generateScriptCodeNoBlend(writer);
        return false;
    }
}

