/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.program.subprogramnode;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.swing.FormBuilder;
import com.ur.swing.TextProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.filemanager.ProgramFileManagerConfiguration;
import com.ur.view.program.filemanager.UrpProgramFileFilter;
import com.ur.view.program.subprogramnode.SubProgramCard$4$AjcClosure1;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.commandpanels.SubProgramDialogSupport;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.program.SubProgramNode;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SubProgramCard
extends CommandPanel<SubProgramNode> {
    private static final Logger LOG = LogFactory.createLogger(SubProgramCard.class);
    public static final String RENAME_SUBPROGRAM = "Rename.SubProgramCard";
    public static final String LOAD_FROM_FILE = "Load.SubProgramCard";
    public static final String CLEAR_SELECTED_FILE = "ClearFile.SubProgramCard";
    public static final String SAVE_SUBPROGRAM = "SaveSubProgramToFile.SubProgramCard";
    public static final String KEEP_SELECTED_FILE_ENABLED = "KeepSelectedFileInSync.SubProgramCard";
    private final ViewContext context;
    private final SubProgramDialogSupport dialogSupport;
    private final FileTypePersistence filePersistence;
    private final NamingService namingService;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private FileContainer saveFileContainer;
    private FileContainer loadFileContainer;
    private boolean updating = false;
    private TextResource textResource;
    private JTextField selectedFileName;
    private JCheckBox keepSynchronizedWithSelectedFile;
    private JButton renameButton;
    private JButton clearSelectedFiled;
    private JCheckBox hideSubTree;
    private JLabel titleLabel;

    @Inject
    SubProgramCard(ViewContext context, SubProgramDialogSupport dialogSupport, FileTypePersistence filePersistence, NamingService nameServer, ControlProgramTreeStructure controlProgramTreeStructure) {
        super(SubProgramNode.class);
        this.context = context;
        this.dialogSupport = dialogSupport;
        this.filePersistence = filePersistence;
        this.namingService = nameServer;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.textResource = (TextResource)context.getTextResource(TextResource.class);
        this.initComponents();
        context.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_subprog");
    }

    private ValidationStrategy createValidator(NamingService namingService) {
        TextProvider textProvider = this.createTextProvider();
        return NameValidationFactory.getVariableNameValidator(textProvider, namingService, SubProgramNode.class, this.textResource);
    }

    private TextHolder createTextHolder() {
        return new TextHolder(){

            public String getText() {
                return ((SubProgramNode)SubProgramCard.this.getNode()).getName();
            }

            public void setText(String text) {
                ((SubProgramNode)SubProgramCard.this.getNode()).setName(text);
                SubProgramCard.this.updateCard();
            }
        };
    }

    private TextProvider createTextProvider() {
        return new TextProvider(){

            public String getText() {
                return ((SubProgramNode)SubProgramCard.this.getNode()).getName();
            }
        };
    }

    protected boolean isSubProgramAlreadyLoaded(File file) {
        ProgramRootNode programRootNode = ProgramRootNode.get((AbstractProgramNode)this.getNode());
        int i = 0;
        while (i < programRootNode.getChildCount()) {
            SubProgramNode rootsSpn;
            if (programRootNode.getChildAt(i) instanceof SubProgramNode && (rootsSpn = (SubProgramNode)((Object)programRootNode.getChildAt(i))).getFile() != null && rootsSpn.getFile().getAbsolutePath().equals(file.getAbsolutePath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isProgramFile(File file) {
        return new UrpProgramFileFilter().accept(file);
    }

    private void handleSelectFileEvent() {
        DialogReturnValue result;
        SubProgramNode node = (SubProgramNode)this.getNode();
        if (node.hasChildren() && (result = this.dialogSupport.showConfirmReplaceLoadedSubProgram(node.getName())) == DialogReturnValue.CANCEL) {
            return;
        }
        this.loadFileContainer = new FileContainer();
        this.loadFileContainer.setFile(node.getFile());
        this.filePersistence.openFile(this.loadFileContainer, (FileManagerConfiguration)new ProgramFileManagerConfiguration(this.textResource.loadProgram()));
    }

    @Override
    protected void updateCard() {
        File file;
        SubProgramNode node = (SubProgramNode)this.getNode();
        this.updating = true;
        if (this.isFileContainerWithFile(this.saveFileContainer)) {
            file = this.saveFileContainer.getFile();
            this.saveProgramToFile(node, file);
            this.saveFileContainer = null;
        }
        if (this.isFileContainerWithFile(this.loadFileContainer) && this.loadFileContainer.hasFile()) {
            file = this.loadFileContainer.getFile();
            this.loadProgramFromFile(node, file);
            this.loadFileContainer = null;
        }
        this.hideSubTree.setSelected(node.getKeepHidden());
        if (node.getKeepHidden()) {
            this.controlProgramTreeStructure.collapsePathTo((TreeNode)((Object)node));
        } else {
            this.controlProgramTreeStructure.expandPathTo((TreeNode)((Object)node));
        }
        this.titleLabel.setText(HTML.html((String)HTML.h1((String)node.getName())));
        this.clearSelectedFiled.setEnabled(node.getFile() != null);
        if (node.getFile() == null) {
            this.selectedFileName.setText(this.textResource.noFileSelected());
            this.keepSynchronizedWithSelectedFile.setSelected(false);
            this.keepSynchronizedWithSelectedFile.setEnabled(false);
        } else {
            this.selectedFileName.setText(node.getFile().getAbsolutePath());
            this.keepSynchronizedWithSelectedFile.setSelected(node.isKeepSynchronizedWithDisk());
            this.keepSynchronizedWithSelectedFile.setEnabled(true);
        }
        this.updating = false;
    }

    private boolean isFileContainerWithFile(FileContainer fileContainer) {
        return fileContainer != null && fileContainer.getFile() != null;
    }

    private void saveProgramToFile(final SubProgramNode node, final File file) {
        if (this.isMainProgram(node, file)) {
            this.dialogSupport.showSubProgramIsSameAsLoadedProgram();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Saving SubProgram {0}", new Object[]{file});
                    node.setFileAndName(file);
                    node.saveFile();
                    SubProgramCard.this.selectedFileName.setText(file.getAbsolutePath());
                    LOG.debug("Saved SubProgram {0}", new Object[]{node.getName()});
                }
            });
        }
    }

    private void loadProgramFromFile(final SubProgramNode node, final File file) {
        if (this.isMainProgram(node, file)) {
            this.dialogSupport.showSubProgramIsSameAsLoadedProgram();
        } else if (this.isSubProgramAlreadyLoaded(file)) {
            this.dialogSupport.showSubProgramAlreadyLoaded();
        } else if (!this.isMainProgram(node, file)) {
            SwingUtilities.invokeLater(new Runnable(){
                private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                @Override
                @CompoundProgramChange
                public void run() {
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Object[] objectArray = new Object[]{this, joinPoint};
                    SubProgramCard$4$AjcClosure1 subProgramCard$4$AjcClosure1 = new SubProgramCard$4$AjcClosure1(objectArray);
                    ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(subProgramCard$4$AjcClosure1.linkClosureAndJoinPoint(69648));
                }

                static {
                    4.ajc$preClinit();
                }

                static final /* synthetic */ void run_aroundBody0(4 ajc$this, JoinPoint joinPoint) {
                    LOG.debug("Loading SubProgram {0}", new Object[]{ajc$this.file});
                    ajc$this.node.setFile(ajc$this.file);
                    if (ajc$this.SubProgramCard.this.isProgramFile(ajc$this.file)) {
                        ((SubProgramNode)ajc$this.SubProgramCard.this.getNode()).loadFile();
                    }
                    String name = ajc$this.SubProgramCard.this.extractNameFromFile(ajc$this.node, ajc$this.file);
                    ajc$this.node.setName(ajc$this.SubProgramCard.this.namingService.makeUniqueName(SubProgramNode.class, name));
                    ajc$this.SubProgramCard.this.selectedFileName.setText(ajc$this.file.getAbsolutePath());
                    ajc$this.SubProgramCard.this.nodeStructureChanged(ajc$this.node);
                    LOG.debug("Loaded SubProgram {0}", new Object[]{ajc$this.node.getName()});
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("SubProgramCard.java", 4.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "com.ur.view.program.subprogramnode.SubProgramCard$4", "", "", "", "void"), 238);
                }
            });
        }
    }

    protected String extractNameFromFile(SubProgramNode node, File file) {
        ProgramRootNode subRootNode = node.getSubProgramRootNode();
        return subRootNode.getComponent(FileManagementProgramComponent.class).setDirectoryAndExtractName(file);
    }

    protected boolean isMainProgram(SubProgramNode node, File file) {
        return file.getName().equals(String.valueOf(ProgramRootNode.get(node).getName()) + ".urp");
    }

    private void initComponents() {
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.context.getTextResource(CommandNamesResource.class);
        this.titleLabel = new JLabel(HTML.html((String)HTML.h1((String)commandNamesResource.SubProgam())));
        this.renameButton = new JButton(this.textResource.Rename());
        this.renameButton.setName(RENAME_SUBPROGRAM);
        TextFieldUtils.bindTextPicker((JComponent)this.renameButton, (TextHolder)this.createTextHolder(), (ValidationStrategy)this.createValidator(this.namingService));
        JButton saveSubProgramToFile = new JButton(this.textResource.saveSubprogram());
        saveSubProgramToFile.setName(SAVE_SUBPROGRAM);
        saveSubProgramToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!SubProgramCard.this.updating) {
                    SubProgramCard.this.saveFileContainer = new FileContainer();
                    SubProgramCard.this.saveFileContainer.setFile(((SubProgramNode)SubProgramCard.this.getNode()).getFile());
                    SubProgramCard.this.filePersistence.saveFile(SubProgramCard.this.saveFileContainer, (FileManagerConfiguration)new ProgramFileManagerConfiguration(SubProgramCard.this.textResource.saveProgram()), ".urp");
                }
            }
        });
        this.clearSelectedFiled = new JButton(this.textResource.clearSubprogram());
        this.clearSelectedFiled.setName(CLEAR_SELECTED_FILE);
        this.clearSelectedFiled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubProgramCard.this.clearSubProgramButtonActionPerformed();
            }
        });
        this.keepSynchronizedWithSelectedFile = new JCheckBox(this.textResource.keepSubprogramFileUpdatedWithThisProgram());
        this.keepSynchronizedWithSelectedFile.setEnabled(false);
        this.keepSynchronizedWithSelectedFile.setName(KEEP_SELECTED_FILE_ENABLED);
        this.keepSynchronizedWithSelectedFile.setFocusable(false);
        this.keepSynchronizedWithSelectedFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SubProgramCard.this.keepSynchronizedCheckBoxItemStateChanged();
            }
        });
        this.hideSubTree = new JCheckBox(this.textResource.hideSubprogramTree());
        this.keepSynchronizedWithSelectedFile.setFocusable(false);
        this.hideSubTree.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SubProgramCard.this.showSubtreeCheckBoxItemStateChanged();
            }
        });
        this.selectedFileName = new JTextField();
        this.selectedFileName.setFocusable(false);
        this.selectedFileName.setEditable(false);
        this.selectedFileName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SubProgramCard.this.handleSelectFileEvent();
            }
        });
        JButton loadSubProgram = new JButton(this.textResource.loadFile());
        loadSubProgram.setName(LOAD_FROM_FILE);
        loadSubProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubProgramCard.this.handleSelectFileEvent();
            }
        });
        JPanel topPanel = this.context.createFormBuilder().label(this.titleLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).component((JComponent)this.renameButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().description(this.textResource.commandSubprogram(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).label(this.textResource.subprogramFile(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.selectedFileName, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS}).end().spacer(5).component((JComponent)loadSubProgram, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end(this.getFillerRows()).buttonRow((JComponent)saveSubProgramToFile, (JComponent)this.clearSelectedFiled, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN, FormBuilder.PanelConstraints.SPAN_10_COLUMNS}).end().getPanel();
        JPanel bottomPanel = this.context.createFormBuilder().component((JComponent)this.keepSynchronizedWithSelectedFile, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.hideSubTree, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
        if (UIManager.getLookAndFeel() instanceof G5LookAndFeel) {
            this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        }
        this.setLayout(new BorderLayout(0, 5));
        this.add(topPanel, "Center");
        this.add(bottomPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private int getFillerRows() {
        if (UIManager.getLookAndFeel() instanceof G5LookAndFeel) {
            return 11;
        }
        return 9;
    }

    private void showSubtreeCheckBoxItemStateChanged() {
        if (!this.updating) {
            SubProgramNode node = (SubProgramNode)this.getNode();
            node.setKeepHidden(this.hideSubTree.isSelected());
            if (node.getKeepHidden()) {
                this.controlProgramTreeStructure.collapsePathTo((TreeNode)((Object)node));
            } else {
                this.controlProgramTreeStructure.expandPathTo((TreeNode)((Object)node));
            }
        }
    }

    private void clearSubProgramButtonActionPerformed() {
        SubProgramNode node = (SubProgramNode)this.getNode();
        if (node != null) {
            DialogReturnValue ret;
            if (node.hasChildren() && (ret = this.dialogSupport.showConfirmClearSelectedProgram(node.getName())) == DialogReturnValue.CANCEL) {
                return;
            }
            NamedEntityCollection collection = (NamedEntityCollection)node.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
            this.namingService.deregisterNamedEntities(collection);
            node.clear();
            collection = (NamedEntityCollection)node.getProgramEntitiesInSubtree((Collection)new NamedEntityCollection());
            this.namingService.registerNamedEntities(collection);
            this.nodeStructureChanged(node);
            this.updateCard();
        }
    }

    protected void nodeStructureChanged(SubProgramNode node) {
        ((ProgramRootNode)((Object)node.getRoot())).getProgramTreeModel().nodeStructureChanged((TreeNode)((Object)node));
    }

    private void keepSynchronizedCheckBoxItemStateChanged() {
        SubProgramNode node = (SubProgramNode)this.getNode();
        if (node != null && !this.updating) {
            node.setKeepSynchronizedWithDisk(this.keepSynchronizedWithSelectedFile.isSelected());
        }
    }
}

