/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.robot;

import com.ur.lang.EqualsUtil;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;

public class PowerUpRobot {
    private static final int POWER_UP_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(25L);
    private static final int POWER_UP_TIMEOUT_UPDATING_FW = (int)TimeUnit.SECONDS.toMillis(120L);
    private static final int DELAY_BETWEEN_COMMANDS = 100;
    private final Provider<Arm> armProvider;
    private final Provider<com.ur.monitor.model.RobotMode> robotModeProvider;
    private ControllerInterface controllerInterface;
    private final WaitingOnCondition condition;
    private boolean poweredOn;

    @Inject
    PowerUpRobot(@Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=com.ur.monitor.model.RobotMode.class) Recipe<com.ur.monitor.model.RobotMode> rmRecipe, ControllerInterface controllerInterface) {
        this(armRecipe, rmRecipe, controllerInterface, new WaitingOnCondition());
    }

    PowerUpRobot(@Source(value=Arm.class) Recipe<Arm> armRecipe, @Source(value=com.ur.monitor.model.RobotMode.class) Recipe<com.ur.monitor.model.RobotMode> rmRecipe, ControllerInterface controllerInterface, WaitingOnCondition condition) {
        this.armProvider = armRecipe.lastProvider();
        this.robotModeProvider = rmRecipe.lastProvider();
        this.controllerInterface = controllerInterface;
        this.condition = condition;
    }

    public boolean sendPowerOnAndWaitTillRobotIsReady() {
        if (((Arm)this.armProvider.get()).isPowerOn()) {
            return true;
        }
        this.poweredOn = this.condition.met(new PowerOn(), POWER_UP_TIMEOUT);
        if (!this.poweredOn) {
            this.handleNotPoweredOn();
        }
        return this.poweredOn;
    }

    private void handleNotPoweredOn() {
        if (this.isUpdatingFirmware()) {
            this.tryToPowerOnRobotWithExtendedTimeout();
        } else {
            this.logRobotNotPoweredOnError();
        }
    }

    private void tryToPowerOnRobotWithExtendedTimeout() {
        this.poweredOn = this.condition.met(new PowerOn(), POWER_UP_TIMEOUT_UPDATING_FW);
        if (!this.poweredOn) {
            this.logRobotNotPoweredOnError();
        }
    }

    private void logRobotNotPoweredOnError() {
        Log.error((String)String.format("Robot power up timed out. Robot mode=%s Safety mode=%s", ((com.ur.monitor.model.RobotMode)this.robotModeProvider.get()).getRobotMode(), ((com.ur.monitor.model.RobotMode)this.robotModeProvider.get()).getSafetyMode()));
    }

    private boolean isUpdatingFirmware() {
        return RobotMode.UPDATING.equals((Object)((com.ur.monitor.model.RobotMode)this.robotModeProvider.get()).getRobotMode());
    }

    class PowerOn
    implements Waiting.ItHappens {
        PowerOn() {
        }

        public boolean itHappened() {
            RobotMode robotMode = ((com.ur.monitor.model.RobotMode)PowerUpRobot.this.robotModeProvider.get()).getRobotMode();
            SafetyMode safetyMode = ((com.ur.monitor.model.RobotMode)PowerUpRobot.this.robotModeProvider.get()).getSafetyMode();
            if (EqualsUtil.equals((Object)robotMode, (Object)RobotMode.POWER_OFF)) {
                PowerUpRobot.this.controllerInterface.runScript("power on");
            }
            return EqualsUtil.equalsOneOf((Object)robotMode, (Object[])new RobotMode[]{RobotMode.IDLE, RobotMode.RUNNING}) || !EqualsUtil.equalsOneOf((Object)safetyMode, (Object[])new SafetyMode[]{SafetyMode.NORMAL, SafetyMode.REDUCED});
        }
    }

    static class WaitingOnCondition {
        WaitingOnCondition() {
        }

        public boolean met(Waiting.ItHappens itHappened, int timeout) {
            return Waiting.until((Waiting.ItHappens)itHappened, (int)timeout, (int)100, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }
}

