/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.runtimeexception;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.log.ExportAction;
import com.ur.log.logentry.robotmessage.Attachment;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.PerformingFileContainer;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.filemanager.filter.ZipFileFilter;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.util.concurrent.ParallelTask;
import com.ur.util.concurrent.Task;
import com.ur.util.logging.Log;
import com.ur.view.Settings;
import gui.tools.LegacyURDialogCreator;
import gui.tools.URFileUtils;
import gui.tools.dialogs.DialogInputStrategy;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

class ExportAttachmentAction
extends InterceptableAction.Default
implements ExportAction {
    private Attachment attachment;
    private final FilePersistence filePersistence;
    private final FlipManager flipManager;
    private final TaskMonitor taskMonitor;
    private final TextResource textResource;

    public ExportAttachmentAction(FilePersistence filePersistence, FlipManager flipManager, TaskMonitor taskMonitor, TextResource textResource) {
        this.filePersistence = filePersistence;
        this.flipManager = flipManager;
        this.taskMonitor = taskMonitor;
        this.textResource = textResource;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    private ErrorMessage reportNotAvailable() {
        return new ErrorMessage(this.textResource.errorReportExportTitle(), this.textResource.reportNotAvailable());
    }

    private ErrorMessage cantSaveReportFile(String path) {
        return new ErrorMessage(this.textResource.errorReportExportTitle(), this.textResource.cantSaveReportFile(path));
    }

    public void doActionPerformed(ActionEvent e) {
        Log.info((String)("Exporting attachment: " + this.attachment));
        PerformingFileContainer reportFileContainer = new PerformingFileContainer(){

            public boolean perform() {
                if (this.hasFileSelected()) {
                    final InputStream reportDataStream = ExportAttachmentAction.this.attachment.exportFromStream();
                    if (reportDataStream == null) {
                        LegacyURDialogCreator.showErrorDialog(ExportAttachmentAction.this.reportNotAvailable());
                        return false;
                    }
                    final String path = this.getFile().getPath().replaceAll(Directories.programs().getAbsolutePath(), "");
                    if (URFileUtils.isFilenameValid(this.getFile())) {
                        new DialogInputStrategy().runWithProgress(ExportAttachmentAction.this.taskMonitor, (Task)new ParallelTask(ExportAttachmentAction.this.textResource.inProgress()){

                            public void run() {
                                block5: {
                                    File reportFile = this.getFile();
                                    FileOutputStream reportFileWriter = null;
                                    try {
                                        try {
                                            reportFileWriter = new FileOutputStream(reportFile);
                                            IOUtils.copyLarge((InputStream)reportDataStream, (OutputStream)reportFileWriter, (byte[])new byte[0x100000]);
                                        }
                                        catch (IOException ioe) {
                                            Log.error((String)("Could not export report to file: \"" + reportFile.getPath() + "\""), (Throwable)ioe);
                                            LegacyURDialogCreator.showErrorDialog(ExportAttachmentAction.this.cantSaveReportFile(path));
                                            IOUtils.closeQuietly((OutputStream)reportFileWriter);
                                            IOUtils.closeQuietly((InputStream)reportDataStream);
                                            break block5;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        IOUtils.closeQuietly(reportFileWriter);
                                        IOUtils.closeQuietly((InputStream)reportDataStream);
                                        throw throwable;
                                    }
                                    IOUtils.closeQuietly((OutputStream)reportFileWriter);
                                    IOUtils.closeQuietly((InputStream)reportDataStream);
                                }
                            }
                        });
                    } else {
                        Log.error((String)("Could not export report to file: \"" + path + "\""));
                        LegacyURDialogCreator.showErrorDialog(ExportAttachmentAction.this.cantSaveReportFile(path));
                        return false;
                    }
                }
                return true;
            }
        };
        reportFileContainer.setAction(FileContainer.Action.SaveAs);
        reportFileContainer.setFile(this.attachment.exportToFile());
        this.filePersistence.saveFile((FileContainer)reportFileContainer, new FileManagerConfiguration(this.textResource.titleExporterrorreport(), FileManagerConfiguration.Access.UNRESTRICTED, Directories.programs(), new URFileFilter[]{new ZipFileFilter(Settings.getLanguage().getLocale())}));
    }

    public FlipManager getFlipManager() {
        return this.flipManager;
    }
}

