/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.serialnumber;

import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.robot.configuration.robotidentification.ControlBoxType;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.robot.configuration.robotidentification.RobotTypeIdentifier;
import com.ur.polyscope.robot.configuration.teachpendent.TPCapable;
import com.ur.swing.CardPanel;
import com.ur.swing.ComboBox;
import com.ur.swing.JFrameUtils;
import com.ur.swing.LongPressEraseDelegate;
import com.ur.util.Optional;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.dev.TPType;
import gui.main.OnInitializeRobotSetup;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public abstract class SerialNumberScreen
extends CardPanel {
    private static final Font FONT = new Font("DejaVu Sans", 1, 14);
    private static final Font FONT_SIZE_24 = new Font("DejaVu Sans", 1, 24);
    private static final int BUTTON_PANEL_APPX_WIDTH = 350;
    private static final Logger LOG = LogFactory.createLogger(SerialNumberScreen.class);
    private final OnInitializeRobotSetup onInitializeRobotSetup;
    protected RobotTypeIdentifier robotTypeId;
    private TPType initialTPType;
    private ControlBoxType contolBoxType = ControlBoxType.STANDARD;
    protected RobotIdentificationProvider repository;
    private final Set<RobotTypeIdentifier> robotTypeIdentifiers;
    private final Set<TPCapable> tpCapabilities;
    private ComponentAdapter resizeListener;
    private JFrame frameInstance;
    protected JButton backspaceButton;
    private final JToggleButton jToggleButtonEuromap67;
    protected JPanel numberButtonsPanel;
    protected JButton okButton;
    protected JFormattedTextField serialField;
    protected JLabel serialTextLabel;
    protected JLabel chooseControlBoxLabel;
    protected JPanel controlBoxTypePanel;
    private final ButtonGroup controlBoxTypeGroup;
    private final JToggleButton standardButton;
    private final JToggleButton oemACButton;
    private final JToggleButton oemDCButton;
    protected JLabel tpTypeLabel;
    protected final ComboBox<TPType> tpTypeComboBox;
    protected Map<RobotTypeIdentifier, JToggleButton> robotTypeButtonMappings;

    @Inject
    SerialNumberScreen(OnInitializeRobotSetup onInitializeRobotSetup, RobotIdentificationProvider repository, Set<RobotTypeIdentifier> robotTypeIdentifiers, Set<TPCapable> tpCapabilities) {
        this.onInitializeRobotSetup = onInitializeRobotSetup;
        this.repository = repository;
        this.robotTypeIdentifiers = robotTypeIdentifiers;
        this.tpCapabilities = tpCapabilities;
        this.robotTypeButtonMappings = new HashMap<RobotTypeIdentifier, JToggleButton>();
        this.serialTextLabel = new JLabel();
        this.numberButtonsPanel = new JPanel();
        this.okButton = new JButton();
        this.serialField = new JFormattedTextField();
        this.serialField.setFocusLostBehavior(3);
        this.backspaceButton = new JButton();
        this.chooseControlBoxLabel = new JLabel();
        this.controlBoxTypePanel = new JPanel();
        this.jToggleButtonEuromap67 = new JToggleButton();
        this.controlBoxTypeGroup = new ButtonGroup();
        this.standardButton = new JToggleButton();
        this.oemACButton = new JToggleButton();
        this.oemDCButton = new JToggleButton();
        this.tpTypeLabel = new JLabel();
        this.tpTypeComboBox = new ComboBox(new DefaultComboBoxModel<TPType>(TPType.values()));
        this.initComponents();
    }

    private static Box.Filler filler() {
        return new Box.Filler(new Dimension(3, 0), new Dimension(3, 0), new Dimension(3, 0));
    }

    protected void initComponents() {
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.serialTextLabel.setFont(FONT);
        this.serialTextLabel.setText("Enter robot serial number:");
        this.numberButtonsPanel.setLayout(new GridLayout(4, 4, 1, 1));
        this.digitKeyBinding("1");
        this.digitKeyBinding("2");
        this.digitKeyBinding("3");
        this.digitKeyBinding("4");
        this.digitKeyBinding("5");
        this.digitKeyBinding("6");
        this.digitKeyBinding("7");
        this.digitKeyBinding("8");
        this.digitKeyBinding("9");
        this.digitKeyBinding("0");
        this.okButton.setFont(FONT_SIZE_24);
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(evt -> {
            this.initialTPType = this.isNonDefaultTPType(this.initialTPType) ? this.initialTPType : null;
            this.onInitializeRobotSetup.initializeRobot(this.robotTypeId, this.contolBoxType, this.serialField.getText(), this.jToggleButtonEuromap67.isSelected(), this.initialTPType);
            EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(SerialNumberScreen.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
            this.navigateBack();
        });
        this.serialField.setFont(FONT_SIZE_24);
        this.serialField.setHorizontalAlignment(11);
        this.serialField.addCaretListener(evt -> this.selectedRobotChanged());
        this.backspaceButton.setFont(FONT);
        this.backspaceButton.setText("<<");
        new LongPressEraseDelegate(this.backspaceButton, this.serialField){

            protected void buttonReleased() {
                SerialNumberScreen.this.serialField.requestFocusInWindow();
                SerialNumberScreen.this.serialField.requestFocus();
            }
        };
        this.backspaceButton.setEnabled(true);
        this.chooseControlBoxLabel.setFont(FONT);
        this.chooseControlBoxLabel.setHorizontalAlignment(2);
        this.chooseControlBoxLabel.setText("Choose control box type:");
        this.controlBoxTypePanel.setLayout(new BoxLayout(this.controlBoxTypePanel, 2));
        this.makeControlBoxButton(this.standardButton, ControlBoxType.STANDARD);
        this.controlBoxTypePanel.add(SerialNumberScreen.filler());
        this.makeControlBoxButton(this.oemACButton, ControlBoxType.OEM_AC);
        this.controlBoxTypePanel.add(SerialNumberScreen.filler());
        this.makeControlBoxButton(this.oemDCButton, ControlBoxType.OEM_DC);
        this.standardButton.setSelected(true);
        this.tpTypeLabel.setFont(FONT);
        this.tpTypeLabel.setText("Select initial teach pendant type:");
        this.tpTypeComboBox.setEnabled(false);
        this.tpTypeComboBox.setSelectedItem((Object)TPType.STANDARD);
        this.tpTypeComboBox.addActionListener(actionEvent -> {
            TPType selectedTPType = (TPType)this.tpTypeComboBox.getSelectedItem();
            this.initialTPType = this.isNonDefaultTPType(selectedTPType) ? selectedTPType : null;
        });
    }

    private boolean isNonDefaultTPType(TPType tpType) {
        TPCapable tpCapable = this.findSelectedTpCapable();
        if (tpCapable == null) {
            return false;
        }
        return tpCapable.getDefaultTeachPendent() != tpType;
    }

    private void digitKeyBinding(String digit) {
        JButton button = new JButton(digit);
        button.setFont(FONT_SIZE_24);
        button.addActionListener(evt -> this.type(digit));
        this.numberButtonsPanel.add(button);
    }

    protected void makeControlBoxButton(JToggleButton controlBoxButton, ControlBoxType type) {
        if (type == ControlBoxType.STANDARD) {
            controlBoxButton.setText("Standard");
            controlBoxButton.setMaximumSize(new Dimension(100, 45));
            controlBoxButton.setPreferredSize(new Dimension(100, 45));
            controlBoxButton.setMinimumSize(new Dimension(100, 45));
        } else {
            controlBoxButton.setText(type.name().replace("_", " "));
            controlBoxButton.setMaximumSize(new Dimension(97, 45));
            controlBoxButton.setPreferredSize(new Dimension(97, 45));
            controlBoxButton.setMinimumSize(new Dimension(97, 45));
        }
        controlBoxButton.setFocusable(false);
        controlBoxButton.addActionListener(evt -> {
            ControlBoxType controlBoxType2 = this.contolBoxType = type;
        });
        this.controlBoxTypeGroup.add(controlBoxButton);
        this.controlBoxTypePanel.add(controlBoxButton);
    }

    protected abstract void addAllPanels(int var1);

    public void enter(Object o) {
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(SerialNumberScreen.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        Optional frame = JFrameUtils.getParentFrame();
        if (frame.isPresent()) {
            this.resizeListener = new ResizePanelListener(350);
            this.frameInstance = (JFrame)frame.get();
            this.frameInstance.addComponentListener(this.resizeListener);
            int leftPos = (this.frameInstance.getWidth() - 350) / 2;
            this.addAllPanels(leftPos);
        }
    }

    public Object exit() {
        if (this.frameInstance != null) {
            this.frameInstance.removeComponentListener(this.resizeListener);
        }
        return super.exit();
    }

    public void update() {
        RobotTypeIdentifier selectedType = this.findSelectedType();
        String expectedPattern = selectedType != null ? selectedType.expectedSerialPattern() : "";
        String enterSerialText = String.format("Enter robot serial number %s", expectedPattern.isEmpty() ? ":" : String.format(" (%s):", expectedPattern));
        this.serialTextLabel.setText(enterSerialText);
        this.serialField.requestFocus();
        this.selectedRobotChanged();
    }

    private void selectedRobotChanged() {
        RobotTypeIdentifier selectedType = this.findSelectedType();
        if (selectedType != null) {
            this.robotTypeId = selectedType;
        }
        this.updateTeachPendantComboBox();
        this.updateOKButton();
    }

    private void updateTeachPendantComboBox() {
        TPCapable tpCapable = this.findSelectedTpCapable();
        if (this.findSelectedType() == null || tpCapable == null) {
            this.tpTypeComboBox.setEnabled(false);
            return;
        }
        this.updateSupportedTeachPendants(tpCapable);
        this.tpTypeComboBox.setEnabled(true);
    }

    private void updateSupportedTeachPendants(TPCapable tpCapable) {
        this.tpTypeComboBox.setModel(new DefaultComboBoxModel<TPType>(tpCapable.getSupportedTeachPendents()));
        this.tpTypeComboBox.setSelectedItem((Object)(this.initialTPType != null ? this.initialTPType : tpCapable.getDefaultTeachPendent()));
    }

    private void updateOKButton() {
        this.okButton.setEnabled(this.findSelectedType() != null);
    }

    private TPCapable findSelectedTpCapable() {
        for (TPCapable tpCapable : this.tpCapabilities) {
            if (!tpCapable.supportsRobotType(this.robotTypeId.getRobotTypeId())) continue;
            return tpCapable;
        }
        return null;
    }

    private RobotTypeIdentifier findSelectedType() {
        RobotTypeIdentifier result = null;
        for (RobotTypeIdentifier type : this.robotTypeIdentifiers) {
            if (!type.isValidSerial(this.serialField.getText())) continue;
            result = type;
            break;
        }
        return result;
    }

    private void type(String s) {
        int position = this.serialField.getCaretPosition();
        try {
            this.serialField.getDocument().insertString(position, s, null);
        }
        catch (BadLocationException ex) {
            LOG.error("Error in serial number insert position: %s", new Object[]{ex.getMessage()});
        }
        this.serialField.requestFocusInWindow();
    }

    public String toString() {
        return SerialNumberScreen.class.getName();
    }

    private class ResizePanelListener
    extends ComponentAdapter {
        private final int buttonPanelAppxWidth;

        public ResizePanelListener(int buttonPanelAppxWidth) {
            this.buttonPanelAppxWidth = buttonPanelAppxWidth;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int leftPos = (SerialNumberScreen.this.frameInstance.getWidth() - this.buttonPanelAppxWidth) / 2;
            SerialNumberScreen.this.addAllPanels(leftPos);
        }
    }
}

