/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.swing.BaseView;
import com.ur.swing.ViewContext;
import com.ur.swing.card.EnterExitCard;
import com.ur.util.event.EventManager;
import com.ur.view.gui.tables.VariablesTable;
import com.ur.view.gui.tables.VariablesTableModel;
import com.ur.view.gui.tables.VariablesTablePanel;
import com.ur.view.variables.MiscVariable;
import com.ur.view.variables.VariableDisplayStrategy;
import com.ur.view.variables.VariablesDisplayListener;
import com.ur.view.variables.VariablesServer;
import com.ur.view.variables.core.Variable;
import gui.polyscope.program.ProgramTreeChangeObserver;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;

abstract class AbstractVariablesView
extends BaseView
implements EnterExitCard,
VariablesDisplayListener {
    private static final String VARIABLES_CARD = "variables";
    private final VariablesServer variablesServer;
    private final ViewContext viewContext;
    private final VariableDisplayStrategy variableDisplayStrategy;
    private final EventManager eventManager;
    protected VariablesTable variablesTable;
    private Variable selectedVariable;
    private boolean showOnlyFavorite;
    private boolean showWaypoints;
    private boolean forceSetVariables = false;

    protected AbstractVariablesView(ViewContext viewContext, VariablesServer variablesServer, EventManager eventManager, VariableDisplayStrategy variableDisplayStrategy) {
        this.viewContext = viewContext;
        this.variablesServer = variablesServer;
        this.variableDisplayStrategy = variableDisplayStrategy;
        this.eventManager = eventManager;
        this.addListener(eventManager);
    }

    protected void initTable() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.variablesTable = new VariablesTable();
        this.variablesTable.setModel(new VariablesTableModel(this.variablesServer, textResource, this.eventManager));
        this.variablesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int selectedRow = AbstractVariablesView.this.variablesTable.getSelectedRow();
                if (selectedRow >= 0) {
                    AbstractVariablesView.this.selectedVariable = AbstractVariablesView.this.variablesTable.getVariableAt(selectedRow);
                } else {
                    AbstractVariablesView.this.selectedVariable = null;
                }
            }
        });
        VariablesTablePanel scrollableVariablesTable = VariablesTablePanel.createTableWithThreeColumns(this.variablesTable);
        scrollableVariablesTable.addMouseListenerToScrollPane(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractVariablesView.this.variablesTable.clearSelection();
                AbstractVariablesView.this.selectedVariable = null;
            }
        });
        scrollableVariablesTable.addColumnCollapseButton();
        this.add(scrollableVariablesTable, VARIABLES_CARD);
        this.variablesTable.tableChanged(new TableModelEvent(this.variablesTable.getModel()));
    }

    public <K, V> Map<K, V> cloneMap(Map<K, V> original) {
        return new HashMap<K, V>(original);
    }

    @Override
    public void variablesChanged(Collection<NamedEntity> namedEntities, Map<String, String> globalVariables) {
        SwingUtilities.invokeLater(() -> {
            ArrayList<Variable> filteredVars = this.filterVariables(namedEntities, this.cloneMap(globalVariables));
            if (this.forceSetVariables) {
                ((VariablesTableModel)this.variablesTable.getModel()).forceSetVariables(filteredVars);
                this.forceSetVariables = false;
            } else {
                ((VariablesTableModel)this.variablesTable.getModel()).setVariables(filteredVars);
            }
            this.setSelectionIfThereIsAnythingToSelect();
        });
    }

    public void setShowOnlyFavorite(boolean showOnlyFavorite) {
        this.showOnlyFavorite = showOnlyFavorite;
        this.variablesServer.updateModels();
    }

    public void setShowWaypoints(boolean showWaypoint) {
        this.showWaypoints = showWaypoint;
        this.variablesServer.updateModels();
    }

    public boolean isShowOnlyFavorite() {
        return this.showOnlyFavorite;
    }

    public boolean isShowWaypoints() {
        return this.showWaypoints;
    }

    private void setSelectionIfThereIsAnythingToSelect() {
        int selectedRow = -1;
        if (this.selectedVariable != null) {
            selectedRow = this.variablesTable.getRow(this.selectedVariable);
        }
        if (selectedRow >= 0 && selectedRow <= this.variablesTable.getRowCount()) {
            this.variablesTable.setRowSelectionInterval(selectedRow, selectedRow);
        } else {
            this.variablesTable.clearSelection();
        }
    }

    private void addListener(EventManager eventManager) {
        eventManager.addStrongListener(ProgramTreeChangeObserver.class, event -> SwingUtilities.invokeLater(() -> {
            boolean bl = this.forceSetVariables = true;
        }));
    }

    protected ArrayList<Variable> filterVariables(Collection<NamedEntity> namedEntities, Map<String, String> globalVariables) {
        Map<String, String> filteredGlobals = this.variableDisplayStrategy.filterVariables(globalVariables, this.showWaypoints);
        ArrayList<Variable> filteredVariables = new ArrayList<Variable>();
        namedEntities.forEach(namedEntity -> {
            if (filteredGlobals.containsKey(namedEntity.getName())) {
                filteredGlobals.remove(namedEntity.getName());
                Variable variable = (Variable)namedEntity;
                if (!this.showOnlyFavorite || variable.isFavourite()) {
                    filteredVariables.add(variable);
                }
            }
        });
        if (!this.showOnlyFavorite) {
            filteredGlobals.forEach((key, value) -> {
                boolean bl = filteredVariables.add(new MiscVariable((String)key));
            });
        } else if (this.showWaypoints) {
            this.variableDisplayStrategy.getWaypointNames().forEach(waypointName -> {
                if (filteredGlobals.containsKey(waypointName)) {
                    filteredVariables.add(new MiscVariable((String)waypointName));
                }
            });
        }
        return filteredVariables;
    }
}

