/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.ur.lang.DecimalFormatFactory;
import com.ur.util.logging.Log;
import com.ur.view.constants.runtime.RuntimeVariableType;
import com.ur.view.variables.ProgramMessage;
import com.ur.view.variables.VariableMessageConsumer;
import com.ur.view.variables.VariableUpdateStatistics;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class GlobalVariablesUpdateMessage
extends ProgramMessage
implements VariableMessageConsumer.Parser {
    private static final DecimalFormat DF = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"#.#####", (Locale)Locale.ENGLISH);
    private static final RuntimeVariableType[] RUNTIME_TYPE_FAST_MAP = new RuntimeVariableType[RuntimeVariableType.values().length];
    public List<String> values = new ArrayList<String>();
    public int start_index;
    private int offset;

    static {
        RuntimeVariableType[] runtimeVariableTypeArray = RuntimeVariableType.values();
        int n = runtimeVariableTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuntimeVariableType each;
            GlobalVariablesUpdateMessage.RUNTIME_TYPE_FAST_MAP[each.getId()] = each = runtimeVariableTypeArray[n2];
            ++n2;
        }
    }

    public GlobalVariablesUpdateMessage(long timestamp) {
        super(timestamp);
    }

    @Override
    public GlobalVariablesUpdateMessage parse(DataInput dataInputStream, int payloadLength, VariableUpdateStatistics statistics) throws IOException {
        if (payloadLength < 2) {
            Log.error((String)"Not a valid GlobalVariableUpdateMessage");
            return null;
        }
        byte[] buffer = new byte[payloadLength];
        dataInputStream.readFully(buffer);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        this.start_index = in.readUnsignedShort();
        if (!statistics.canParse(this.start_index)) {
            return this;
        }
        this.offset = 2;
        while (this.offset < payloadLength) {
            String value = this.parseInternal(in);
            in.skipBytes(1);
            this.offset += 2;
            this.values.add(value);
        }
        return this;
    }

    private String parseInternal(DataInput dataInputStream) throws IOException {
        String value = null;
        switch (RUNTIME_TYPE_FAST_MAP[dataInputStream.readByte()]) {
            case NONE: {
                break;
            }
            case CONST_STRING: 
            case VAR_STRING: {
                value = this.parseString(dataInputStream);
                break;
            }
            case LIST: {
                value = this.parseList(dataInputStream);
                break;
            }
            case MATRIX: {
                value = this.parseMatrix(dataInputStream);
                break;
            }
            case POSE: {
                value = this.parsePose(dataInputStream);
                break;
            }
            case BOOL: {
                value = this.parseBool(dataInputStream);
                break;
            }
            case INT: {
                value = this.parseInt(dataInputStream);
                break;
            }
            case NUM: 
            case FLOAT: {
                value = this.parseFloat(dataInputStream);
                break;
            }
            default: {
                dataInputStream.readByte();
                ++this.offset;
                value = "<type not serializable>";
            }
        }
        return value;
    }

    private String parseFloat(DataInput dataInputStream) throws IOException {
        this.offset += 4;
        return DF.format(dataInputStream.readFloat());
    }

    private String parseString(DataInput dataInputStream) throws IOException {
        short length = dataInputStream.readShort();
        this.offset += 2;
        byte[] bytes = new byte[length];
        dataInputStream.readFully(bytes);
        String value = new String(bytes, "UTF-8");
        value = "\"" + StringUtils.replaceEach((String)value, (String[])new String[]{"\t", "\b", "\n", "\r", "\f"}, (String[])new String[]{"\\t", "\\b", "\\n", "\\r", "\\f"}) + "\"";
        this.offset += length;
        return value;
    }

    private String parseList(DataInput dataInputStream) throws IOException {
        int length = dataInputStream.readShort();
        this.offset += 2;
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        int i = 0;
        while (i < length) {
            sb.append(this.parseInternal(dataInputStream));
            if (i < length - 1) {
                sb.append(", ");
            }
            ++this.offset;
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private String parseMatrix(DataInput dataInputStream) throws IOException {
        int m = dataInputStream.readShort();
        this.offset += 2;
        int n = dataInputStream.readShort();
        this.offset += 2;
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        int i = 0;
        while (i < m) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("[");
            int j = 0;
            while (j < n) {
                if (j != 0) {
                    sb.append(", ");
                }
                sb.append(this.parseInternal(dataInputStream));
                ++this.offset;
                ++j;
            }
            sb.append(']');
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private String parsePose(DataInput dataInputStream) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        sb.append("p[");
        int i = 0;
        while (i < 5) {
            sb.append(DF.format(dataInputStream.readFloat())).append(", ");
            ++i;
        }
        sb.append(DF.format(dataInputStream.readFloat())).append("]");
        this.offset += 24;
        return sb.toString();
    }

    private String parseBool(DataInput dataInputStream) throws IOException {
        ++this.offset;
        return dataInputStream.readByte() != 0 ? "True" : "False";
    }

    private String parseInt(DataInput dataInputStream) throws IOException {
        this.offset += 4;
        return String.valueOf(dataInputStream.readInt());
    }
}

