/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.ur.lang.EqualsUtil;
import com.ur.lang.NamingUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamedEntityCollection;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.reference.NameReference;
import com.ur.swing.expression.Expression;
import com.ur.view.variables.ReferenceToInstallation;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.Variable;
import java.util.List;
import javax.inject.Inject;

@ReferenceToInstallation
public class InstallationVariableReference
extends NameReference<InstallationVariable>
implements Variable {
    private final NamingService namingService;

    @Inject
    public InstallationVariableReference(String name, NamingService namingService) {
        super(name);
        this.namingService = namingService;
    }

    public InstallationVariable dereference() {
        InstallationVariable result = this.findVariableByExactMatchOfName();
        if (result == null) {
            result = this.findSimilarlyNamedInstallationVariable();
        }
        return result;
    }

    private InstallationVariable findVariableByExactMatchOfName() {
        InstallationVariable result = null;
        List entities = this.namingService.getEntitiesWithName(this.getKey());
        for (NamedEntity each : entities) {
            if (!(each instanceof InstallationVariable)) continue;
            result = (InstallationVariable)each;
        }
        return result;
    }

    private InstallationVariable findSimilarlyNamedInstallationVariable() {
        InstallationVariable result = null;
        NamedEntityCollection allEntities = this.namingService.getAllEntities();
        NamedEntityCollection filterByType = allEntities.filterByType(InstallationVariable.class);
        for (NamedEntity each : filterByType.getFilteredCollection()) {
            String nameWithoutNumberSequence = NamingUtils.stripNumbersOffEndOfName((String)each.getName());
            if (!nameWithoutNumberSequence.equals(this.getKey())) continue;
            result = (InstallationVariable)each;
            this.namingService.setNameOfEntity((NamedEntity)result, this.getKey());
            break;
        }
        return result;
    }

    public String getName() {
        return this.getKey();
    }

    public void setName(String newName) {
        InstallationVariable installationVariable = this.dereference();
        if (installationVariable != null) {
            installationVariable.setName(newName);
        }
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!EqualsUtil.equals((Object)this.getName(), (Object)entityToCompareTo.getName())) {
            return false;
        }
        if (entityToCompareTo instanceof InstallationVariable) {
            return EqualsUtil.equals((Object)this.dereference(), (Object)entityToCompareTo);
        }
        if (entityToCompareTo instanceof InstallationVariableReference) {
            return EqualsUtil.equals((Object)this.dereference(), (Object)((InstallationVariableReference)entityToCompareTo).dereference());
        }
        return false;
    }

    @Override
    public String getScriptName() {
        return ScriptConverter.toScriptCode((String)this.getName(), (boolean)false);
    }

    @Override
    public boolean prefersPersistentValue() {
        return true;
    }

    @Override
    public void setPrefersPersistentValue(boolean persistencePreference) {
    }

    @Override
    public boolean hasExpression() {
        return false;
    }

    @Override
    public Expression getExpression() {
        return null;
    }

    @Override
    public boolean isUndefined() {
        return this.dereference() == null;
    }

    @Override
    public boolean isFavourite() {
        InstallationVariable installationVariable = this.dereference();
        return installationVariable != null && installationVariable.isFavourite();
    }

    @Override
    public void setIsFavourite(boolean isFavourite) {
        InstallationVariable installationVariable = this.dereference();
        if (installationVariable != null) {
            installationVariable.setIsFavourite(isFavourite);
        }
    }

    @Override
    public String getDescription() {
        InstallationVariable installationVariable = this.dereference();
        if (installationVariable != null) {
            return installationVariable.getDescription();
        }
        return "";
    }

    @Override
    public void setDescription(String description) {
        InstallationVariable installationVariable = this.dereference();
        if (installationVariable != null) {
            installationVariable.setDescription(description);
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isPoseOrJointVector() {
        InstallationVariable installationVariable = this.dereference();
        return installationVariable != null && (installationVariable.isPose() || installationVariable.isJointVector());
    }

    public boolean isNumber() {
        InstallationVariable installationVariable = this.dereference();
        return installationVariable != null && installationVariable.isNumber();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isRegistered() {
        return !this.isUndefined();
    }
}

