/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.util.event.EventNotificationService;
import com.ur.view.variables.VariableDisplayStrategy;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import gui.program.TimerNode;
import gui.program.TimerScriptGeneration;
import gui.program.position.WaypointNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;

public class VariableDisplayStrategyImpl
implements VariableDisplayStrategy {
    private static final String HIDDEN_GLOBALS_PREFIX = "_hidden_";
    protected ProgramLookupService programLookupService;
    private final List<String> waypointNames = new ArrayList<String>();
    private final List<String> timerVariableNamesForFiltering = new ArrayList<String>();

    @Inject
    public VariableDisplayStrategyImpl(ProgramLookupService programLookupService) {
        this.programLookupService = programLookupService;
        EventNotificationService.register((Object)this, ProgramStateListener.class, (oldState, newState) -> {
            if (oldState == ProgramState.STOPPED && newState == ProgramState.PLAYING) {
                this.waypointNames.clear();
                this.waypointNames.addAll(this.getWaypointNamesForFiltering());
                this.timerVariableNamesForFiltering.clear();
                this.timerVariableNamesForFiltering.addAll(this.getTimerVariableNamesForFiltering());
            }
        });
    }

    @Override
    public Map<String, String> filterVariables(Map<String, String> inputMap, boolean showWaypoints) {
        HashSet<String> filteredNames = new HashSet<String>();
        if (!showWaypoints) {
            filteredNames.addAll(this.waypointNames);
        }
        filteredNames.addAll(this.timerVariableNamesForFiltering);
        Predicate<Map.Entry> exactNamePredicate = entry -> !filteredNames.contains(entry.getKey());
        Predicate<Map.Entry> prefixPredicate = entry -> !((String)entry.getKey()).startsWith(HIDDEN_GLOBALS_PREFIX);
        return Maps.filterEntries(inputMap, exactNamePredicate.and(prefixPredicate)::test);
    }

    protected List<String> getWaypointNamesForFiltering() {
        ProgramRootNode program = this.programLookupService.getProgramRootNode();
        ArrayList<String> programWaypointNames = new ArrayList<String>();
        if (program != null) {
            Enumeration enumeration = program.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object element = enumeration.nextElement();
                if (!(element instanceof WaypointNode)) continue;
                String baseName = ((WaypointNode)element).getName();
                programWaypointNames.add(this.getScriptName(String.valueOf(baseName) + "_p"));
                programWaypointNames.add(this.getScriptName(String.valueOf(baseName) + "_q"));
                programWaypointNames.add(this.getScriptName(String.valueOf(baseName) + "_from_p"));
                programWaypointNames.add(this.getScriptName(String.valueOf(baseName) + "_to_p"));
            }
        }
        return programWaypointNames;
    }

    private List<String> getTimerVariableNamesForFiltering() {
        ArrayList result = Lists.newArrayList();
        ProgramRootNode programRootNode = this.programLookupService.getProgramRootNode();
        if (programRootNode != null) {
            Enumeration nodes = programRootNode.breadthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                Object node = nodes.nextElement();
                if (!(node instanceof TimerNode)) continue;
                String name = ((TimerNode)node).getVariableName();
                result.add(TimerScriptGeneration.getTimerIsCountingVariableName(name));
            }
        }
        return result;
    }

    private String getScriptName(String base) {
        return ScriptConverter.toScriptCode((String)base, (boolean)false);
    }

    @Override
    public List<String> getWaypointNames() {
        return this.waypointNames;
    }
}

