/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.util.logging.Log;
import com.ur.view.constants.comm.MessageType;
import com.ur.view.constants.comm.ProgramStateMessageType;
import com.ur.view.variables.GlobalVariablesSetupMessage;
import com.ur.view.variables.GlobalVariablesUpdateMessage;
import com.ur.view.variables.ProgramMessage;
import com.ur.view.variables.VariableUpdateMessage;
import com.ur.view.variables.VariableUpdateStatistics;
import com.ur.view.variables.VariablesStateCallback;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class VariableMessageConsumer
implements MessageConsumer {
    private VariablesStateCallback messageListener;
    private VariableUpdateStatistics variableUpdateStatistics;

    @Inject
    private VariableMessageConsumer(VariablesStateCallback messageListener, VariableUpdateStatistics variableUpdateStatistics) {
        this.messageListener = messageListener;
        this.variableUpdateStatistics = variableUpdateStatistics;
    }

    public MessageType getPackageType() {
        return MessageType.PROGRAM_STATE_MESSAGE;
    }

    public int consume(DataInput dataInputStream, int messageLength) throws IOException {
        byte subtype;
        ProgramStateMessageType psSubtype;
        if (messageLength < 9) {
            Log.error((String)"PROGRAM_STATE_MESSAGE is invalid");
            return 0;
        }
        int offset = 9;
        long timestamp = dataInputStream.readLong();
        Parser parser = this.getMessageParser(timestamp, psSubtype = ProgramStateMessageType.byId((int)(subtype = dataInputStream.readByte())));
        if (parser == null) {
            int prevMessageType = -1;
            Log.error((String)("Unknown program message subtype " + subtype + " (previous message type was " + prevMessageType + ")"));
            return 0;
        }
        ProgramMessage message = parser.parse(dataInputStream, messageLength - offset, this.variableUpdateStatistics);
        this.handleProgramMessage(message, psSubtype);
        return messageLength;
    }

    private Parser getMessageParser(long timestamp, ProgramStateMessageType psSubtype) {
        switch (psSubtype) {
            case GLOBAL_VARIABLES_UPDATE: {
                return new GlobalVariablesUpdateMessage(timestamp);
            }
            case GLOBAL_VARIABLES_SETUP: {
                return new GlobalVariablesSetupMessage(timestamp);
            }
            case VARIABLE_UPDATE: {
                return new VariableUpdateMessage(timestamp);
            }
        }
        return null;
    }

    private void handleProgramMessage(ProgramMessage programMessage, ProgramStateMessageType psSubtype) {
        switch (psSubtype) {
            case GLOBAL_VARIABLES_UPDATE: {
                this.messageListener.handleGlobalVariablesUpdateMessage((GlobalVariablesUpdateMessage)programMessage);
                break;
            }
            case GLOBAL_VARIABLES_SETUP: {
                this.messageListener.handleGlobalVariablesSetupMessage((GlobalVariablesSetupMessage)programMessage);
                break;
            }
            case VARIABLE_UPDATE: {
                this.messageListener.handleVariableUpdateMessage((VariableUpdateMessage)programMessage);
            }
        }
    }

    public void initialize(RobotState robotStateToEditHere) {
    }

    static interface Parser {
        public ProgramMessage parse(DataInput var1, int var2, VariableUpdateStatistics var3) throws IOException;
    }
}

