/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.google.inject.TypeLiteral;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.naming.NamedEntitySource;
import com.ur.lang.naming.NamingStrategy;
import com.ur.lang.naming.NamingStrategyProvider;
import com.ur.lang.react.Recipe;
import com.ur.polyscope.controllerinterface.MessageConsumer;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.domain.PreSetInstallation;
import com.ur.polyscope.program.monitor.VariablesStateInfo;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.view.polyscope.persistence.installation.PersistDelegator;
import com.ur.view.variables.InstallationVariableNamedEntitySource;
import com.ur.view.variables.VariableMessageConsumer;
import com.ur.view.variables.VariableUpdateStatistics;
import com.ur.view.variables.VariableUpdateStatisticsImpl;
import com.ur.view.variables.VariablesRawStateConsumer;
import com.ur.view.variables.VariablesServer;
import com.ur.view.variables.VariablesStateCallback;
import com.ur.view.variables.VariablesStateInfoModelSourceImpl;
import com.ur.view.variables.VariablesValues;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.domain.VariableLookupService;
import com.ur.view.variables.externalapi.VariableNamingStrategy;
import com.ur.view.variables.infrastructure.FilePersistence;
import com.ur.view.variables.infrastructure.ImprovedInstallationVariablesMenuExtension;
import com.ur.view.variables.infrastructure.Persistence;
import com.ur.view.variables.infrastructure.SaveInstallationVariablesForOldInstallation;
import com.ur.view.variables.infrastructure.SaveInstallationVariablesOnInterval;
import com.ur.view.variables.infrastructure.VariableLookupServiceImpl;
import com.ur.view.variables.validation.ExpressionValidationStrategy;
import com.ur.view.variables.validation.ExpressionValueValidator;
import gui.tools.URFileUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VariableServiceBinder
implements ServicesBinder {
    public void bind(Binder binder) {
        binder.bindToExtensionPoint(MessageConsumer.class, VariableMessageConsumer.class);
        binder.bindClass(VariablesStateCallback.class, VariablesServer.class);
        binder.bindClass(VariablesValues.class, VariablesServer.class);
        binder.bindClass(VariableLookupService.class, VariableLookupServiceImpl.class);
        binder.bindClass(VariableUpdateStatistics.class, VariableUpdateStatisticsImpl.class);
        binder.bindToExtensionPoint(NamingStrategy.class, VariableNamingStrategy.class);
        binder.bindToExtensionPoint(PreSetInstallation.class, SaveInstallationVariablesForOldInstallation.class);
        binder.bindToExtensionPoint(NamedEntitySource.class, InstallationVariableNamedEntitySource.class);
        binder.bindClass(Persistence.class, FilePersistence.class);
        binder.bindInstance(URFileUtils.Facade.class, (Object)new URFileUtils.DefaultFacade());
        binder.bindToExtensionPoint(PersistDelegator.class, FilePersistence.class);
        binder.bindToExtensionPoint(InstallationComponent.class, InstallationVariables.class);
        binder.bindInstanceWithQualifier(ValidationStrategy.class, (Object)new ValidationStrategy.Composite(new ValidationStrategy[]{ValidationFactory.getExpressionValueValidator(), new ExpressionValidationStrategy()}), ExpressionValueValidator.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<VariablesStateInfo>>(){}, VariablesStateInfoModelSourceImpl.class);
        binder.bindClass(VariablesRawStateConsumer.class, VariablesStateInfoModelSourceImpl.class);
        binder.bindToExtensionPoint(MenuExtension.class, ImprovedInstallationVariablesMenuExtension.class);
    }

    public void load(Builder builder) {
        NamingStrategyProvider namingStrategyProvider = (NamingStrategyProvider)builder.get(NamingStrategyProvider.class);
        namingStrategyProvider.add((NamingStrategy)builder.get(VariableNamingStrategy.class));
        builder.get(SaveInstallationVariablesOnInterval.class);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        VariablesRawStateConsumer variablesRawStateConsumer = (VariablesRawStateConsumer)builder.get(VariablesRawStateConsumer.class);
        EventNotificationService.register((Object)variablesRawStateConsumer, VariablesServer.VariablesDisplayEventListener.class, variablesMap -> executorService.execute(() -> variablesRawStateConsumer.emit(variablesMap)));
    }
}

