/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.google.inject.Inject;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.view.program.ProgramControl;
import com.ur.view.variables.VariableUpdateStatistics;

public class VariableUpdateStatisticsImpl
implements VariableUpdateStatistics {
    private ProgramControl programControl;
    private static final int THROTTLING_STEP = 100;
    private int parseCount;
    private int dropFactor;
    private static final int[] DROP_MESSAGE_AT_COUNTER = new int[]{10, 5, 2, 7, 3, 8, 4, 9, 6};

    @Inject
    public VariableUpdateStatisticsImpl(ProgramControl programControl) {
        this.programControl = programControl;
    }

    @Override
    public void resetStatistics(int var_count) {
        this.dropFactor = Math.min(var_count / 100, DROP_MESSAGE_AT_COUNTER.length);
        this.parseCount = 0;
    }

    @Override
    public boolean canParse(int start_index) {
        if (this.dropFactor == 0 || ProgramState.STOPPED.equals((Object)this.programControl.getProgramState())) {
            return true;
        }
        if (start_index == 0) {
            ++this.parseCount;
            if (this.parseCount > DROP_MESSAGE_AT_COUNTER.length + 1) {
                this.parseCount = 1;
            }
        }
        boolean result = true;
        int i = 0;
        while (i < this.dropFactor) {
            result &= DROP_MESSAGE_AT_COUNTER[i] != this.parseCount;
            ++i;
        }
        return result;
    }
}

