/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.ur.i18n.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.view.variables.VariablesTabView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class VariableValuesTab
extends CardPanel {
    private static final String SHOW_FAVORITE = "VariableValuesTab.showFavorite";
    private static final String SHOW_WAYPOINT = "VariableValuesTab.showWaypoint";
    private final VariablesTabView variablesTabView;
    private final ViewContext viewContext;
    private final TextResource textResource;
    private JCheckBox showWaypointVariables;
    private JCheckBox showFavoriteVariables;

    @Inject
    public VariableValuesTab(ViewContext viewContext, VariablesTabView variablesTabView) {
        this.variablesTabView = variablesTabView;
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
    }

    public String toString() {
        return "G5VariablesValueTab";
    }

    public void enter(Object o) {
        super.enter(o);
        this.showWaypointVariables.setSelected(this.variablesTabView.isShowWaypoints());
        this.showFavoriteVariables.setSelected(this.variablesTabView.isShowOnlyFavorite());
        this.variablesTabView.enter(o);
    }

    public Object exit() {
        this.variablesTabView.exit();
        return super.exit();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(UIManager.getColor("CardPanel.background"));
        JPanel controlsPanel = this.createControlsPanel();
        JPanel content = new JPanel(new BorderLayout());
        content.setBackground(Color.WHITE);
        content.setLayout(new BorderLayout());
        content.add((Component)((Object)this.variablesTabView), "Center");
        content.add((Component)controlsPanel, "South");
        this.add(content, "Center");
    }

    private ActionListener createActionListener(JCheckBox showWaypointVariables) {
        return actionEvent -> this.variablesTabView.setShowWaypoints(showWaypointVariables.isSelected());
    }

    private JPanel createControlsPanel() {
        JPanel controlsPanel = new JPanel();
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        controlsPanel.setLayout(new BorderLayout());
        controlsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.createShowWaypointCheckBox(widgetFactory, this.textResource);
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BorderLayout());
        subPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel waypointSubPanel = new JPanel();
        waypointSubPanel.setLayout(new BorderLayout());
        waypointSubPanel.add((Component)this.showWaypointVariables, "West");
        subPanel.add((Component)waypointSubPanel, "North");
        this.createShowFavoriteCheckBox(widgetFactory, this.textResource);
        subPanel.add((Component)this.showFavoriteVariables, "South");
        controlsPanel.add((Component)subPanel, "West");
        return controlsPanel;
    }

    private void createShowFavoriteCheckBox(WidgetFactory widgetFactory, TextResource textResource) {
        this.showFavoriteVariables = widgetFactory.createCheckBox(textResource.ShowFavorite());
        this.showFavoriteVariables.addActionListener(actionEvent -> this.variablesTabView.setShowOnlyFavorite(this.showFavoriteVariables.isSelected()));
        this.showFavoriteVariables.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.showFavoriteVariables.setName(SHOW_FAVORITE);
    }

    private void createShowWaypointCheckBox(WidgetFactory widgetFactory, TextResource textResource) {
        this.showWaypointVariables = widgetFactory.createCheckBox(textResource.ShowWaypoints());
        this.showWaypointVariables.addActionListener(this.createActionListener(this.showWaypointVariables));
        this.showWaypointVariables.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.showWaypointVariables.setName(SHOW_WAYPOINT);
    }
}

