/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.google.common.collect.Maps;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.view.gui.threading.MinimumDelayBetweenRunsExecutor;
import com.ur.view.variables.GlobalVariablesSetupMessage;
import com.ur.view.variables.GlobalVariablesUpdateMessage;
import com.ur.view.variables.ProgramMessage;
import com.ur.view.variables.VariableUpdateMessage;
import com.ur.view.variables.VariablesDisplayListener;
import com.ur.view.variables.VariablesServerInstallationListener;
import com.ur.view.variables.VariablesServerListener;
import com.ur.view.variables.VariablesStateCallback;
import com.ur.view.variables.VariablesValues;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.domain.VariableLookupService;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

@Singleton
public class VariablesServer
implements VariablesStateCallback,
VariablesValues {
    private static final long STATE_UPDATE_INTERVAL_MS = 250L;
    private static final long DEFAULT_VERIFICATION_TIMESTAMP = 1L;
    private final InstallationComponentLookup lookupService;
    private final MinimumDelayBetweenRunsExecutor updateModelRunnable;
    private List<String> globalVariableNames = new ArrayList<String>();
    final Map<String, String> variablesMap = new TreeMap<String, String>();
    private final VariableLookupService variableLookupService;
    private long programVerificationTimestamp = 1L;
    private boolean hasRecievedVariableUpdateMessage = false;

    @Inject
    public VariablesServer(InstallationComponentLookup lookupService, EventManager manager, VariableLookupService vls) {
        this.lookupService = lookupService;
        this.variableLookupService = vls;
        VariablesServerListener listener = new VariablesServerListener(this);
        VariablesServerInstallationListener installationListener = new VariablesServerInstallationListener(this);
        manager.addWeakListener((Object)this, InstallationStateListener.class, (Object)installationListener);
        manager.addWeakListener((Object)this, ProgramEventListener.class, (Object)listener);
        this.updateModelRunnable = new MinimumDelayBetweenRunsExecutor(() -> SwingUtilities.invokeLater(this::updateModels));
    }

    @Override
    public String getValue(String name) {
        return this.variablesMap.get(name);
    }

    public Map<String, String> getVariables() {
        return this.getVariablesWithRealNames();
    }

    private Map<String, String> getVariablesWithRealNames() {
        HashMap variablesMapCopy = Maps.newHashMap();
        SwingUtil.invokeAndWait(() -> {
            Map<String, String> varMap = VariablesServer.createScriptNameToNameMap(this.variableLookupService.getAllNamedEntities());
            for (Map.Entry<String, String> entry : this.variablesMap.entrySet()) {
                String varName = varMap.get(entry.getKey());
                if (varName == null) {
                    varName = entry.getKey();
                }
                variablesMapCopy.put(varName, entry.getValue());
            }
        });
        return variablesMapCopy;
    }

    public void clear() {
        SwingUtilities.invokeLater(() -> {
            this.variablesMap.clear();
            this.updateModels();
        });
    }

    public void clearBeforeNewProgramOrInstallation() {
        SwingUtilities.invokeLater(() -> {
            this.variablesMap.clear();
            this.updateModels();
            this.programVerificationTimestamp = 1L;
        });
    }

    @Override
    public void handleGlobalVariablesUpdateMessage(GlobalVariablesUpdateMessage updateMessage) {
        SwingUtilities.invokeLater(() -> {
            if (!this.containsVerificationTimestamp(updateMessage)) {
                return;
            }
            List<String> globalVariablesToUpdate = this.globalVariableNames.subList(globalVariablesUpdateMessage.start_index, this.globalVariableNames.size());
            List<String> newValues = globalVariablesUpdateMessage.values;
            Iterator<String> iterator = globalVariablesToUpdate.iterator();
            InstallationVariables installationVariables = (InstallationVariables)this.lookupService.getComponent(InstallationVariables.class);
            boolean atleastOneVariableChanged = false;
            int index = 0;
            while (iterator.hasNext() && index < newValues.size()) {
                String variableName = iterator.next();
                String oldValue = this.variablesMap.get(variableName);
                String newValue = newValues.get(index);
                if (newValue != null && !newValue.equals(oldValue)) {
                    atleastOneVariableChanged = true;
                    InstallationVariable v = installationVariables.getInstallationVariableByName(variableName);
                    if (v != null) {
                        v.setValue(newValue);
                    }
                    this.variablesMap.put(variableName, newValues.get(index));
                }
                ++index;
            }
            if (atleastOneVariableChanged) {
                this.updateModelRunnable.run(250L, true);
            }
        });
    }

    @Override
    public void handleGlobalVariablesSetupMessage(GlobalVariablesSetupMessage setupMessage) {
        SwingUtilities.invokeLater(() -> {
            try {
                List<String> newNames = globalVariablesSetupMessage.variableNames;
                if (this.setupMessageIsValid(setupMessage, newNames)) {
                    InstallationVariables installationVariables = (InstallationVariables)this.lookupService.getComponent(InstallationVariables.class);
                    ArrayList<NamedEntity> vars = new ArrayList<NamedEntity>(installationVariables.getInstallationVariables());
                    Map<String, String> scriptNameToName = VariablesServer.createScriptNameToNameMap(vars);
                    for (String scriptName : newNames) {
                        String value;
                        String realVarName = scriptNameToName.get(scriptName);
                        InstallationVariable v = installationVariables.getInstallationVariableByName(scriptName);
                        if (v != null) {
                            value = v.getValue();
                            this.variablesMap.put(scriptName, value);
                            continue;
                        }
                        if (realVarName == null || (v = installationVariables.getInstallationVariableByName(realVarName)) == null) continue;
                        value = v.getValue();
                        this.variablesMap.put(scriptName, value);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Log.warning((String)"Concurrent modification when modifying list of vars");
            }
        });
    }

    @Override
    public void handleVariableUpdateMessage(VariableUpdateMessage message) {
        SwingUtilities.invokeLater(() -> {
            if (!this.hasRecievedVariableUpdateMessage) {
                Log.error((String)"VariablesServer: VariableUpdateMessages are deprecated");
                this.hasRecievedVariableUpdateMessage = true;
            }
            if (!this.globalVariableNames.contains(variableUpdateMessage.key)) {
                this.variablesMap.put(variableUpdateMessage.key, variableUpdateMessage.value);
            }
        });
    }

    private static Map<String, String> createScriptNameToNameMap(Collection<NamedEntity> allNamed) {
        HashMap<String, String> varMap = new HashMap<String, String>(allNamed.size());
        for (NamedEntity named : allNamed) {
            String varName = named.getName();
            String scriptName = ScriptConverter.toScriptCode((String)varName, (boolean)false);
            varMap.put(scriptName, varName);
        }
        return varMap;
    }

    private boolean setupMessageIsValid(GlobalVariablesSetupMessage setupMessage, List<String> newNames) {
        if (setupMessage.startIndex == 0) {
            if (!this.containsVerificationVariable(setupMessage)) {
                Log.info((String)"VariableServer: handleGlobalVariablesSetupMessage: setupMessage is discarded, missing verification.");
                return false;
            }
            this.programVerificationTimestamp = setupMessage.getTimestamp();
            this.globalVariableNames = newNames;
            this.variablesMap.clear();
        } else if (setupMessage.startIndex == this.globalVariableNames.size()) {
            if (!this.containsVerificationTimestamp(setupMessage)) {
                Log.info((String)"VariableServer: handleGlobalVariablesSetupMessage: setupMessage is discarded, missing timestamp.");
                return false;
            }
            this.globalVariableNames.addAll(newNames);
        } else {
            Log.error((String)"GlobalVariablesSetupMessage package missing in procedure");
            return false;
        }
        return true;
    }

    private boolean containsVerificationVariable(GlobalVariablesSetupMessage setupMessage) {
        return !setupMessage.variableNames.isEmpty() && "_hidden_verificationVariable".equals(setupMessage.variableNames.get(0));
    }

    private boolean containsVerificationTimestamp(ProgramMessage message) {
        return this.programVerificationTimestamp == message.getTimestamp();
    }

    public void updateModels() {
        Map<String, String> varMap2 = this.getVariablesWithRealNames();
        EventNotificationService.notify(VariablesDisplayEventListener.class, listener -> listener.variablesDisplayChanged(varMap2));
        EventNotificationService.notify(VariablesDisplayListener.class, listener -> listener.variablesChanged(this.variableLookupService.getAllNamedEntities(), varMap2));
    }

    public long getProgramVerificationTimestamp() {
        return this.programVerificationTimestamp;
    }

    public static class ClearAction
    extends AbstractActionDefinition {
        private final VariablesServer variablesServer;

        @Inject
        public ClearAction(VariablesServer variablesServer, TextResource text) {
            this.variablesServer = variablesServer;
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("Name", text.Clear());
        }

        public void actionPerformed(ActionEvent e) {
            this.variablesServer.clear();
        }
    }

    public static class DefaultVariablesTableModel
    extends AbstractTableModel {
        private final String[] headers;
        private String[][] values = new String[0][];

        public DefaultVariablesTableModel(TextResource textResource) {
            this.headers = new String[]{textResource.Variable(), textResource.Value()};
        }

        @Override
        public int getRowCount() {
            return this.values.length;
        }

        @Override
        public int getColumnCount() {
            return this.headers.length;
        }

        @Override
        public String getColumnName(int i) {
            return this.headers[i];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int i, int i1) {
            return this.values[i][i1];
        }

        public void setVariables(Map<String, String> map) {
            this.values = this.mapToArray(map);
            this.fireTableDataChanged();
        }

        private String[][] mapToArray(Map<String, String> map) {
            String[][] twoDarray = new String[map.size()][2];
            String[] keys = map.keySet().toArray(new String[0]);
            String[] strValues = map.values().toArray(new String[0]);
            int row = 0;
            while (row < twoDarray.length) {
                twoDarray[row][0] = keys[row];
                twoDarray[row][1] = strValues[row];
                ++row;
            }
            return twoDarray;
        }
    }

    public static interface VariablesDisplayEventListener
    extends EventListener {
        public void variablesDisplayChanged(Map<String, String> var1);
    }
}

