/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables;

import com.ur.polyscope.scriptconverter.ScriptConverter;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import gui.program.ScriptNode;
import gui.program.position.WaypointNode;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariablesUtility {
    private VariablesUtility() {
    }

    public static Set<String> getPossibleWaypointNames(ProgramLookupService programLookupService) {
        ProgramRootNode program = programLookupService.getProgramRootNode();
        HashSet<String> waypoints = new HashSet<String>();
        if (program != null) {
            Enumeration enumeration = program.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object element = enumeration.nextElement();
                if (!(element instanceof WaypointNode)) continue;
                String baseName = ((WaypointNode)element).getName();
                waypoints.add(VariablesUtility.getScriptName(String.valueOf(baseName) + "_p"));
                waypoints.add(VariablesUtility.getScriptName(String.valueOf(baseName) + "_q"));
                waypoints.add(VariablesUtility.getScriptName(String.valueOf(baseName) + "_from_p"));
                waypoints.add(VariablesUtility.getScriptName(String.valueOf(baseName) + "_to_p"));
            }
        }
        return waypoints;
    }

    public static Set<String> getPossibleScriptVariableNames(ProgramLookupService programLookupService) {
        ProgramRootNode program = programLookupService.getProgramRootNode();
        HashSet<String> scriptVariables = new HashSet<String>();
        if (program == null) {
            return scriptVariables;
        }
        Enumeration enumeration = program.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            if (!(element instanceof ScriptNode)) continue;
            Pattern pattern = Pattern.compile("global\\W+(\\w+)");
            Matcher matcher = ((ScriptNode)element).getType().equals((Object)ScriptNode.Type.LINE_TYPE) ? pattern.matcher(element.toString()) : pattern.matcher(((ScriptNode)element).getLoadedFileContents());
            while (matcher.find()) {
                scriptVariables.add(matcher.group(1));
            }
        }
        return scriptVariables;
    }

    private static String getScriptName(String base) {
        return ScriptConverter.toScriptCode((String)base, (boolean)false);
    }
}

