/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.core;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamedEntity;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.variables.core.InstallationVariableDescriptionChangedListener;
import com.ur.view.variables.core.InstallationVariableFavoriteChangedListener;
import com.ur.view.variables.core.InstallationVariableValueChangedListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class InstallationVariable
implements NamedEntity {
    private static final String NUMBER = "-?\\d*\\.?\\d+([eE]-?\\d+)?";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^(-?\\d*\\.?\\d+([eE]-?\\d+)?)$");
    private static final Pattern POSE_PATTERN = Pattern.compile("^(p\\[\\s*-?\\d*\\.?\\d+([eE]-?\\d+)?(\\s*,\\s*-?\\d*\\.?\\d+([eE]-?\\d+)?){5}\\s*\\])$");
    private static final Pattern JOINT_VECTOR_PATTERN = Pattern.compile("^(\\[\\s*-?\\d*\\.?\\d+([eE]-?\\d+)?(\\s*,\\s*-?\\d*\\.?\\d+([eE]-?\\d+)?){5}+\\s*\\])$");
    private String name;
    private String value;
    private String description;
    private boolean isFavourite;

    @Inject
    InstallationVariable() {
    }

    public InstallationVariable(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public InstallationVariable(String name, String value, String description, boolean isFavourite) {
        this.name = name;
        this.value = value;
        this.description = description;
        this.isFavourite = isFavourite;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.getName();
        this.name = newName;
        this.fireNameChangeEvent(newName, oldName);
    }

    public boolean sameAs(NamedEntity o) {
        return this.equals(o);
    }

    private void fireNameChangeEvent(String newName, String oldName) {
        EventNotificationService.notify(PropertyChangeListener.class, (NotificationStrategy)new NotificationStrategy<PropertyChangeListener>(oldName, newName){
            PropertyChangeEvent event;
            {
                this.event = new PropertyChangeEvent(InstallationVariable.this, "name", string, string2);
            }

            public void notify(PropertyChangeListener listener) {
                listener.propertyChange(this.event);
            }
        });
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (!EqualsUtil.equals((Object)this.value, (Object)value)) {
            this.value = value;
            EventNotificationService.notify(InstallationVariableValueChangedListener.class, listener -> listener.valueChanged(this));
        }
    }

    public boolean isNumber() {
        return NUMBER_PATTERN.matcher(this.value).matches();
    }

    public boolean isPose() {
        return POSE_PATTERN.matcher(this.value).matches();
    }

    public boolean isJointVector() {
        return JOINT_VECTOR_PATTERN.matcher(this.value).matches();
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode() + this.getValue().hashCode();
        if (this.getDescription() != null) {
            hashCode += this.getDescription().hashCode();
        }
        return hashCode += this.isFavourite ? 1 : 0;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(InstallationVariable.class)) {
            return false;
        }
        InstallationVariable other = (InstallationVariable)o;
        return EqualsUtil.equals((Object)this.getName(), (Object)other.getName()) && EqualsUtil.equals((Object)this.getDescription(), (Object)other.getDescription()) && EqualsUtil.equals((Object)this.getValue(), (Object)other.getValue()) && this.isFavourite() == other.isFavourite();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isFavourite() {
        return this.isFavourite;
    }

    public void setIsFavourite(boolean isFavourite) {
        if (this.isFavourite != isFavourite) {
            this.isFavourite = isFavourite;
            EventNotificationService.notify(InstallationVariableFavoriteChangedListener.class, installationVariableFavoriteChangedListener -> installationVariableFavoriteChangedListener.favoriteChanged(this));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!EqualsUtil.equals((Object)this.description, (Object)description)) {
            this.description = description;
            EventNotificationService.notify(InstallationVariableDescriptionChangedListener.class, listener -> listener.descriptionChanged(this));
        }
    }
}

