/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.domain;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.IgnorePersistence;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.view.variables.core.InstallationVariable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;

public class InstallationVariables
extends InstallationNode
implements InstallationComponent,
IgnorePersistence {
    private final Map<String, InstallationVariable> nameToInstallationVariable = new LinkedHashMap<String, InstallationVariable>();
    private int unchangedHash = this.nameToInstallationVariable.hashCode();
    private final ValidationStrategy expressionResolution = ValidationFactory.getExpressionValueValidator();
    private TextResource textResource;

    @Inject
    public InstallationVariables(TextResource textResource) {
        this.textResource = textResource;
        EventNotificationService.register((Object)((Object)this), PropertyChangeListener.class, (Object)new InstallationNameChange());
    }

    public Class<?> getType() {
        return InstallationVariables.class;
    }

    public void dispose() {
        EventNotificationService.unregister((Object)((Object)this), PropertyChangeListener.class);
    }

    public boolean isModified() {
        return this.unchangedHash != this.nameToInstallationVariable.hashCode();
    }

    public void clearModifiedState() {
        this.unchangedHash = this.nameToInstallationVariable.hashCode();
    }

    public void clearInstallationVariables() {
        this.nameToInstallationVariable.clear();
        this.fireInstallationVariableChangedEvent(null, InstallationVariablesListener.Action.CLEARED);
    }

    public Collection<InstallationVariable> getInstallationVariables() {
        return new ArrayList<InstallationVariable>(this.nameToInstallationVariable.values());
    }

    public void registerEntities(NameRegistry registerNamedEntities) {
        this.getInstallationVariables().forEach(registerNamedEntities::register);
    }

    public InstallationVariable getInstallationVariableByName(String name) {
        return this.nameToInstallationVariable.get(name);
    }

    public InstallationVariable addInstallationVariable(String name, String value) {
        InstallationVariable result = new InstallationVariable(name, value);
        this.nameToInstallationVariable.put(result.getName(), result);
        this.fireInstallationVariableChangedEvent(result, InstallationVariablesListener.Action.ADDED);
        this.fireInstallationChangeEvent();
        return result;
    }

    public InstallationVariable addInstallationVariable(String name, String value, String description, boolean isFavorite) {
        InstallationVariable installationVariable = new InstallationVariable(name, value, description, isFavorite);
        this.nameToInstallationVariable.put(installationVariable.getName(), installationVariable);
        this.fireInstallationVariableChangedEvent(installationVariable, InstallationVariablesListener.Action.ADDED);
        this.fireInstallationChangeEvent();
        return installationVariable;
    }

    private void fireInstallationChangeEvent() {
        EventNotificationService.notify(InstallationStateListener.class, InstallationStateListener::installationModified);
    }

    public InstallationVariable removeInstallationVariable(String name) {
        InstallationVariable found = this.nameToInstallationVariable.remove(name);
        if (found != null) {
            this.fireInstallationVariableChangedEvent(found, InstallationVariablesListener.Action.REMOVED);
            this.fireInstallationChangeEvent();
        }
        return found;
    }

    private void fireInstallationVariableChangedEvent(InstallationVariable source, InstallationVariablesListener.Action event) {
        EventNotificationService.notify(InstallationVariablesListener.class, listener -> listener.variableChange(source, event));
    }

    public void loadInstallationVariablesFrom(Properties props) {
        this.clearInstallationVariables();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            if (!this.expressionResolution.isValid(value)) {
                value = "\"\"";
            }
            this.addInstallationVariable(name, value);
        }
        this.unchangedHash = this.nameToInstallationVariable.hashCode();
    }

    public String getTypeName() {
        return this.textResource.installationTabVariables();
    }

    public ScriptWriter generatePreambleScript(ScriptWriter writer) {
        for (InstallationVariable each : this.getInstallationVariables()) {
            String name = each.getName();
            String scriptName = ScriptConverter.toScriptCode((String)name, (boolean)false);
            writer.globalVariable(scriptName, each.getValue());
        }
        return writer;
    }

    public String toString() {
        return this.nameToInstallationVariable.values().toString();
    }

    private class InstallationNameChange
    implements PropertyChangeListener {
        private InstallationNameChange() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof InstallationVariable && "name".equalsIgnoreCase(evt.getPropertyName())) {
                InstallationVariables.this.nameToInstallationVariable.remove(evt.getOldValue());
                InstallationVariables.this.nameToInstallationVariable.put((String)evt.getNewValue(), (InstallationVariable)evt.getSource());
            }
        }
    }

    public static interface InstallationVariablesListener {
        public void variableChange(InstallationVariable var1, Action var2);

        public static enum Action {
            ADDED,
            REMOVED,
            CLEARED;

        }
    }

    public static interface NameRegistry {
        public void register(InstallationVariable var1);
    }
}

