/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.externalapi;

import com.ur.injection.HasKey;
import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.geom.GeomFeatureNamingStrategy;
import gui.program.ProgramVariableObserver;
import gui.program.TimerScriptGeneration;
import gui.program.services.GeomFeatureVariable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@HasKey(value="VariableType")
public class VariableNamingStrategy
extends NamingStrategy {
    private final VariableLookupService variableLookupService;
    private final NamingService namingService;
    private final GeomFeatureNamingStrategy featureNamingStrategy;

    @Inject
    public VariableNamingStrategy(VariableLookupService variableLookupService, NamingService namingService, GeomFeatureNamingStrategy featureNamingStrategy) {
        super(Variable.class);
        this.variableLookupService = variableLookupService;
        this.namingService = namingService;
        this.featureNamingStrategy = featureNamingStrategy;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        if (StringUtils.isNullOrOnlyWhitespace((String)(nameCandidate = this.convertToValidName(nameCandidate)))) {
            return;
        }
        if (EqualsUtil.equals((Object)entity.getName(), (Object)nameCandidate) && !this.namingService.isReservedName(nameCandidate)) {
            return;
        }
        if (entity instanceof InstallationVariable) {
            return;
        }
        final Variable variable = (Variable)entity;
        boolean isGeomFeatureReference = variable instanceof GeomFeatureVariable;
        if (isGeomFeatureReference && variable.isUndefined()) {
            return;
        }
        final String newName = this.namingService.isNameUsed(entity.getClass(), nameCandidate) ? this.namingService.makeUniqueName(Variable.class, nameCandidate) : nameCandidate;
        final String oldName = variable.getName();
        if (isGeomFeatureReference) {
            for (NamedEntity each : this.variableLookupService.getAllGeomFeaturesByName(oldName)) {
                if (!(each instanceof GeomFeature)) continue;
                this.featureNamingStrategy.setName(each, newName);
            }
        }
        variable.setName(newName);
        if (variable instanceof ProgramVariable) {
            EventNotificationService.notify(ProgramVariableObserver.class, (NotificationStrategy)new NotificationStrategy<ProgramVariableObserver>(){

                public void notify(ProgramVariableObserver listener) {
                    listener.nameChanged((ProgramVariable)variable, oldName, newName);
                }
            });
        }
    }

    public List<String> getAdditionalReservedNames(String nameCandidate) {
        ArrayList<String> additionalReservedNames = new ArrayList<String>();
        additionalReservedNames.add(TimerScriptGeneration.getTimerIsCountingVariableName(nameCandidate));
        return additionalReservedNames;
    }
}

