/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.flightrecorder;

import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class GlobalVariablesAttachment
implements FlightRecorderAttachment {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private final Map<String, String> lastVariables;

    public GlobalVariablesAttachment(Map<String, String> lastVariables) {
        this.lastVariables = lastVariables;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.lastVariables == null) {
            return;
        }
        for (Map.Entry<String, String> variable : this.lastVariables.entrySet()) {
            outputStream.write(String.format("%s\t%s%n", variable.getKey(), variable.getValue()).getBytes(CHARSET_UTF8));
        }
    }

    public String getName() {
        return "global_variables.csv";
    }

    public String getMimeType() {
        return MediaType.CSV_UTF_8.toString();
    }
}

