/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.filemanager.UsbStateListener;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.WarningMessage;
import com.ur.util.event.EventManager;
import com.ur.view.polyscope.persistence.installation.variables.InstallationVariableXMLPersistStrategy;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.infrastructure.Persistence;
import gui.tools.URFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Provider;

public class FilePersistence
implements Persistence {
    private static final Logger LOGGER = LogFactory.createLogger(FilePersistence.class);
    private final URFileUtils.Facade fileUtils;
    private final Provider<ViewContext> viewContextProvider;
    private final InstallationVariableXMLPersistStrategy installationVariableXMLPersistStrategy;
    private final NamingService namingService;
    private boolean hasNotifiedOfMissingDirectory;

    @Inject
    FilePersistence(EventManager eventManager, URFileUtils.Facade fileUtils, NamingService namingService, Provider<ViewContext> viewContextProvider, InstallationVariableXMLPersistStrategy installationVariableXMLPersistStrategy) {
        this.viewContextProvider = viewContextProvider;
        this.fileUtils = fileUtils;
        this.namingService = namingService;
        this.installationVariableXMLPersistStrategy = installationVariableXMLPersistStrategy;
        eventManager.addStrongListener(UsbStateListener.class, (Object)new UsbStateListener.Template(){

            public void usbInserted() {
                FilePersistence.this.hasNotifiedOfMissingDirectory = false;
            }
        });
    }

    @Override
    public void load(File installationFile, Installation installation) {
        Path location = FilePersistence.getInstallationVariablesPath(installation);
        if (!this.fileUtils.exists(location)) {
            return;
        }
        try {
            if (this.fileUtils.isPropertiesFile(location.toFile())) {
                Properties props = this.fileUtils.readPropertiesFromFile(location.toFile().getAbsolutePath());
                ((InstallationVariables)installation.getComponent(InstallationVariables.class)).loadInstallationVariablesFrom(props);
            } else {
                this.loadInstallationVariables(installation, location.toFile());
            }
            LOGGER.traceRoute((Object)("Loaded Installation Variables: " + location.getFileName()));
            ((InstallationVariables)installation.getComponent(InstallationVariables.class)).registerEntities(arg_0 -> ((NamingService)this.namingService).registerNamedEntity(arg_0));
        }
        catch (FileNotFoundException fe) {
            LOGGER.error("Could not find installation variables file, '" + location + "'", (Throwable)fe);
            ((InstallationVariables)installation.getComponent(InstallationVariables.class)).clearInstallationVariables();
        }
        catch (IOException ex) {
            LOGGER.error("Error while reading installation variables file, '" + location + "'", (Throwable)ex);
            ((InstallationVariables)installation.getComponent(InstallationVariables.class)).clearInstallationVariables();
        }
        catch (RuntimeException ex) {
            LOGGER.error("Error while parsing installation variables file, '" + location + "'", (Throwable)ex);
            ((InstallationVariables)installation.getComponent(InstallationVariables.class)).clearInstallationVariables();
            TextResource textResource = (TextResource)((ViewContext)this.viewContextProvider.get()).getTextResource(TextResource.class);
            WarningMessage warningMessage = new WarningMessage(textResource.installationVariablesCouldNotLoad(), textResource.installationVariablesBeingReset());
            ((ViewContext)this.viewContextProvider.get()).getDialogCreator().showWarningMessageDialog(warningMessage, new OkDialogListener());
        }
    }

    private void loadInstallationVariables(Installation installation, File variableFile) throws IOException {
        InstallationVariables installationVariables = this.fileUtils.readPossiblyCompressedFile(variableFile, this.installationVariableXMLPersistStrategy);
        installation.setComponent((InstallationComponent)installationVariables);
    }

    @Override
    public void save(Installation installation) {
        if (installation == null) {
            return;
        }
        Path installationVariablesPath = FilePersistence.getInstallationVariablesPath(installation);
        InstallationVariables installationVariables = (InstallationVariables)installation.getComponent(InstallationVariables.class);
        if (this.tryToPersistVariables(installationVariablesPath, installation)) {
            installationVariables.clearModifiedState();
        }
    }

    private static Path getInstallationVariablesPath(Installation installation) {
        PersistanceMetaData persistanceMetaData = (PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class);
        return Paths.get(persistanceMetaData.directory(), String.valueOf(persistanceMetaData.fileName()) + ".variables");
    }

    private boolean tryToPersistVariables(Path installationVariablesPath, Installation installation) {
        try {
            if (!this.hasNotifiedOfMissingDirectory || this.fileUtils.exists(installationVariablesPath.getParent())) {
                this.persistVariables(installationVariablesPath, installation);
                LOGGER.traceRoute((Object)("Saved installation variables file: \"" + installationVariablesPath.getFileName() + "\""));
            }
        }
        catch (IOException ex) {
            LOGGER.error("Could not save installation variables file: \"" + installationVariablesPath.getFileName() + "\"", (Throwable)ex);
        }
        return !this.hasNotifiedOfMissingDirectory;
    }

    private void persistVariables(Path filename, Installation installation) throws IOException {
        InstallationVariables installationVariables = (InstallationVariables)installation.getComponent(InstallationVariables.class);
        if (this.fileUtils.exists(filename.getParent())) {
            this.writeInstallationVariables(filename, installationVariables);
            this.hasNotifiedOfMissingDirectory = false;
        } else {
            this.informUserOfMissingDirectory(filename, new OkDialogListener());
            this.hasNotifiedOfMissingDirectory = true;
        }
    }

    private void writeInstallationVariables(Path file, InstallationVariables installationVariables) throws IOException {
        this.fileUtils.writePossiblyCompressedFile(file.toFile(), installationVariables, this.installationVariableXMLPersistStrategy);
    }

    protected void informUserOfMissingDirectory(Path filename, OkDialogListener okDialogListener) {
        ((ViewContext)this.viewContextProvider.get()).getDialogCreator().showErrorDialog(this.unableToSaveInstallationVariables(filename.toString()), okDialogListener);
    }

    private ErrorMessage unableToSaveInstallationVariables(String fileName) {
        TextResource textResource = (TextResource)((ViewContext)this.viewContextProvider.get()).getTextResource(TextResource.class);
        return new ErrorMessage(textResource.installationTabInstallationVariables(), textResource.couldNotSaveInstallationVariables(fileName), textResource.ensureSelectedSaveDirectoryExists());
    }
}

