/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationNodeInfo;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.util.event.EventNotificationService;
import com.ur.view.gui.tables.InstallationVariablesTableModel;
import com.ur.view.gui.tables.VariablesTable;
import com.ur.view.gui.tables.VariablesTablePanel;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.InstallationVariableDescriptionChangedListener;
import com.ur.view.variables.core.InstallationVariableFavoriteChangedListener;
import com.ur.view.variables.core.InstallationVariableValueChangedListener;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.infrastructure.InstallationVariablesDetailPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ImprovedInstallationVariablesTab
extends CardPanel
implements InstallationNodeInfo {
    public static final String SHOW_INSTALLATION_VARIABLES_ACTION = "showInstallationVariablesAction." + ImprovedInstallationVariablesTab.class.getSimpleName();
    public static final String TABLE_NAME = "ImprovedInstallationVariablesTab.variablesTable";
    public static final String CREATE_VARIABLE_PANEL = "ImprovedInstallationVariablesTab.createVariablePanel";
    private static final int FAVORITE_COLUMN = 0;
    private static final int VALUE_COLUMN_INDEX = 2;
    private static final int DESCRIPTION_COLUMN_INDEX = 3;
    private final InstallationComponentLookup installationLookupService;
    private final String[] columnNames;
    private final TextResource textResource;
    private final InstallationVariablesDetailPanel installationVariablesDetailPanel;
    private InstallationVariableValueChangedListener installationVariableValueChangedListener;
    private InstallationVariableDescriptionChangedListener installationVariableDescriptionChangedListener;
    private VariablesTable table;
    private InstallationVariableFavoriteChangedListener installationVariableFavoriteChangedListener;

    @Inject
    ImprovedInstallationVariablesTab(InstallationComponentLookup installationLookupService, ViewContext viewContext, final InstallationVariablesDetailPanel installationVariablesDetailPanel) {
        this.installationLookupService = installationLookupService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.installationVariablesDetailPanel = installationVariablesDetailPanel;
        this.columnNames = new String[]{this.textResource.favoriteColumn(), this.textResource.Name(), this.textResource.Value(), this.textResource.Description()};
        this.initComponents();
        this.assignHelp(viewContext);
        this.assignListenerFunctions();
        this.reloadInstallationVariables();
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                SwingUtilities.invokeLater(() -> {
                    ImprovedInstallationVariablesTab.this.table.clearSelection();
                    ImprovedInstallationVariablesTab.this.reloadInstallationVariables();
                    installationVariablesDetailPanel.setStateEnterPanel();
                    ImprovedInstallationVariablesTab.this.table.repaint();
                    ImprovedInstallationVariablesTab.this.table.revalidate();
                });
            }
        });
    }

    private void assignListenerFunctions() {
        this.installationVariableValueChangedListener = variable -> SwingUtilities.invokeLater(() -> this.updateViewOnVariableChanged(variable, 2));
        this.installationVariableDescriptionChangedListener = variable -> SwingUtilities.invokeLater(() -> this.updateViewOnVariableChanged(variable, 3));
        this.installationVariableFavoriteChangedListener = variable -> SwingUtilities.invokeLater(() -> this.updateViewOnVariableChanged(variable, 0));
    }

    private void updateViewOnVariableChanged(InstallationVariable variable, int columnIndex) {
        int changedRowIndex = this.table.getRow(variable);
        if (changedRowIndex >= 0) {
            ((InstallationVariablesTableModel)this.table.getModel()).fireTableCellUpdated(changedRowIndex, columnIndex);
            this.table.repaint();
            this.table.revalidate();
            if (this.table.getSelectedRow() == changedRowIndex) {
                this.installationVariablesDetailPanel.setStateSelectVariable();
            }
        }
    }

    public void enter(Object o) {
        super.enter(o);
        this.registerListeners();
        this.reloadTable();
    }

    private void reloadTable() {
        InstallationVariable installationVariable = this.installationVariablesDetailPanel.getSelectedVariable();
        SwingUtilities.invokeLater(() -> {
            this.reloadInstallationVariables();
            this.table.repaint();
            this.table.revalidate();
            this.table.restoreSortOrder();
            if (installationVariable != null) {
                this.selectVariableInTable(installationVariable);
            }
            this.installationVariablesDetailPanel.setStateEnterPanel();
        });
    }

    private void selectVariableInTable(InstallationVariable installationVariable) {
        int rowNumber = 0;
        while (rowNumber < this.table.getRowCount()) {
            InstallationVariable variable = this.table.getInstallationVariableAtRow(rowNumber);
            if (installationVariable.getName().equals(variable.getName())) {
                this.table.setRowSelectionInterval(rowNumber, rowNumber);
                return;
            }
            ++rowNumber;
        }
    }

    private void reloadInstallationVariables() {
        Collection<InstallationVariable> ivars = this.getInstallationVariables().getInstallationVariables();
        ((InstallationVariablesTableModel)this.table.getModel()).setVariables(ivars);
    }

    private void registerListeners() {
        EventNotificationService.register((Object)((Object)this), InstallationVariableValueChangedListener.class, (Object)this.installationVariableValueChangedListener);
        EventNotificationService.register((Object)((Object)this), InstallationVariableDescriptionChangedListener.class, (Object)this.installationVariableDescriptionChangedListener);
        EventNotificationService.register((Object)((Object)this), InstallationVariableFavoriteChangedListener.class, (Object)this.installationVariableFavoriteChangedListener);
    }

    public Object exit() {
        this.unregisterListeners();
        this.installationVariablesDetailPanel.setStateExitPanel();
        this.table.saveSortOrder();
        return super.exit();
    }

    private void unregisterListeners() {
        EventNotificationService.unregister((Object)((Object)this), InstallationVariableValueChangedListener.class);
        EventNotificationService.unregister((Object)((Object)this), InstallationVariableDescriptionChangedListener.class);
        EventNotificationService.unregister((Object)((Object)this), InstallationVariableFavoriteChangedListener.class);
    }

    private void assignHelp(ViewContext viewContext) {
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:installation_installationvariables");
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:installation_variables");
    }

    private InstallationVariables getInstallationVariables() {
        return (InstallationVariables)this.installationLookupService.getComponent(InstallationVariables.class);
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.initTitlePanel();
        this.initTablePanel();
        this.installationVariablesDetailPanel.setVariablesTable(this.table);
        this.installationVariablesDetailPanel.setName(CREATE_VARIABLE_PANEL);
        this.add(this.installationVariablesDetailPanel, "South");
    }

    private void initTitlePanel() {
        JPanel titlePanel = new JPanel(new BorderLayout());
        JLabel titleLabel = new JLabel(this.textResource.installationVariables());
        titlePanel.add((Component)titleLabel, "West");
        this.add(titlePanel, "First");
    }

    private void initTablePanel() {
        this.table = new VariablesTable();
        this.table.setModel(new InstallationVariablesTableModel(new ArrayList<InstallationVariable>(), this.columnNames, this.textResource));
        this.table.setName(TABLE_NAME);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (ImprovedInstallationVariablesTab.this.table.getSelectedRow() >= 0) {
                    ImprovedInstallationVariablesTab.this.installationVariablesDetailPanel.setStateSelectVariable();
                } else {
                    ImprovedInstallationVariablesTab.this.installationVariablesDetailPanel.setStateDeselectVariable();
                }
            }
        });
        this.table.setColumnWidthsByPixels(33, 255, 310, 432);
        VariablesTablePanel variablesTablePanel = VariablesTablePanel.createTableWithFourColumns(this.table);
        variablesTablePanel.addMouseListenerToScrollPane(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ImprovedInstallationVariablesTab.this.installationVariablesDetailPanel.setStateDeselectVariable();
            }
        });
        variablesTablePanel.addColumnCollapseButton();
        variablesTablePanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.add(variablesTablePanel, "Center");
    }

    public InstallationNode getInstallationNode() {
        return (InstallationNode)this.installationLookupService.getComponent(InstallationVariables.class);
    }

    protected VariablesTable getTable() {
        return this.table;
    }
}

