/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.google.inject.Inject;
import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.view.gui.tables.InstallationVariablesTableModel;
import com.ur.view.gui.tables.VariablesTable;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.validation.ExpressionValueValidator;
import gui.program.services.ProgramStateService;
import gui.tools.URDialogCreator;
import gui.tools.dialogs.input.DescriptionValidationFactory;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class InstallationVariablesDetailPanel
extends JPanel {
    public static final String CREATE_VARIABLE = "ImprovedInstallationVariablesTab.createNew";
    public static final String FAVORITE_CHECK_BOX = "ImprovedInstallationVariablesTab.favoriteCheckbox";
    public static final String DELETE_SELECTION_ID = "ImprovedInstallationVariablesTab.deleteSelectedVariable";
    public static final String CREATE_NAME_FIELD_ID = "ImprovedInstallationVariablesTab.createNameField";
    public static final String CREATE_VALUE_FIELD_ID = "ImprovedInstallationVariablesTab.createValueField";
    public static final String CREATE_DESCRIPTION_FIELD_ID = "InstallationVariablesTab.createDescriptionField";
    public static final String CREATE_OK_BUTTON_ID = "ImprovedInstallationVariablesTab.createOKButton";
    public static final String CANCEL_BUTTON_ID = "ImprovedInstallationVariablesTab.cancelButton";
    private final Font fontForHeaders = new Font("DejaVu", 1, 16);
    private final Dimension dimension = new Dimension(375, 28);
    private final TextResource textResource;
    private final NamingService namingService;
    private final URDialogCreator urDialogCreator;
    private final ProgramStateService programStateService;
    private final InstallationComponentLookup installationComponentLookup;
    private final CommandNamesResource commandNamesResource;
    private final ValidationStrategy expressionValueValidator;
    private VariablesTable variablesTable;
    protected JTextField nameField;
    protected JTextField valueField;
    protected JTextField descriptionField;
    protected JCheckBox favoriteCheckBox;
    protected JButton createNewButton;
    protected JButton deleteButton;
    protected JButton okButton;
    protected JButton cancelButton;
    private panelState currentState = panelState.DESELECT_VARIABLE;

    @Inject
    public InstallationVariablesDetailPanel(ViewContext viewContext, NamingService namingService, URDialogCreator urDialogCreator, ProgramStateService programStateService, InstallationComponentLookup installationComponentLookup, @ExpressionValueValidator ValidationStrategy expressionValueValidator) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.commandNamesResource = (CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class);
        this.namingService = namingService;
        this.urDialogCreator = urDialogCreator;
        this.programStateService = programStateService;
        this.installationComponentLookup = installationComponentLookup;
        this.expressionValueValidator = expressionValueValidator;
        this.initComponents();
    }

    public void setVariablesTable(VariablesTable variablesTable) {
        this.variablesTable = variablesTable;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.initCreateDeletePanel(), "North");
        this.add((Component)this.initFieldsPanel(), "Center");
        this.add((Component)this.initFavoriteOkCancelPanel(), "South");
    }

    private JPanel initCreateDeletePanel() {
        JPanel createDeletePanel = new JPanel(new BorderLayout());
        this.initCreateNewButton();
        this.initDeleteButton();
        createDeletePanel.add((Component)this.createInternalButtonPanel(this.createNewButton, this.deleteButton), "East");
        return createDeletePanel;
    }

    private void initCreateNewButton() {
        this.createNewButton = new JButton();
        this.createNewButton.setText(this.textResource.createNew());
        this.createNewButton.setName(CREATE_VARIABLE);
        this.createNewButton.addActionListener(actionEvent -> {
            String newName = this.namingService.makeUniqueName(InstallationVariable.class, "i_" + this.commandNamesResource.var() + "_1");
            this.clearTextFields();
            this.favoriteCheckBox.setSelected(false);
            this.nameField.setText(newName);
            this.changePanelState(panelState.CREATE_NEW_VARIABLE);
        });
    }

    private void initDeleteButton() {
        this.deleteButton = new JButton();
        this.deleteButton.setText(this.textResource.Delete());
        this.deleteButton.setName(DELETE_SELECTION_ID);
        this.deleteButton.addActionListener(actionEvent -> {
            InstallationVariable selectedVariable = this.getSelectedVariable();
            if (selectedVariable != null) {
                this.confirmDeletion(selectedVariable);
            } else {
                this.changePanelState(panelState.DESELECT_VARIABLE);
            }
        });
    }

    private void confirmDeletion(final InstallationVariable selectedVariable) {
        ConfirmationDialogListener confirmationDialogListener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                InstallationVariablesDetailPanel.this.programStateService.stop();
                InstallationVariablesDetailPanel.this.changePanelState(panelState.DESELECT_VARIABLE);
                InstallationVariablesDetailPanel.this.namingService.deregisterNamedEntity((NamedEntity)selectedVariable);
                InstallationVariablesDetailPanel.this.getInstallationVariablesComponent().removeInstallationVariable(selectedVariable.getName());
                ((InstallationVariablesTableModel)InstallationVariablesDetailPanel.this.variablesTable.getModel()).setVariables(InstallationVariablesDetailPanel.this.getInstallationVariablesComponent().getInstallationVariables());
            }

            public void onCancelClicked() {
                InstallationVariablesDetailPanel.this.changePanelState(panelState.SELECT_VARIABLE);
            }
        };
        this.urDialogCreator.showConfirmationDialog(this.confirmDeleteVariable(selectedVariable.getName()), confirmationDialogListener);
    }

    private InstallationVariables getInstallationVariablesComponent() {
        return (InstallationVariables)this.installationComponentLookup.getComponent(InstallationVariables.class);
    }

    private ConfirmationMessage confirmDeleteVariable(String selectedVariable) {
        return new ConfirmationMessage(this.textResource.confirmDeleteVariableTitle(), this.textResource.confirmDeleteVariableExplanation(selectedVariable), this.textResource.confirmDeleteVariableAction(), this.textResource.Cancel());
    }

    private JPanel initFieldsPanel() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(15);
        JPanel fieldsPanel = new JPanel(borderLayout);
        fieldsPanel.add((Component)this.initNameFieldPanel(), "West");
        fieldsPanel.add((Component)this.initValueFieldPanel(), "Center");
        fieldsPanel.add((Component)this.initDescriptionFieldPanel(), "East");
        fieldsPanel.setBorder(new EmptyBorder(20, 0, 10, 0));
        this.bindTextPickers();
        return fieldsPanel;
    }

    private void bindTextPickers() {
        TextFieldUtils.bindTextPicker((JComponent)this.nameField, (TextHolder)this.getNameFieldTextHolder(), (ValidationStrategy)NameValidationFactory.getVariableNameValidator(this.namingService, InstallationVariable.class, this.textResource));
        TextFieldUtils.bindTextPicker((JComponent)this.valueField, (TextHolder)this.getValueFieldTextHolder(), (ValidationStrategy)this.expressionValueValidator);
        TextFieldUtils.bindTextPicker((JComponent)this.descriptionField, (TextHolder)this.getDescriptionFieldTextHolder(), (ValidationStrategy)DescriptionValidationFactory.getDescriptionValidator(this.textResource));
    }

    private JPanel initNameFieldPanel() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(10);
        borderLayout.setVgap(5);
        JPanel nameFieldPanel = new JPanel(borderLayout);
        this.initNameField();
        JLabel nameLabel = new JLabel();
        nameLabel.setText(this.textResource.Name());
        nameLabel.setFont(this.fontForHeaders);
        nameLabel.setPreferredSize(new Dimension(245, 17));
        JLabel newEqualSignLabel = new JLabel();
        newEqualSignLabel.setFont(this.fontForHeaders);
        newEqualSignLabel.setText("\u2254");
        newEqualSignLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        nameFieldPanel.add((Component)nameLabel, "North");
        nameFieldPanel.add((Component)this.nameField, "Center");
        nameFieldPanel.add((Component)newEqualSignLabel, "East");
        return nameFieldPanel;
    }

    private void initNameField() {
        this.nameField = new JTextField();
        this.nameField.setFocusable(false);
        this.nameField.setMinimumSize(new Dimension(245, 28));
        this.nameField.setName(CREATE_NAME_FIELD_ID);
    }

    private JPanel initValueFieldPanel() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        JPanel valuePanel = new JPanel(borderLayout);
        this.initValueField();
        JLabel valueLabel = new JLabel();
        valueLabel.setText(this.textResource.Value());
        valueLabel.setFont(this.fontForHeaders);
        valueLabel.setPreferredSize(new Dimension(375, 17));
        valuePanel.add((Component)valueLabel, "North");
        valuePanel.add((Component)this.valueField, "West");
        return valuePanel;
    }

    private void initValueField() {
        this.valueField = new JTextField();
        this.valueField.setEditable(false);
        this.valueField.setMaximumSize(this.dimension);
        this.valueField.setPreferredSize(new Dimension(this.dimension));
        this.valueField.setName(CREATE_VALUE_FIELD_ID);
    }

    private JPanel initDescriptionFieldPanel() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        JPanel descriptionPanel = new JPanel(borderLayout);
        this.initDescriptionField();
        JLabel descriptionLabel = new JLabel();
        descriptionLabel.setText(this.textResource.Description());
        descriptionLabel.setFont(this.fontForHeaders);
        descriptionLabel.setPreferredSize(new Dimension(375, 17));
        descriptionPanel.add((Component)descriptionLabel, "North");
        descriptionPanel.add((Component)this.descriptionField, "Center");
        return descriptionPanel;
    }

    private void initDescriptionField() {
        this.descriptionField = new JTextField();
        this.descriptionField.setEditable(false);
        this.descriptionField.setMinimumSize(this.dimension);
        this.descriptionField.setPreferredSize(this.dimension);
        this.descriptionField.setName(CREATE_DESCRIPTION_FIELD_ID);
    }

    private JPanel initFavoriteOkCancelPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.initFavoriteCheckBox();
        this.initOKButton();
        this.initCancelButton();
        buttonPanel.add((Component)this.favoriteCheckBox, "West");
        buttonPanel.add((Component)this.createInternalButtonPanel(this.okButton, this.cancelButton), "East");
        buttonPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        return buttonPanel;
    }

    private void initFavoriteCheckBox() {
        this.favoriteCheckBox = new JCheckBox(this.textResource.favoriteVariable());
        this.favoriteCheckBox.setName(FAVORITE_CHECK_BOX);
        this.favoriteCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.favoriteCheckBox.addActionListener(evt -> {
            InstallationVariable selectedVariable = this.getSelectedVariable();
            if (this.isPanelStateEdit() && selectedVariable != null) {
                selectedVariable.setIsFavourite(this.favoriteCheckBox.isSelected());
                this.sendInstallationModifiedEvent();
            }
        });
    }

    private void sendInstallationModifiedEvent() {
        EventNotificationService.notify(InstallationStateListener.class, InstallationStateListener::installationModified);
    }

    private boolean isPanelStateEdit() {
        return panelState.SELECT_VARIABLE.equals((Object)this.currentState);
    }

    private void initOKButton() {
        this.okButton = new JButton();
        this.okButton.setPreferredSize(new Dimension(96, 33));
        this.okButton.setText(this.textResource.OK());
        this.okButton.setName(CREATE_OK_BUTTON_ID);
        this.okButton.addActionListener(actionEvent -> {
            InstallationVariable newVariable = this.getInstallationVariablesComponent().addInstallationVariable(this.nameField.getText(), this.valueField.getText(), this.descriptionField.getText(), this.favoriteCheckBox.isSelected());
            this.namingService.registerNamedEntity((NamedEntity)newVariable);
            ((InstallationVariablesTableModel)this.variablesTable.getModel()).setVariables(this.getInstallationVariablesComponent().getInstallationVariables());
            this.changePanelState(panelState.FINISHED_NEW_VARIABLE);
        });
    }

    private void initCancelButton() {
        this.cancelButton = new JButton();
        this.cancelButton.setText(this.textResource.Cancel());
        this.cancelButton.setName(CANCEL_BUTTON_ID);
        this.cancelButton.addActionListener(actionEvent -> this.changePanelState(panelState.CANCELLED_NEW_VARIABLE));
    }

    private JPanel createInternalButtonPanel(JButton okButton, JButton cancelButton) {
        BorderLayout borderLayout = new BorderLayout();
        JPanel internalPanel = new JPanel(borderLayout);
        internalPanel.add((Component)okButton, "West");
        borderLayout.setHgap(10);
        internalPanel.add((Component)cancelButton, "East");
        return internalPanel;
    }

    private void changePanelState(panelState newState) {
        switch (newState) {
            case DESELECT_VARIABLE: {
                this.deselectVariableState(newState);
                break;
            }
            case SELECT_VARIABLE: {
                this.selectVariableState(newState);
                break;
            }
            case ENTER_PANEL: {
                this.enterPanelState(newState);
                break;
            }
            case EXIT_PANEL: {
                this.exitPanelState(newState);
                break;
            }
            case CREATE_NEW_VARIABLE: {
                this.currentState = newState;
                this.createNewVariableState();
                this.changePanelState(panelState.VALUE_MISSING);
                break;
            }
            case VALUE_MISSING: {
                this.disableOK();
                this.colourValueFieldYellow();
                this.currentState = newState;
                break;
            }
            case VALUE_FILLED: {
                this.enableOk();
                this.resetValueFieldColour();
                this.colourOkBlue();
                this.currentState = newState;
                break;
            }
            case FINISHED_NEW_VARIABLE: {
                this.resetOkColour();
                this.currentState = newState;
                this.enableCreateNew();
                this.changePanelState(panelState.DESELECT_VARIABLE);
                break;
            }
            case CANCELLED_NEW_VARIABLE: {
                this.updateControls();
                this.currentState = newState;
                this.changePanelState(panelState.DESELECT_VARIABLE);
            }
        }
    }

    private void updateControls() {
        this.enableCreateNew();
        this.resetOkColour();
        this.resetValueFieldColour();
    }

    private void createNewVariableState() {
        this.disableDelete();
        this.disableCreateNew();
        this.enableTextFields();
        this.variablesTable.getSelectionModel().clearSelection();
        this.enableFavoriteCheckBox();
        this.enableCancel();
    }

    private void exitPanelState(panelState newState) {
        if (panelState.VALUE_MISSING.equals((Object)this.currentState) || panelState.VALUE_FILLED.equals((Object)this.currentState)) {
            this.currentState = newState;
            this.changePanelState(panelState.CANCELLED_NEW_VARIABLE);
        } else {
            this.currentState = newState;
        }
    }

    private void enterPanelState(panelState newState) {
        this.currentState = newState;
        if (this.variablesTable.getSelectedRow() >= 0) {
            this.changePanelState(panelState.SELECT_VARIABLE);
        } else {
            this.changePanelState(panelState.DESELECT_VARIABLE);
        }
    }

    private void selectVariableState(panelState newState) {
        this.currentState = newState;
        this.resetValueFieldColour();
        this.resetOkColour();
        this.enableCreateNew();
        this.enableDelete();
        this.enableEditFieldsWithSelectedVariable();
        this.disableOK();
        this.disableCancel();
    }

    private void deselectVariableState(panelState newState) {
        this.currentState = newState;
        this.variablesTable.getSelectionModel().clearSelection();
        this.resetValueFieldColour();
        this.resetOkColour();
        this.enableCreateNew();
        this.disableDelete();
        this.clearTextFields();
        this.disableTextFields();
        this.disableFavoriteCheckbox();
        this.disableOK();
        this.disableCancel();
    }

    private void resetOkColour() {
        this.okButton.setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
    }

    private void resetValueFieldColour() {
        this.valueField.setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
    }

    private void enableFavoriteCheckBox() {
        this.favoriteCheckBox.setEnabled(true);
    }

    private void colourOkBlue() {
        this.okButton.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
    }

    private void enableOk() {
        this.okButton.setEnabled(true);
    }

    private void colourValueFieldYellow() {
        this.valueField.setBackground(G5LookAndFeel.INCOMPLETE_BACKGROUND_COLOR);
    }

    private void disableCreateNew() {
        this.createNewButton.setEnabled(false);
    }

    private void enableEditFieldsWithSelectedVariable() {
        InstallationVariable selectedVariable = this.getSelectedVariable();
        if (selectedVariable != null) {
            this.nameField.setText(selectedVariable.getName());
            this.nameField.setEnabled(false);
            this.valueField.setText(selectedVariable.getValue());
            this.valueField.setEnabled(true);
            this.descriptionField.setText(selectedVariable.getDescription());
            this.descriptionField.setEnabled(true);
            this.favoriteCheckBox.setSelected(selectedVariable.isFavourite());
            this.favoriteCheckBox.setEnabled(true);
        }
    }

    private void enableDelete() {
        this.deleteButton.setEnabled(true);
    }

    private void enableCancel() {
        this.cancelButton.setEnabled(true);
    }

    public InstallationVariable getSelectedVariable() {
        int selectedRow = this.variablesTable.getSelectedRow();
        if (selectedRow >= 0) {
            return this.variablesTable.getInstallationVariableAtRow(selectedRow);
        }
        return null;
    }

    private void clearTextFields() {
        this.nameField.setText("");
        this.valueField.setText("");
        this.descriptionField.setText("");
    }

    private void disableTextFields() {
        this.nameField.setEnabled(false);
        this.valueField.setEnabled(false);
        this.descriptionField.setEnabled(false);
    }

    private void enableTextFields() {
        this.nameField.setEnabled(true);
        this.valueField.setEnabled(true);
        this.descriptionField.setEnabled(true);
    }

    private void disableFavoriteCheckbox() {
        this.favoriteCheckBox.setEnabled(false);
        this.favoriteCheckBox.setSelected(false);
    }

    private void disableOK() {
        this.okButton.setEnabled(false);
    }

    private void disableCancel() {
        this.cancelButton.setEnabled(false);
    }

    private void disableDelete() {
        this.deleteButton.setEnabled(false);
    }

    private void enableCreateNew() {
        this.createNewButton.setEnabled(true);
    }

    public void setStateEnterPanel() {
        this.changePanelState(panelState.ENTER_PANEL);
    }

    public void setStateSelectVariable() {
        this.changePanelState(panelState.SELECT_VARIABLE);
    }

    public void setStateDeselectVariable() {
        this.changePanelState(panelState.DESELECT_VARIABLE);
    }

    public void setStateExitPanel() {
        this.changePanelState(panelState.EXIT_PANEL);
    }

    protected void setStateValueMissing() {
        this.changePanelState(panelState.VALUE_MISSING);
    }

    protected panelState getCurrentState() {
        return panelState.valueOf(this.currentState.toString());
    }

    private TextHolder getNameFieldTextHolder() {
        return new TextHolder(){

            public String getText() {
                return InstallationVariablesDetailPanel.this.nameField.getText();
            }

            public void setText(String text) {
                InstallationVariablesDetailPanel.this.nameField.setText(text);
            }
        };
    }

    private TextHolder getValueFieldTextHolder() {
        return new TextHolder(){

            public String getText() {
                return InstallationVariablesDetailPanel.this.valueField.getText();
            }

            public void setText(String text) {
                InstallationVariablesDetailPanel.this.valueField.setText(text);
                if (InstallationVariablesDetailPanel.this.isPanelStateEdit()) {
                    InstallationVariablesDetailPanel.this.programStateService.stop();
                    InstallationVariable selectedVariable = InstallationVariablesDetailPanel.this.getSelectedVariable();
                    if (selectedVariable != null) {
                        selectedVariable.setValue(InstallationVariablesDetailPanel.this.valueField.getText());
                        InstallationVariablesDetailPanel.this.sendInstallationModifiedEvent();
                    }
                } else if (panelState.VALUE_MISSING.equals((Object)InstallationVariablesDetailPanel.this.currentState)) {
                    InstallationVariablesDetailPanel.this.changePanelState(panelState.VALUE_FILLED);
                }
            }
        };
    }

    private TextHolder getDescriptionFieldTextHolder() {
        return new TextHolder(){

            public String getText() {
                return InstallationVariablesDetailPanel.this.descriptionField.getText();
            }

            public void setText(String text) {
                InstallationVariablesDetailPanel.this.descriptionField.setText(text);
                InstallationVariable selectedVariable = InstallationVariablesDetailPanel.this.getSelectedVariable();
                if (selectedVariable != null && InstallationVariablesDetailPanel.this.isPanelStateEdit()) {
                    InstallationVariablesDetailPanel.this.programStateService.stop();
                    selectedVariable.setDescription(InstallationVariablesDetailPanel.this.descriptionField.getText());
                    InstallationVariablesDetailPanel.this.sendInstallationModifiedEvent();
                }
            }
        };
    }

    protected static enum panelState {
        ENTER_PANEL,
        EXIT_PANEL,
        CREATE_NEW_VARIABLE,
        SELECT_VARIABLE,
        DESELECT_VARIABLE,
        VALUE_MISSING,
        VALUE_FILLED,
        FINISHED_NEW_VARIABLE,
        CANCELLED_NEW_VARIABLE;

    }
}

