/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationNodeInfo;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.swing.CardPanel;
import com.ur.swing.GuiUtilities;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.event.EventNotificationService;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.InstallationVariableValueChangedListener;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.validation.ExpressionValueValidator;
import gui.program.services.ProgramStateService;
import gui.tools.InstallationVariablesTable;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class InstallationVariablesTab
extends CardPanel
implements InstallationNodeInfo {
    public static final String CREATE_VARIABLE_PANEL = "InstallationVariablesTab.createVariablePanel";
    public static final String CREATE_VARIABLE = "InstallationVariablesTab.createNew";
    public static final String EDIT_SELECTION_ID = "InstallationVariablesTab.editSelectedVariable";
    public static final String DELETE_SELECTION_ID = "InstallationVariablesTab.deleteSelectedVariable";
    public static final String EDIT_NAME_FIELD_ID = "InstallationVariablesTab.editNameField";
    public static final String EDIT_VALUE_FIELD_ID = "InstallationVariablesTab.editValueField";
    public static final String EDIT_OK_BUTTON_ID = "InstallationVariablesTab.editOKButton";
    public static final String CREATE_NAME_FIELD_ID = "InstallationVariablesTab.createNameField";
    public static final String CREATE_VALUE_FIELD_ID = "InstallationVariablesTab.createValueField";
    public static final String CREATE_OK_BUTTON_ID = "InstallationVariablesTab.createOKButton";
    public static final String SHOW_INSTALLATION_VARIABLES_ACTION = "showInstallationVariablesAction." + InstallationVariablesTab.class.getSimpleName();
    private static boolean resetViewOnEnter = false;
    private final ProgramStateService programStateService;
    private final InstallationVariableValueChangedListener installationVariablesChanged;
    private final InstallationComponentLookup installationLookupService;
    private final URFontFactory fontFactory;
    private final NamingService namingService;
    private final ValidationStrategy variableNameValidator;
    private final ValidationStrategy expressionValueValidator;
    private final TextResource textResource;
    private final CommandNamesResource commandNamesResource;
    private String editingVariableName;
    private DefaultTableModel tableModel;
    private JButton createNewButton;
    private JButton deleteButton;
    private JButton editButton;
    private JTextField editNameField;
    private JButton editOKButton;
    private JTextField editValueField;
    private JLabel editValueLabel;
    private JButton newCancelButton;
    private JTextField newNameField;
    private JLabel newNameLabel;
    private JButton newOKButton;
    private JTextField newValueField;
    private JLabel newValueLabel;
    private JLabel newVariableErrorMessage;
    private JPanel newVariablePanel;
    private InstallationVariablesTable table;
    private JLabel titleLabel;

    @Inject
    InstallationVariablesTab(final ProgramStateService programStateService, InstallationComponentLookup installationLookupService, ViewContext viewContext, NamingService namingService, @ExpressionValueValidator ValidationStrategy expressionValueValidator) {
        this.installationLookupService = installationLookupService;
        this.fontFactory = viewContext.getFontFactory();
        this.namingService = namingService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.variableNameValidator = NameValidationFactory.getVariableNameValidator(namingService, InstallationVariable.class, this.textResource);
        this.expressionValueValidator = expressionValueValidator;
        this.commandNamesResource = (CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class);
        this.initComponents();
        this.assignHelp(viewContext);
        this.setState(State.EMPTY_SELECTION);
        this.newVariableErrorMessage.setText(" ");
        this.table.EnableURDragScroll(this.table, new InstallationVariablesTable.SelectionListener(){

            @Override
            public void selected(String name, String value) {
                InstallationVariablesTab.this.setState(State.ROW_SELECTED);
            }

            @Override
            public void requestEdit(String name, String value) {
            }
        });
        this.installationVariablesChanged = variable -> SwingUtilities.invokeLater(() -> this.table.updateRow(variable.getName(), variable.getValue()));
        this.translateGUILabels();
        this.createNewButton.setName(CREATE_VARIABLE);
        this.editButton.setName(EDIT_SELECTION_ID);
        this.deleteButton.setName(DELETE_SELECTION_ID);
        this.newVariablePanel.setName(CREATE_VARIABLE_PANEL);
        this.editNameField.setName(EDIT_NAME_FIELD_ID);
        this.editValueField.setName(EDIT_VALUE_FIELD_ID);
        this.editOKButton.setName(EDIT_OK_BUTTON_ID);
        this.newNameField.setName(CREATE_NAME_FIELD_ID);
        this.newValueField.setName(CREATE_VALUE_FIELD_ID);
        this.newOKButton.setName(CREATE_OK_BUTTON_ID);
        this.programStateService = programStateService;
        TextHolder provider = new TextHolder(){

            public String getText() {
                return InstallationVariablesTab.this.newNameField.getText();
            }

            public void setText(String text) {
                InstallationVariablesTab.this.newNameField.setText(text);
            }
        };
        TextFieldUtils.bindTextPicker((JComponent)this.newNameField, (TextHolder)provider, (ValidationStrategy)this.variableNameValidator);
        TextHolder valueProvider = new TextHolder(){

            public String getText() {
                return InstallationVariablesTab.this.newValueField.getText();
            }

            public void setText(String text) {
                InstallationVariablesTab.this.newValueField.setText(text);
            }
        };
        TextFieldUtils.bindTextPicker((JComponent)this.newValueField, (TextHolder)valueProvider, (ValidationStrategy)expressionValueValidator);
        TextHolder editProvider = new TextHolder(){

            public String getText() {
                InstallationVariablesTab.this.editingVariableName = InstallationVariablesTab.this.getSelectedVariable();
                programStateService.stop();
                InstallationVariablesTab.this.copySelectedRowToEditFields();
                GuiUtilities.setCursorBeforeLastQuoteInJTextField((JTextField)InstallationVariablesTab.this.editValueField);
                InstallationVariablesTab.this.setState(State.UPDATE_ROW_IMMEDIATELY);
                return InstallationVariablesTab.this.editValueField.getText();
            }

            public void setText(String text) {
                InstallationVariablesTab.this.editValueField.setText(text);
                InstallationVariablesTab.this.editOKButton.doClick();
            }
        };
        TextFieldUtils.PositionHolder positionHolder = () -> {
            Rectangle rectangle = this.table.getCellRect(this.table.getSelectedRow(), 0, false);
            Point p = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(p, this.table);
            return (int)p.getY();
        };
        TextFieldUtils.bindTextPickerAtPosition((JComponent)this.editButton, (TextFieldUtils.PositionHolder)positionHolder, (TextHolder)editProvider, (ValidationStrategy)expressionValueValidator);
    }

    public static void resetViewOnEnter() {
        resetViewOnEnter = true;
    }

    private void assignHelp(ViewContext viewContext) {
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:installation_installationvariables");
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:installation_variables");
    }

    public InstallationNode getInstallationNode() {
        return (InstallationNode)this.installationLookupService.getComponent(InstallationVariables.class);
    }

    private void clearNewVariableInputs() {
        this.newNameField.setText("");
        this.newValueField.setText("");
    }

    private void setState(State newState) {
        if (newState == State.NEW) {
            this.createNewButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            String newname = this.namingService.makeUniqueName(InstallationVariable.class, "i_" + this.commandNamesResource.var() + "_1");
            this.newNameField.setText(newname);
            this.newValueField.setText("");
            this.newVariablePanel.setVisible(true);
            this.newValueField.requestFocus();
        } else if (newState != State.UPDATE_ROW_IMMEDIATELY) {
            if (newState == State.DELETE) {
                this.createNewButton.setEnabled(false);
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.newVariablePanel.setVisible(false);
            } else if (newState == State.ROW_SELECTED) {
                this.createNewButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
                this.newVariablePanel.setVisible(false);
            } else if (newState == State.CLOSE_PANEL) {
                this.newVariablePanel.setVisible(false);
                if (this.table.getSelectionModel().isSelectionEmpty()) {
                    this.setState(State.EMPTY_SELECTION);
                } else {
                    this.setState(State.ROW_SELECTED);
                }
            } else {
                this.createNewButton.setEnabled(true);
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                this.newVariablePanel.setVisible(false);
            }
        }
    }

    private void translateGUILabels() {
        LanguagePack.translateJText(this.titleLabel);
        LanguagePack.translateJText(this.createNewButton);
        LanguagePack.translateJText(this.deleteButton);
        LanguagePack.translateJText(this.editButton);
        LanguagePack.translateJText(this.newVariablePanel);
        LanguagePack.translateJText(this.newNameLabel);
        LanguagePack.translateJText(this.newValueLabel);
        LanguagePack.translateJText(this.newOKButton);
        LanguagePack.translateJText(this.newCancelButton);
        LanguagePack.translateJText(this.editValueLabel);
        LanguagePack.translateJText(this.editOKButton);
    }

    private void copySelectedRowToEditFields() {
        this.editNameField.setText(this.getSelectedVariable());
        this.editValueField.setText(this.getSelectedValue());
        this.editingVariableName = this.getSelectedVariable();
    }

    private int getSelectedRowIndex() {
        if (this.table.getSelectionModel().getMinSelectionIndex() < 0) {
            return 0;
        }
        return this.table.convertRowIndexToModel(this.table.getSelectedRow());
    }

    public String getSelectedVariable() {
        return (String)this.table.getModel().getValueAt(this.getSelectedRowIndex(), 0);
    }

    public String getSelectedValue() {
        return (String)this.table.getModel().getValueAt(this.getSelectedRowIndex(), 1);
    }

    private void deleteSelectedRow() {
        this.tableModel = (DefaultTableModel)this.table.getModel();
        this.tableModel.removeRow(this.getSelectedRowIndex());
    }

    private void updateTable() {
        this.tableModel = (DefaultTableModel)this.table.getModel();
        this.tableModel.getDataVector().clear();
        this.tableModel.fireTableDataChanged();
        Collection<InstallationVariable> ivars = this.getInstallationVariables().getInstallationVariables();
        for (InstallationVariable ivar : ivars) {
            this.tableModel.addRow(new Object[]{ivar.getName(), ivar.getValue()});
        }
    }

    public void updateCard() {
        this.updateTable();
    }

    public void enter(Object o) {
        super.enter(o);
        if (resetViewOnEnter) {
            this.setState(State.CLOSE_PANEL);
            this.updateTable();
            resetViewOnEnter = false;
        }
        this.updateCard();
        if (!StringUtils.isNullOrOnlyWhitespace((String)this.newNameField.getText())) {
            if (this.newNameField.getText().isEmpty()) {
                this.setState(State.EMPTY_SELECTION);
            } else {
                this.newNameFieldFocusLost();
            }
        } else if (this.getInstallationVariables().getInstallationVariableByName(this.editingVariableName) == null) {
            this.setState(State.EMPTY_SELECTION);
            this.editingVariableName = "";
        }
        EventNotificationService.register((Object)((Object)this), InstallationVariableValueChangedListener.class, (Object)this.installationVariablesChanged);
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                SwingUtilities.invokeLater(() -> InstallationVariablesTab.this.updateCard());
            }
        });
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this), InstallationVariableValueChangedListener.class);
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        return super.exit();
    }

    private ConfirmationMessage confirmDeleteVariable(String selectedVariable) {
        TextResource textBundle = this.textResource;
        return new ConfirmationMessage(textBundle.confirmDeleteVariableTitle(), textBundle.confirmDeleteVariableExplanation(selectedVariable), textBundle.confirmDeleteVariableAction(), textBundle.Cancel());
    }

    protected DialogReturnValue confirmDeletion() {
        return LegacyURDialogCreator.confirmMessageDialog(this.confirmDeleteVariable(this.getSelectedVariable()));
    }

    private void sendInstallationModifiedEvent() {
        EventNotificationService.notify(InstallationStateListener.class, InstallationStateListener::installationModified);
    }

    private boolean newNameIsCool() {
        String name = this.newNameField.getText();
        if (name.isEmpty()) {
            this.showEmptyNewError();
            return false;
        }
        if (this.variableNameValidator.isValid(name)) {
            this.clearNewErrorAndEnableOK();
            return true;
        }
        this.showNewNameIsInvalidError(this.variableNameValidator.getErrorMessage(name));
        return false;
    }

    private boolean newValueIsCool() {
        String value = this.newValueField.getText();
        if (value.isEmpty()) {
            this.showEmptyNewError();
            return false;
        }
        if (this.expressionValueValidator.isValid(value)) {
            this.clearNewErrorAndEnableOK();
            return true;
        }
        this.showNewValueIsInvalidError();
        return false;
    }

    private void clearNewErrorAndEnableOK() {
        this.newOKButton.setEnabled(true);
        this.newVariableErrorMessage.setText(" ");
    }

    private void showEmptyNewError() {
        this.newOKButton.setEnabled(false);
        this.newVariableErrorMessage.setText(" ");
    }

    private InstallationVariables getInstallationVariables() {
        return (InstallationVariables)this.installationLookupService.getComponent(InstallationVariables.class);
    }

    private void initComponents() {
        JButton undoButton = new JButton();
        JPanel titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel4 = new JPanel();
        JScrollPane tablePane = new JScrollPane();
        this.table = new InstallationVariablesTable();
        JPanel bottomPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        this.createNewButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.editValueField = new JTextField();
        this.editValueField.setFocusable(false);
        this.editNameField = new JTextField();
        this.editNameField.setFocusable(false);
        this.editValueLabel = new JLabel();
        this.editOKButton = new JButton();
        this.newVariablePanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.newNameLabel = new JLabel();
        this.newNameField = new JTextField();
        this.newNameField.setFocusable(false);
        JLabel newEqualSignLabel = new JLabel();
        this.newValueField = new JTextField();
        this.newValueLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.newOKButton = new JButton();
        this.newCancelButton = new JButton();
        this.newVariableErrorMessage = new JLabel();
        undoButton.setText("Undo");
        this.setLayout(new BorderLayout());
        this.titleLabel.setText("Installation_Variables");
        titlePanel.add(this.titleLabel);
        this.add(titlePanel, "North");
        jPanel4.setLayout(new BorderLayout());
        tablePane.setViewportView(this.table);
        jPanel4.add((Component)tablePane, "Center");
        this.add(jPanel4, "Center");
        bottomPanel.setLayout(new BorderLayout());
        this.createNewButton.setText("Create_New");
        this.createNewButton.addActionListener(evt -> this.createNewButtonActionPerformed());
        buttonPanel.add(this.createNewButton);
        this.editButton.setText("Edit_Value");
        this.editButton.setName("editValue");
        buttonPanel.add(this.editButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(evt -> this.deleteButtonActionPerformed());
        buttonPanel.add(this.deleteButton);
        bottomPanel.add((Component)buttonPanel, "South");
        GridBagLayout structurePanelLayout = new GridBagLayout();
        int[] nArray = new int[9];
        nArray[1] = 12;
        nArray[3] = 12;
        nArray[5] = 12;
        nArray[7] = 12;
        structurePanelLayout.columnWidths = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 5;
        nArray2[3] = 5;
        nArray2[5] = 5;
        structurePanelLayout.rowHeights = nArray2;
        this.editValueField.setMinimumSize(new Dimension(200, 28));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.editOKButton.setText("OK");
        this.editOKButton.setMinimumSize(new Dimension(60, 33));
        this.editOKButton.setName("editOK");
        this.editOKButton.addActionListener(evt -> this.updateInstallationVariableValue());
        this.newVariablePanel.setBorder(BorderFactory.createTitledBorder("Create_new_installation_variable"));
        this.newVariablePanel.setLayout(new BorderLayout());
        jPanel2.setBorder(null);
        GridBagLayout jPanel2Layout = new GridBagLayout();
        int[] nArray3 = new int[9];
        nArray3[1] = 12;
        nArray3[3] = 12;
        nArray3[5] = 12;
        nArray3[7] = 12;
        jPanel2Layout.columnWidths = nArray3;
        int[] nArray4 = new int[9];
        nArray4[1] = 5;
        nArray4[3] = 5;
        nArray4[5] = 5;
        nArray4[7] = 5;
        jPanel2Layout.rowHeights = nArray4;
        jPanel2.setLayout(jPanel2Layout);
        this.newNameLabel.setText("Name");
        this.newNameLabel.setPreferredSize(new Dimension(150, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        jPanel2.add((Component)this.newNameLabel, gridBagConstraints);
        this.newNameField.setText("new_var");
        this.newNameField.setPreferredSize(new Dimension(150, 28));
        this.newNameField.addCaretListener(evt -> this.newNameFieldCaretUpdate());
        this.newNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                InstallationVariablesTab.this.newNameFieldFocusLost();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.newNameField, gridBagConstraints);
        newEqualSignLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
        newEqualSignLabel.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        jPanel2.add((Component)newEqualSignLabel, gridBagConstraints);
        this.newValueField.setMinimumSize(new Dimension(200, 28));
        this.newValueField.addCaretListener(evt -> this.newValueFieldCaretUpdate());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.newValueField, gridBagConstraints);
        this.newValueLabel.setText("Value");
        this.newValueLabel.setPreferredSize(new Dimension(300, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        jPanel2.add((Component)this.newValueLabel, gridBagConstraints);
        this.newVariablePanel.add((Component)jPanel2, "North");
        this.newOKButton.setText("OK");
        this.newOKButton.setMinimumSize(new Dimension(60, 33));
        this.newOKButton.setName("newOK");
        this.newOKButton.addActionListener(evt -> this.createInstallationVariable());
        this.newCancelButton.setText("Cancel");
        this.newCancelButton.addActionListener(evt -> this.newCancelButtonActionPerformed());
        this.newVariableErrorMessage.setForeground(new Color(145, 41, 41));
        this.newVariableErrorMessage.setHorizontalAlignment(11);
        this.newVariableErrorMessage.setText("createVariableErrorMessage");
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.newVariableErrorMessage, -2, 345, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 413, Short.MAX_VALUE).addComponent(this.newOKButton, -2, -1, -2).addGap(18, 18, 18).addComponent(this.newCancelButton).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newCancelButton).addComponent(this.newOKButton, -2, -1, -2).addComponent(this.newVariableErrorMessage, -2, 33, -2)));
        this.newVariablePanel.add((Component)jPanel3, "Center");
        bottomPanel.add((Component)this.newVariablePanel, "Center");
        this.add(bottomPanel, "South");
    }

    private void createNewButtonActionPerformed() {
        this.setState(State.NEW);
    }

    private void deleteButtonActionPerformed() {
        this.setState(State.DELETE);
        DialogReturnValue ret = this.confirmDeletion();
        if (ret == DialogReturnValue.OK) {
            this.programStateService.stop();
            this.namingService.deregisterNamedEntity((NamedEntity)this.getInstallationVariables().getInstallationVariableByName(this.getSelectedVariable()));
            this.getInstallationVariables().removeInstallationVariable(this.getSelectedVariable());
            this.deleteSelectedRow();
        }
        this.setState(State.CLOSE_PANEL);
    }

    private void createInstallationVariable() {
        String fieldName = this.newNameField.getText();
        String value = this.newValueField.getText();
        this.getInstallationVariables().addInstallationVariable(fieldName, value);
        this.namingService.registerNamedEntity((NamedEntity)this.getInstallationVariables().getInstallationVariableByName(fieldName));
        this.setState(State.CLOSE_PANEL);
        this.editingVariableName = "";
        this.clearNewVariableInputs();
        this.updateCard();
    }

    private void newCancelButtonActionPerformed() {
        this.newValueField.setText("");
        this.setState(State.CLOSE_PANEL);
        this.editingVariableName = "";
        this.clearNewVariableInputs();
    }

    private void updateInstallationVariableValue() {
        InstallationVariable variable = this.getInstallationVariables().getInstallationVariableByName(this.editNameField.getText());
        variable.setValue(this.editValueField.getText());
        this.setState(State.CLOSE_PANEL);
        this.editingVariableName = "";
        this.sendInstallationModifiedEvent();
    }

    private void newNameFieldCaretUpdate() {
        if (this.newNameIsCool()) {
            this.newValueIsCool();
        }
    }

    private void newValueFieldCaretUpdate() {
        if (this.newValueIsCool()) {
            this.newNameIsCool();
        }
    }

    private void newNameFieldFocusLost() {
        String newName = this.namingService.toVariableName(this.newNameField.getText());
        int maxNameLength = this.namingService.maxNameLength(InstallationVariable.class);
        if (newName.length() > maxNameLength) {
            newName = newName.substring(0, maxNameLength);
        }
        this.newNameField.setText(newName);
        if (this.namingService.isNameUsed(InstallationVariable.class, newName)) {
            this.showNewNameIsUsedError();
        }
    }

    private void showNewValueIsInvalidError() {
        this.newOKButton.setEnabled(false);
        this.newVariableErrorMessage.setHorizontalAlignment(4);
        this.newVariableErrorMessage.setText(this.textResource.valueIsNotValid());
    }

    private void showNewNameIsUsedError() {
        this.newOKButton.setEnabled(false);
        this.newVariableErrorMessage.setHorizontalAlignment(2);
        this.newVariableErrorMessage.setText(this.textResource.variableNameAlreadyExists());
    }

    private void showNewNameIsInvalidError(String message) {
        this.newOKButton.setEnabled(false);
        this.newVariableErrorMessage.setHorizontalAlignment(2);
        this.newVariableErrorMessage.setText(StringUtils.isNullOrOnlyWhitespace((String)message) ? this.textResource.illegalVariableName() : message);
    }

    private static enum State {
        EMPTY_SELECTION,
        ROW_SELECTED,
        CLOSE_PANEL,
        NEW,
        DELETE,
        UPDATE_ROW_IMMEDIATELY;

    }
}

