/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.domain.PreSetInstallation;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.infrastructure.FilePersistence;
import javax.inject.Inject;

public class SaveInstallationVariablesForOldInstallation
implements PreSetInstallation {
    private final FilePersistence persistence;

    @Inject
    public SaveInstallationVariablesForOldInstallation(FilePersistence persistence) {
        this.persistence = persistence;
    }

    public void preLoad(Installation iOldInstallation, Installation iNewInstallation) {
        if (iOldInstallation == null) {
            return;
        }
        Installation oldInstallation = iOldInstallation;
        Installation newInstallation = iNewInstallation;
        this.persistence.save(oldInstallation);
        if (this.isSameInstallation(oldInstallation, newInstallation)) {
            newInstallation.setComponent(oldInstallation.getComponent(InstallationVariables.class));
        }
    }

    private boolean isSameInstallation(Installation oldInstallation, Installation newInstallation) {
        return EqualsUtil.equals((Object)oldInstallation.getMetaData(PersistanceMetaData.class), (Object)newInstallation.getMetaData(PersistanceMetaData.class));
    }
}

