/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.program.ProgramStateListener;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.util.event.EventManager;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.InstallationVariableValueChangedListener;
import com.ur.view.variables.domain.InstallationVariables;
import com.ur.view.variables.infrastructure.Persistence;
import com.ur.view.variables.infrastructure.VariablesSettings;
import gui.installation.RobotInstallationLookupService;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;

public final class SaveInstallationVariablesOnInterval {
    private final ProgramPlayingTracker programPlaying;
    private final Persistence persistence;
    private final RobotInstallationLookupService lookupService;

    @Inject
    public SaveInstallationVariablesOnInterval(VariablesSettings settings, EventManager eventManager, Persistence persistence, RobotInstallationLookupService lookupService) {
        this.persistence = persistence;
        this.lookupService = lookupService;
        this.programPlaying = new ProgramPlayingTracker(settings, this);
        eventManager.addStrongListener(ProgramStateListener.class, (Object)this.programPlaying);
        eventManager.addStrongListener(InstallationVariableValueChangedListener.class, (Object)this.programPlaying);
    }

    public void requestToSave() {
        Installation installation = this.lookupService.getInstallation();
        if (installation != null && ((InstallationVariables)installation.getComponent(InstallationVariables.class)).isModified()) {
            this.persistence.save(installation);
        }
    }

    private static class ProgramPlayingTracker
    implements ProgramStateListener,
    InstallationVariableValueChangedListener {
        private final long saveIntervalInMilliseconds;
        private ProgramState currentProgramState;
        private Timer periodicSaveTimer;
        private SaveInstallationVariablesOnInterval performSave;

        public ProgramPlayingTracker(VariablesSettings settings, SaveInstallationVariablesOnInterval performSave) {
            this.saveIntervalInMilliseconds = settings.getInstallationVariableSaveIntervalInMilliseconds();
            this.performSave = performSave;
        }

        public void programStateChanged(ProgramState oldState, ProgramState newState) {
            if (this.isPersisting() && this.isStoppingOrPausing(newState)) {
                this.performSave.requestToSave();
                this.periodicSaveTimer.cancel();
                this.periodicSaveTimer = null;
            }
            this.currentProgramState = newState;
            if (!this.isPersisting() && this.isPlaying()) {
                this.periodicSaveTimer = new Timer("Auto-save-InstallationVariables", true);
                this.periodicSaveTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        if (this.isPlaying()) {
                            performSave.requestToSave();
                        }
                    }
                }, this.saveIntervalInMilliseconds, this.saveIntervalInMilliseconds);
            }
        }

        private boolean isStoppingOrPausing(ProgramState newState) {
            return EqualsUtil.equalsOneOf((Object)newState, (Object[])new ProgramState[]{ProgramState.STOPPED, ProgramState.PAUSED});
        }

        private boolean isPersisting() {
            return this.periodicSaveTimer != null;
        }

        public boolean isPlaying() {
            return this.currentProgramState == ProgramState.PLAYING;
        }

        @Override
        public void valueChanged(InstallationVariable variable) {
            if (!this.isPlaying()) {
                this.performSave.requestToSave();
            }
        }
    }
}

