/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.variables.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.expression.Expression;
import com.ur.util.CollectionUtils;
import com.ur.util.Optional;
import com.ur.util.Predicate;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.VariablesValues;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.core.VariableSet;
import com.ur.view.variables.domain.VariableLookupService;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.ProgramReferenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VariableLookupServiceImpl
implements VariableLookupService {
    private final NamingService variableCache;
    private final FeaturesLookup lookupService;
    private final ProgramReferenceService programReferenceService;
    private final VariablesValues variablesValues;

    @Inject
    public VariableLookupServiceImpl(NamingService variableCache, FeaturesLookup lookupService, ProgramReferenceService programReferenceService, VariablesValues variablesValues) {
        this.variableCache = variableCache;
        this.lookupService = lookupService;
        this.programReferenceService = programReferenceService;
        this.variablesValues = variablesValues;
    }

    @Override
    public Variable variableByName(String name) {
        List entitiesWithName = this.variableCache.getEntitiesWithName(name);
        for (NamedEntity each : entitiesWithName) {
            if (!(each instanceof Variable) || !EqualsUtil.equals((Object)each.getName(), (Object)name)) continue;
            return (Variable)each;
        }
        return null;
    }

    @Override
    public SpatialFeature featureByName(String name) {
        for (SpatialFeature each : this.lookupService.getFeatureContainer().getAllSpatialFeatures()) {
            if (!EqualsUtil.equals((Object)each.getName(), (Object)name)) continue;
            return each;
        }
        return null;
    }

    @Override
    public Collection<String> getFeatureNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (GeomFeature each : this.lookupService.getFeatureContainer().getAllGeomNodes()) {
            result.add(each.getName());
        }
        return result;
    }

    @Override
    public Collection<NamedEntity> getAllGeomFeaturesByName(final String name) {
        return CollectionUtils.filter(this.getAllGeomFeatureNodes(), (Predicate)new Predicate<NamedEntity>(){

            public boolean test(NamedEntity t) {
                return EqualsUtil.equals((Object)name, (Object)t.getName());
            }
        });
    }

    @Override
    public Collection<NamedEntity> getAllNamedEntities() {
        return this.getAllVariableNamedEntities();
    }

    @Override
    public Collection<NamedEntity> getVariablesByName(String name) {
        ArrayList<NamedEntity> result = new ArrayList<NamedEntity>();
        for (NamedEntity each : this.variableCache.getEntitiesWithName(name)) {
            GeomFeature feature;
            if (each instanceof Variable) {
                result.add(each);
            }
            if (each instanceof GeomFeature && (feature = (GeomFeature)each).isVariable()) {
                result.add(this.programReferenceService.getGeomFeatureVariable(feature));
            }
            if (!(each instanceof InstallationVariable)) continue;
            InstallationVariable installationVariable = (InstallationVariable)each;
            result.add(this.programReferenceService.getInstallationVariableReference(installationVariable));
        }
        return result;
    }

    @Override
    public Collection<NamedEntity> getVariablesByNameAndType(String name, final Class<? extends Variable> variableClass) {
        return CollectionUtils.filter(this.getVariablesByName(name), (Predicate)new Predicate<NamedEntity>(){

            public boolean test(NamedEntity t) {
                return t.getClass().equals(variableClass);
            }
        });
    }

    @Override
    public Collection<NamedEntity> getVariablesByType(final Class<? extends Variable> variableClass) {
        return CollectionUtils.filter(this.getAllNamedEntities(), (Predicate)new Predicate<NamedEntity>(){

            public boolean test(NamedEntity t) {
                return t.getClass().equals(variableClass);
            }
        });
    }

    @Override
    public Collection<NamedEntity> getVariablesByPredicate(final Predicate<Variable> predicate) {
        return CollectionUtils.filter(this.getAllNamedEntities(), (Predicate)new Predicate<NamedEntity>(){

            public boolean test(NamedEntity t) {
                return t instanceof Variable && predicate.test((Object)((Variable)t));
            }
        });
    }

    @Override
    public Collection<NamedEntity> getInstallationVariablesByName(String name) {
        return this.getVariablesByNameAndType(name, InstallationVariableReference.class);
    }

    @Override
    public Optional<Variable> getVariableFromNamedEntity(NamedEntity namedEntity) {
        GeomFeature feature;
        if (namedEntity instanceof Variable) {
            return Optional.of((Object)((Variable)namedEntity));
        }
        if (namedEntity instanceof GeomFeature && (feature = (GeomFeature)namedEntity).isVariable()) {
            return Optional.of((Object)this.programReferenceService.getGeomFeatureVariable(feature));
        }
        if (namedEntity instanceof InstallationVariable) {
            InstallationVariable installationVariable = (InstallationVariable)namedEntity;
            return Optional.of((Object)this.programReferenceService.getInstallationVariableReference(installationVariable));
        }
        return Optional.empty();
    }

    private Collection<NamedEntity> getAllGeomFeatureNodes() {
        return new ArrayList<NamedEntity>(this.lookupService.getFeatureContainer().getAllGeomNodes());
    }

    @Override
    public VariableSet getAllProgramAndInstallationVariables() {
        VariableSet result = new VariableSet();
        List<NamedEntity> allVariableNamedEntities = this.getAllVariableNamedEntities();
        result.addAll(CollectionUtils.filter(allVariableNamedEntities, ProgramVariable.class));
        result.addAll(CollectionUtils.filter(allVariableNamedEntities, InstallationVariableReference.class));
        result.addAll(CollectionUtils.filter(allVariableNamedEntities, GeomFeatureVariable.class));
        return result;
    }

    private List<NamedEntity> getAllVariableNamedEntities() {
        ArrayList<NamedEntity> result = new ArrayList<NamedEntity>();
        for (NamedEntity each : this.variableCache.getAllEntities().getFilteredCollection()) {
            GeomFeature feature;
            if (each instanceof Variable) {
                result.add(each);
            }
            if (each instanceof GeomFeature && (feature = (GeomFeature)each).isVariable()) {
                result.add(this.programReferenceService.getGeomFeatureVariable(feature));
            }
            if (!(each instanceof InstallationVariable)) continue;
            InstallationVariable installationVariable = (InstallationVariable)each;
            result.add(this.programReferenceService.getInstallationVariableReference(installationVariable));
        }
        return result;
    }

    @Override
    public ScriptWriter generatePreambleScript(ScriptWriter writer, ScriptGenerator scriptGeneratorLookup, final Class<?> variableClass, boolean force, boolean initVariables) {
        Predicate<Variable> predicate = new Predicate<Variable>(){

            public boolean test(Variable variable) {
                return variable.getClass().equals(variableClass);
            }
        };
        return this.generatePreambleScript(writer, scriptGeneratorLookup, predicate, force, initVariables);
    }

    @Override
    public ScriptWriter generatePreambleScript(ScriptWriter writer, ScriptGenerator scriptGeneratorLookup, Predicate<Variable> predicate, boolean force, boolean initVariables) {
        scriptGeneratorLookup.scriptBegin(writer);
        VariableSet variables = this.getAllProgramAndInstallationVariables();
        for (Variable each : variables) {
            if (!predicate.test((Object)each)) continue;
            if (each.prefersPersistentValue()) {
                String value = this.variablesValues.getValue(each.getScriptName());
                if (!StringUtils.isNullOrEmpty((String)value)) {
                    writer.globalVariable(each.getScriptName(), value);
                    continue;
                }
                if (!this.hasExpression(initVariables, each)) continue;
                Expression expression = this.getExpression(initVariables, each);
                writer.globalVariable(each.getScriptName(), expression.getScriptCodeText());
                continue;
            }
            if (this.hasExpression(initVariables, each)) {
                Expression expression = this.getExpression(initVariables, each);
                writer.globalVariable(each.getScriptName(), expression.getScriptCodeText());
                continue;
            }
            if (!force) continue;
            writer.globalVariable(each.getScriptName(), "0");
        }
        scriptGeneratorLookup.scriptEnd(writer);
        return writer;
    }

    private boolean hasExpression(boolean initVariables, Variable variable) {
        if (!initVariables && variable instanceof ProgramVariable) {
            return ((ProgramVariable)variable).hasInitExpression();
        }
        return variable.hasExpression();
    }

    private Expression getExpression(boolean initVariables, Variable variable) {
        if (variable instanceof ProgramVariable && !initVariables) {
            return ((ProgramVariable)variable).getInitExpression();
        }
        return variable.getExpression();
    }
}

