/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.swing.units.Units;
import gui.program.AccelerationValueNode;
import gui.tools.LegacyURDialogCreator;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.text.JTextComponent;

public final class AccelerationFieldParser {
    private static DecimalFormat f = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.#");
    private static JointConfigurationSettings jointConfigurationSettings;
    @Inject
    private static TextResource textResource;

    private AccelerationFieldParser() {
    }

    @Inject
    public static void setJointConfigurationSettings(JointConfigurationSettings jointConfigurationSettings) {
        AccelerationFieldParser.jointConfigurationSettings = jointConfigurationSettings;
    }

    public static void parse(JTextComponent jText, AccelerationValueNode node) {
        try {
            double acceleration = node.isCartesianMotion() ? Units.convert_to_m_s2((String)jText.getText()) : Math.toRadians(PrimitiveUtils.parseDouble((String)jText.getText()));
            if (acceleration < 0.0) {
                acceleration = -acceleration;
            }
            double maxValue = URMath.getMaxValue((double[])jointConfigurationSettings.getJointMaxAcceleration());
            Acceleration maxAcceleration = Acceleration.from((double)maxValue, (Acceleration.Unit)Acceleration.Unit.SI);
            if (!node.isCartesianMotion() && acceleration > maxValue) {
                node.setAcceleration(maxAcceleration);
                AccelerationFieldParser.update(jText, node);
            } else if (node.isCartesianMotion() && acceleration > 150.0) {
                node.setAcceleration(Acceleration.from((double)150.0, (Acceleration.Unit)Acceleration.Unit.SI));
                AccelerationFieldParser.update(jText, node);
            } else {
                node.setAcceleration(Acceleration.from((double)acceleration, (Acceleration.Unit)Acceleration.Unit.SI));
            }
        }
        catch (Exception exception) {
            LegacyURDialogCreator.showErrorDialog(textResource.errorParseerror(), textResource.notANumber(), "");
            AccelerationFieldParser.update(jText, node);
        }
    }

    public static void update(JTextComponent jText, AccelerationValueNode node) {
        if (node.isCartesianMotion()) {
            jText.setText(Units.convert_from_m_s2((double)node.getCartesianAcceleration(), (DecimalFormat)f, (DecimalFormat)f));
        } else {
            jText.setText(f.format(Math.toDegrees(node.getJointAcceleration())));
        }
    }
}

