/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.resources.IllustrationImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ViewContext;
import com.ur.view.program.CommandPanel;
import gui.program.CircleMoveNode;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public abstract class CircleMoveCard
extends CommandPanel<CircleMoveNode> {
    protected JLabel circleMoveIllustrationLabel;
    protected JLabel circelMoveDescriptionLabel;
    protected ViewContext view;
    protected final TextResource textResource;
    protected JRadioButton unconstrainedRadioButton;
    protected JRadioButton fixedRadioButton;

    public CircleMoveCard(ViewContext view) {
        super(CircleMoveNode.class);
        this.view = view;
        this.textResource = (TextResource)view.getTextResource(TextResource.class);
        this.initComponents();
    }

    @Override
    protected void updateCard() {
        this.update();
    }

    private void update() {
        switch (((CircleMoveNode)this.getNode()).getOrientationMode()) {
            case FIXED: {
                this.fixedRadioButton.setSelected(true);
                this.circelMoveDescriptionLabel.setText(this.textResource.circleMoveFixedDescription());
                this.circleMoveIllustrationLabel.setIcon(IllustrationImageResource.movecConstant());
                break;
            }
            case UNCONSTRAINED: {
                this.unconstrainedRadioButton.setSelected(true);
                this.circelMoveDescriptionLabel.setText(this.textResource.circleMoveDescription());
                this.circleMoveIllustrationLabel.setIcon(IllustrationImageResource.movecNotConstant());
            }
        }
    }

    protected abstract void initComponents();

    protected class FixedMode
    extends AbstractActionDefinition {
        public FixedMode(TextResource text) {
            this.putValue("Name", text.circleMoveFixedOrientation());
        }

        public void actionPerformed(ActionEvent e) {
            ((CircleMoveNode)CircleMoveCard.this.getNode()).setOrientationMode(CircleMoveNode.OrientationMode.FIXED);
            CircleMoveCard.this.update();
        }
    }

    protected class UnconstrainedMode
    extends AbstractActionDefinition {
        public UnconstrainedMode(TextResource text) {
            this.putValue("Name", text.circleMoveUnconstrainedOrientation());
        }

        public void actionPerformed(ActionEvent e) {
            ((CircleMoveNode)CircleMoveCard.this.getNode()).setOrientationMode(CircleMoveNode.OrientationMode.UNCONSTRAINED);
            CircleMoveCard.this.update();
        }
    }
}

