/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.SwingUtil;
import gui.polyscope.program.ProgramPanel;
import gui.program.ProgramRootNode;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ControlProgramTreeStructure {
    private final Provider<ProgramPanel> programPanel;

    @Inject
    public ControlProgramTreeStructure(Provider<ProgramPanel> programPanel) {
        this.programPanel = programPanel;
    }

    public void collapsePathTo(TreeNode node) {
        if (!(node instanceof AbstractProgramNode)) {
            return;
        }
        AbstractProgramNode programNode = (AbstractProgramNode)node;
        ProgramRootNode programRootNode = ProgramRootNode.get(programNode);
        if (programRootNode == null) {
            return;
        }
        final TreePath path = new TreePath(programNode.getPath());
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (((ProgramPanel)ControlProgramTreeStructure.this.programPanel.get()).getProgramTree().isCollapsed(path)) {
                    ((ProgramPanel)ControlProgramTreeStructure.this.programPanel.get()).getProgramTree().repaint();
                } else {
                    ((ProgramPanel)ControlProgramTreeStructure.this.programPanel.get()).getProgramTree().collapsePath(path);
                }
            }
        });
    }

    public void expandPathTo(TreeNode node) {
        if (!(node instanceof AbstractProgramNode)) {
            return;
        }
        AbstractProgramNode programNode = (AbstractProgramNode)node;
        ProgramRootNode programRootNode = ProgramRootNode.get(programNode);
        if (programRootNode == null) {
            return;
        }
        final TreePath path = new TreePath(programNode.getPath());
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ProgramPanel)ControlProgramTreeStructure.this.programPanel.get()).getProgramTree().expandPath(path);
            }
        });
    }

    public void makeVisible(TreeNode node) {
        if (!(node instanceof AbstractProgramNode)) {
            return;
        }
        AbstractProgramNode programNode = (AbstractProgramNode)node;
        final TreePath path = new TreePath(programNode.getPath());
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ((ProgramPanel)ControlProgramTreeStructure.this.programPanel.get()).getProgramTree().makeVisible(path);
            }
        });
    }

    public void makeChildrenVisible(TreeNode node) {
        if (node.getChildCount() > 0) {
            TreeNode lastChild = node.getChildAt(node.getChildCount() - 1);
            this.makeVisible(lastChild);
        }
    }
}

