/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.lang.StringUtils;
import com.ur.swing.URFontFactory;
import com.ur.util.swing.HTML;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailsPanelBuilder {
    public static final String TITLE_LABEL_NAME = "TitleLabel";
    public static final String MESSAGE_LABEL_NAME = "MessageLabel";
    public static final String BUTTON_LABEL_NAME = "ButtonLabel";
    private static final int TABLE_INDENT = 20;
    private String title = "";
    private String prologue = "";
    private String epilogue = "";
    private String buttonLabel = "";
    private Map<String, String> details = new LinkedHashMap<String, String>();
    private Runnable okListener = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final URFontFactory fontFactory;

    @Inject
    public DetailsPanelBuilder(URFontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    public DetailsPanelBuilder setTitle(String title) {
        this.title = StringUtils.trim((Object)title);
        return this;
    }

    public DetailsPanelBuilder setPrologue(String prologue) {
        this.prologue = StringUtils.trim((Object)prologue);
        return this;
    }

    public DetailsPanelBuilder setEpilogue(String epilogue) {
        this.epilogue = StringUtils.trim((Object)epilogue);
        return this;
    }

    public DetailsPanelBuilder addDetails(Object label, Object value) {
        if (label != null && value != null && !value.toString().isEmpty()) {
            this.details.put(label.toString(), value.toString());
        }
        return this;
    }

    public DetailsPanelBuilder setOkListener(String buttonLabel, Runnable okListener) {
        this.buttonLabel = StringUtils.trim((Object)buttonLabel);
        this.okListener = okListener;
        return this;
    }

    public JComponent build() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (!StringUtils.isNullOrEmpty((String)this.title)) {
            panel.add(this.createTitleLabel(), this.getTitleLayoutConstraints(gbc));
        }
        panel.add(this.createMessageLabel(), this.getMessageLayoutConstraints(gbc));
        panel.add(this.createButtonPanel(), this.getButtonPanelConstraints(gbc));
        return panel;
    }

    private Component createTitleLabel() {
        JLabel titleLabel = new JLabel();
        titleLabel.setName(TITLE_LABEL_NAME);
        titleLabel.setText(this.title);
        titleLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE));
        return titleLabel;
    }

    private GridBagConstraints getTitleLayoutConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        return gbc;
    }

    private Component createMessageLabel() {
        JLabel messageLabel = new JLabel();
        messageLabel.setName(MESSAGE_LABEL_NAME);
        messageLabel.setText(this.createMessageHTML());
        messageLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.DEFAULT, URFontFactory.Size.DEFAULT));
        return messageLabel;
    }

    private GridBagConstraints getMessageLayoutConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        return gbc;
    }

    private String createMessageHTML() {
        StringBuilder sb = new StringBuilder().append(HTML.br()).append(HTML.p((String)this.prologue)).append(HTML.br()).append(HTML.indentLeft((int)20, (String)this.createURCapInfoHTMLTable())).append(HTML.br()).append(HTML.p((String)this.epilogue));
        return HTML.html((String)sb.toString());
    }

    protected String createURCapInfoHTMLTable() {
        StringBuilder rows = new StringBuilder();
        for (Map.Entry<String, String> label : this.details.entrySet()) {
            rows.append(this.createHTMLTableRow(label.getKey(), label.getValue()));
        }
        return HTML.tableWithProperties((String)"", (String[])new String[]{rows.toString()});
    }

    protected String createHTMLTableRow(Object label, Object value) {
        return HTML.tableRow((String[])new String[]{HTML.tableCellAlignTop((String)HTML.fontBold((String)label.toString())), HTML.tableCellAlignTop((String)value.toString())});
    }

    private Component createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        if (!StringUtils.isNullOrEmpty((String)this.buttonLabel)) {
            JButton button = this.createButton(this.buttonLabel, this.okListener);
            buttonPanel.add((Component)button, this.createButtonPanelConstraints());
        }
        return buttonPanel;
    }

    private GridBagConstraints getButtonPanelConstraints(GridBagConstraints gbc) {
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 14;
        gbc.fill = 1;
        return gbc;
    }

    private JButton createButton(String buttonLabel, final Runnable okListener) {
        JButton button = new JButton(buttonLabel);
        button.setName(BUTTON_LABEL_NAME);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okListener.run();
            }
        });
        return button;
    }

    private GridBagConstraints createButtonPanelConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 14;
        return gbc;
    }
}

