/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.swing.HTML;
import com.ur.view.action.DeleteNodeAction;
import com.ur.view.program.CommandPanel;
import gui.program.EntityFactory;
import gui.program.IfNode;
import gui.program.ProgramRootNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ElseIfCard
extends CommandPanel<IfNode> {
    private final EntityFactory entityFactory;
    private final ExpressionField expEdit;
    private final DeleteNodeAction deleteNodeAction;
    private JCheckBox checkConditionContinuouslyCheckBox;
    private JLabel checkConditionContinuouslyHelpText;

    @Inject
    ElseIfCard(ViewContext viewContext, ExpressionField expEditor, EntityFactory entityFactory, DeleteNodeAction deleteNodeAction) {
        super(IfNode.class, viewContext);
        this.deleteNodeAction = deleteNodeAction;
        this.expEdit = expEditor;
        this.entityFactory = entityFactory;
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.getViewContext().getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_else_condition");
    }

    @Override
    protected void updateCard() {
        this.expEdit.setNodeWithExpression((ExpressionNodeProperty)this.getNode());
        this.checkConditionContinuouslyCheckBox.setSelected(((IfNode)this.getNode()).isCheckConditionInSeperateThread());
    }

    private void initComponents() {
        JButton insertElseIfButton = new JButton();
        JButton removeElseIfButton = new JButton();
        JLabel jLabel1 = new JLabel();
        JPanel jPanel1 = new JPanel();
        ExpressionField expressionTextField = this.expEdit;
        JLabel jLabel4 = new JLabel();
        this.checkConditionContinuouslyCheckBox = new JCheckBox();
        this.checkConditionContinuouslyHelpText = new JLabel();
        JLabel jLabel2 = new JLabel();
        Box.Filler filler1 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class);
        insertElseIfButton.setText(textResource.insertNode(commandNamesResource.ElseIf()));
        insertElseIfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElseIfCard.this.insertElseIfButtonActionPerformed();
            }
        });
        removeElseIfButton.setText(textResource.confirmRemoveThisCommand(commandNamesResource.ElseIf()));
        removeElseIfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElseIfCard.this.removeElseIfButtonActionPerformed();
            }
        });
        jLabel1.setText(HTML.html((String)HTML.h1((String)commandNamesResource.ElseIf())));
        expressionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((IfNode)ElseIfCard.this.getNode()).textHasChanged();
            }
        });
        expressionTextField.setHorizontalAlignment(0);
        expressionTextField.setPreferredSize(new Dimension(300, 28));
        jLabel4.setText(commandNamesResource.ElseIf());
        this.checkConditionContinuouslyCheckBox.setText(textResource.checkExpressionContinuously());
        this.checkConditionContinuouslyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ElseIfCard.this.checkConditionContinuouslyCheckBoxItemStateChanged(evt);
                ElseIfCard.this.checkConditionContinuouslyHelpText.setVisible(!ElseIfCard.this.checkConditionContinuouslyHelpText.isShowing());
            }
        });
        this.checkConditionContinuouslyHelpText.setVisible(this.checkConditionContinuouslyCheckBox.isSelected());
        this.checkConditionContinuouslyHelpText.setText(textResource.checkExpressionContinuouslyHelpText());
        jLabel2.setText(textResource.commandElseIf());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)expressionTextField, -1, 706, Short.MAX_VALUE).addComponent(this.checkConditionContinuouslyCheckBox, -2, 454, -2).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.checkConditionContinuouslyHelpText, -1, 706, -2)).addGap(0, 0, Short.MAX_VALUE))).addComponent((Component)expressionTextField, GroupLayout.Alignment.LEADING, -1, 497, Short.MAX_VALUE)).addGap(2, 2, 2).addComponent(filler1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(jLabel1, -1, 131, Short.MAX_VALUE).addGap(423, 423, 423)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(insertElseIfButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(removeElseIfButton)).addComponent(jLabel2, -2, 542, -2)).addContainerGap(62, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)expressionTextField, -2, -1, -2).addComponent(jLabel4, -2, 31, -2))).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(filler1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkConditionContinuouslyCheckBox).addComponent(this.checkConditionContinuouslyHelpText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addComponent(jPanel1, -2, -1, -2).addGap(46, 46, 46).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(insertElseIfButton).addComponent(removeElseIfButton)).addContainerGap()));
    }

    private void removeElseIfButtonActionPerformed() {
        this.deleteNodeAction.execute((AbstractProgramNode)this.getNode());
    }

    private void insertElseIfButtonActionPerformed() {
        IfNode node = (IfNode)this.getNode();
        IfNode elseIfNode = this.entityFactory.createElseIfNode();
        AbstractProgramNode parent = (AbstractProgramNode)node.getParent();
        int index = parent.getIndex((TreeNode)((Object)node)) + 1;
        ProgramRootNode programRootNode = ProgramRootNode.get(node);
        programRootNode.getProgramTreeModel().insertNodeInto((MutableTreeNode)((Object)elseIfNode), (MutableTreeNode)parent, index);
    }

    private void checkConditionContinuouslyCheckBoxItemStateChanged(ItemEvent evt) {
        ((IfNode)this.getNode()).setCheckConditionInSeperateThread(evt.getStateChange() == 1);
    }
}

