/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputField;
import com.ur.swing.ViewContext;
import com.ur.view.program.CommandPanel;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.program.FolderNode;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class FolderCard
extends CommandPanel<FolderNode> {
    public static final String RENAME_FOLDER = "GeomCardRenameFolder";
    private final ViewContext context;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private InputField folderNameField;
    private JCheckBox hideSubtreeCheckBox;

    @Inject
    FolderCard(ViewContext context, ControlProgramTreeStructure controlProgramTreeStructure) {
        super(FolderNode.class);
        this.context = context;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.initComponents();
        context.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_folder");
    }

    @Override
    public void updateCard() {
        this.folderNameField.setText(((FolderNode)this.getNode()).getName());
        this.hideSubtreeCheckBox.setSelected(((FolderNode)this.getNode()).getKeepHidden());
    }

    public InputField getFolderNameField() {
        return this.folderNameField;
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.context.getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.context.getTextResource(CommandNamesResource.class);
        this.folderNameField = new InputField();
        this.folderNameField.setName(RENAME_FOLDER);
        this.folderNameField.setHorizontalAlignment(0);
        this.folderNameField.setFocusable(false);
        this.folderNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FolderNode)FolderCard.this.getNode()).setName(FolderCard.this.folderNameField.getText());
            }
        });
        this.hideSubtreeCheckBox = new JCheckBox(textResource.hideFolderProgramTree());
        this.hideSubtreeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FolderCard.this.hideSubtreeCheckBoxItemStateChanged();
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.context.createFormBuilder().headerLabel(commandNamesResource.Folder(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().description(textResource.commandFolder(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end(2).label(textResource.pleaseEnterTextToBeDisplayedInTheProgramTree(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.folderNameField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().getPanel(), "North");
        this.add(this.context.createFormBuilder().component((JComponent)this.hideSubtreeCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().getPanel(), "South");
    }

    private void hideSubtreeCheckBoxItemStateChanged() {
        FolderNode node = (FolderNode)this.getNode();
        node.setKeepHidden(this.hideSubtreeCheckBox.isSelected());
        if (node.getKeepHidden()) {
            this.controlProgramTreeStructure.collapsePathTo((TreeNode)((Object)node));
        } else {
            this.controlProgramTreeStructure.expandPathTo((TreeNode)((Object)node));
        }
    }

    public AbstractButton getHideSubtree() {
        return this.hideSubtreeCheckBox;
    }
}

