/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.swing.HTML;
import com.ur.view.action.DeleteNodeAction;
import com.ur.view.program.CommandPanel;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.program.EntityFactory;
import gui.program.IfNode;
import gui.program.ProgramRootNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class IfCard
extends CommandPanel<IfNode> {
    public static String ADD_ELSE_IF_BUTTON = "addElseIfButton." + IfCard.class.getSimpleName();
    private final EntityFactory entityFactory;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private final ExpressionField expEdit;
    private final DeleteNodeAction deleteNodeAction;
    private JCheckBox checkConditionContinuouslyCheckBox;
    private JButton addRemoveElseButton;
    private JLabel checkConditionContinuouslyHelpText;

    @Inject
    IfCard(ViewContext viewContext, ExpressionField expEditor, EntityFactory entityFactory, DeleteNodeAction deleteNodeAction, ControlProgramTreeStructure controlProgramTreeStructure) {
        super(IfNode.class, viewContext);
        this.expEdit = expEditor;
        this.deleteNodeAction = deleteNodeAction;
        this.entityFactory = entityFactory;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.getViewContext().getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_if_condition");
    }

    @Override
    protected void updateCard() {
        IfNode node = (IfNode)this.getNode();
        this.expEdit.setNodeWithExpression((ExpressionNodeProperty)node);
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class);
        if (node.findElseNodeOrSuppressedElseNode() == null) {
            this.addRemoveElseButton.setText(textResource.addNode(commandNamesResource.Else()));
        } else {
            this.addRemoveElseButton.setText(textResource.removeNode(commandNamesResource.Else()));
        }
        this.checkConditionContinuouslyCheckBox.setSelected(node.isCheckConditionInSeperateThread());
    }

    private void initComponents() {
        JButton addElseIfButton = new JButton();
        JButton removeElseIfButton = new JButton();
        this.addRemoveElseButton = new JButton();
        JLabel jLabel1 = new JLabel();
        JPanel jPanel1 = new JPanel();
        ExpressionField expressionTextField = this.expEdit;
        JLabel jLabel4 = new JLabel();
        this.checkConditionContinuouslyCheckBox = new JCheckBox();
        JLabel jLabel2 = new JLabel();
        this.checkConditionContinuouslyHelpText = new JLabel();
        Box.Filler filler1 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(10, Short.MAX_VALUE));
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class);
        addElseIfButton.setName(ADD_ELSE_IF_BUTTON);
        addElseIfButton.setText(textResource.addNode(commandNamesResource.ElseIf()));
        addElseIfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IfCard.this.addElseIfButtonActionPerformed();
            }
        });
        removeElseIfButton.setText(textResource.removeNode(commandNamesResource.ElseIf()));
        removeElseIfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IfCard.this.removeElseIfButtonActionPerformed();
            }
        });
        this.addRemoveElseButton.setText(textResource.addNode(commandNamesResource.Else()));
        this.addRemoveElseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IfCard.this.addElseButtonActionPerformed();
            }
        });
        jLabel1.setText(HTML.html((String)HTML.h1((String)commandNamesResource.If())));
        expressionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((IfNode)IfCard.this.getNode()).textHasChanged();
            }
        });
        expressionTextField.setHorizontalAlignment(0);
        expressionTextField.setPreferredSize(new Dimension(300, 28));
        jLabel4.setText(commandNamesResource.If());
        this.checkConditionContinuouslyCheckBox.setText(textResource.checkExpressionContinuously());
        this.checkConditionContinuouslyCheckBox.setMaximumSize(new Dimension(450, 22));
        this.checkConditionContinuouslyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IfCard.this.checkConditionContinuouslyCheckBoxItemStateChanged(evt);
                IfCard.this.checkConditionContinuouslyHelpText.setVisible(!IfCard.this.checkConditionContinuouslyHelpText.isShowing());
            }
        });
        this.checkConditionContinuouslyHelpText.setVisible(this.checkConditionContinuouslyCheckBox.isSelected());
        this.checkConditionContinuouslyHelpText.setText(textResource.checkExpressionContinuouslyHelpText());
        jLabel2.setText(textResource.commandIfStatemen());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1, -1, 738, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.addRemoveElseButton, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(addElseIfButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(removeElseIfButton))).addGroup(layout.createSequentialGroup().addComponent(jLabel4).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)expressionTextField, -1, 706, Short.MAX_VALUE).addComponent(this.checkConditionContinuouslyCheckBox, -2, 454, -2).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.checkConditionContinuouslyHelpText, -1, 706, -2)).addGap(0, 0, Short.MAX_VALUE))).addComponent(jLabel2, -1, 738, Short.MAX_VALUE)).addGap(2, 2, 2).addComponent(filler1, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel4, -2, 31, -2).addComponent((Component)expressionTextField, -2, 32, -2))).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addComponent(filler1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkConditionContinuouslyCheckBox, -2, -1, -2).addComponent(this.checkConditionContinuouslyHelpText, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(addElseIfButton).addComponent(removeElseIfButton)).addGap(15, 15, 15).addComponent(this.addRemoveElseButton).addContainerGap()));
    }

    private void removeElseIfButtonActionPerformed() {
        if (((IfNode)this.getNode()).findFollowingElseIfNode() != null) {
            this.deleteNodeAction.execute(((IfNode)this.getNode()).findFollowingElseIfNode());
        }
    }

    private void addElseIfButtonActionPerformed() {
        IfNode node = (IfNode)this.getNode();
        IfNode elseIfNode = this.entityFactory.createElseIfNode();
        AbstractProgramNode parent = (AbstractProgramNode)node.getParent();
        int index = parent.getIndex((TreeNode)((Object)node)) + 1;
        ((ProgramRootNode)((Object)node.getRoot())).getProgramTreeModel().insertNodeInto((MutableTreeNode)((Object)elseIfNode), (MutableTreeNode)parent, index);
        this.controlProgramTreeStructure.makeChildrenVisible((TreeNode)((Object)elseIfNode));
    }

    private void addElseButtonActionPerformed() {
        IfNode node = (IfNode)this.getNode();
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class);
        if (node.findElseNodeOrSuppressedElseNode() == null) {
            IfNode aboveElseNode = node;
            while (aboveElseNode.findFollowingElseIfNode() != null) {
                aboveElseNode = aboveElseNode.findFollowingElseIfNode();
            }
            IfNode elseNode = this.entityFactory.createElseNode();
            AbstractProgramNode parent = (AbstractProgramNode)node.getParent();
            int index = parent.getIndex((TreeNode)((Object)aboveElseNode)) + 1;
            ((ProgramRootNode)((Object)node.getRoot())).getProgramTreeModel().insertNodeInto((MutableTreeNode)((Object)elseNode), (MutableTreeNode)parent, index);
            this.controlProgramTreeStructure.makeChildrenVisible((TreeNode)((Object)elseNode));
            this.addRemoveElseButton.setText(textResource.removeNode(commandNamesResource.Else()));
        } else {
            this.deleteNodeAction.execute(node.findElseNodeOrSuppressedElseNode());
            this.addRemoveElseButton.setText(textResource.addNode(commandNamesResource.Else()));
        }
    }

    private void checkConditionContinuouslyCheckBoxItemStateChanged(ItemEvent evt) {
        ((IfNode)this.getNode()).setCheckConditionInSeperateThread(evt.getStateChange() == 1);
    }
}

