/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import gui.commandpanels.LoopCard$AjcClosure1;
import gui.program.EntityFactory;
import gui.program.LoopNode;
import gui.program.validation.LoopNodeValidationStrategyProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class LoopCard
extends CommandPanel<LoopNode> {
    private final EntityFactory entityFactory;
    private final ExpressionField expressionsEditor;
    private volatile boolean updated = false;
    private JCheckBox checkConditionContinuouslyCheckBox;
    private JRadioButton selectExpression;
    private JRadioButton selectAlwaysLoop;
    private JRadioButton selectCounter;
    private NumberField loopCount;
    private JLabel loopVariableName;
    private LoopNodeValidationStrategyProvider loopNodeValidationStrategyProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    LoopCard(ViewContext view, ExpressionField expressionsEditor, EntityFactory entityFactory, LoopNodeValidationStrategyProvider loopNodeValidationStrategyProvider) {
        super(LoopNode.class, view);
        this.expressionsEditor = expressionsEditor;
        this.entityFactory = entityFactory;
        this.loopNodeValidationStrategyProvider = loopNodeValidationStrategyProvider;
        try {
            this.initComponents(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.getViewContext().getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_loop");
    }

    @Override
    protected void updateCard() {
        LoopNode node = (LoopNode)this.getNode();
        this.removeAll();
        this.initComponents(this.getViewContext());
        this.updated = false;
        this.expressionsEditor.setNodeWithExpression((ExpressionNodeProperty)node);
        this.loopCount.setValue((Object)node.getCount());
        this.initialSetVariable();
        this.loopVariableName.setText(node.getVariable().getName());
        switch (node.getType()) {
            case FOREVER: {
                this.selectAlwaysLoop.setSelected(true);
                this.checkConditionContinuouslyCheckBox.setEnabled(false);
                this.expressionsEditor.setBackground(Color.white);
                break;
            }
            case COUNTING: {
                this.selectCounter.setSelected(true);
                this.checkConditionContinuouslyCheckBox.setEnabled(false);
                this.expressionsEditor.setBackground(Color.white);
                break;
            }
            case WHILE: {
                this.selectExpression.setSelected(true);
                this.checkConditionContinuouslyCheckBox.setEnabled(true);
                this.expressionsEditor.setBackground(this.expressionsEditor.getExpression().isUndefined() ? DisplayMessageFactory.WARNING_COLOR : Color.WHITE);
            }
        }
        this.checkConditionContinuouslyCheckBox.setSelected(node.isCheckConditionInSeperateThread());
        this.updated = true;
    }

    @IgnoreProgramChanges
    void initialSetVariable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        LoopCard$AjcClosure1 loopCard$AjcClosure1 = new LoopCard$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(loopCard$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void initComponents(ViewContext view) {
        TextResource text = (TextResource)view.getTextResource(TextResource.class);
        CommandNamesResource command = (CommandNamesResource)view.getTextResource(CommandNamesResource.class);
        WidgetFactory factory = view.createWidgetFactory();
        ButtonGroup whileButtonGroup = new ButtonGroup();
        this.selectAlwaysLoop = factory.createRadioButton((Action)((Object)new AlwaysLoop(text)));
        this.selectCounter = factory.createRadioButton((Action)((Object)new CountLoop(text)));
        this.selectExpression = factory.createRadioButton((Action)((Object)new ExpressionLoop(text)));
        this.loopCount = factory.createNumberField(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LoopNode)LoopCard.this.getNode()).setCountAndType((Integer)LoopCard.this.loopCount.getValue());
            }
        });
        this.loopCount.setValueConverter((ValueConverter)ValueConverter.INTEGER_CONVERTER);
        this.loopCount.setMode(Mode.PositiveWholeNumbers);
        this.loopCount.setErrorValidationStrategy(new ValidationStrategy[]{this.loopNodeValidationStrategyProvider.getLoopCountValidator()});
        this.loopCount.setRestrictionsText(text.minimumAndMaximumValue(0L, this.loopNodeValidationStrategyProvider.getLoopCountMax(), ""));
        this.loopCount.setUnitWidth(150);
        this.loopVariableName = new JLabel();
        this.checkConditionContinuouslyCheckBox = factory.createCheckBox(text.checkExpressionContinuously());
        int width = this.calculateIndentOfRadioButtton();
        view.createFormBuilder().headerLabel(command.Loop(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().spacer().end().description(text.commandLoop(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).spacer().end(3).component((JComponent)this.selectAlwaysLoop, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.selectCounter, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.indent(width, factory.createLabel(text.loopCount())), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(text.loopVariable(), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.indent(width, (Component)this.loopCount), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.loopVariableName, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.selectExpression, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.indent(width, (Component)this.expressionsEditor), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().end().component((JComponent)this.indent(width, this.checkConditionContinuouslyCheckBox), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().setOnPanel((JPanel)((Object)this));
        whileButtonGroup.add(this.selectAlwaysLoop);
        whileButtonGroup.add(this.selectCounter);
        whileButtonGroup.add(this.selectExpression);
        this.loopVariableName.setFont(this.loopVariableName.getFont().deriveFont(this.loopVariableName.getFont().getStyle() | 1, this.loopVariableName.getFont().getSize() + 1));
        this.loopVariableName.setText("loop_0");
        this.loopVariableName.setPreferredSize(new Dimension(120, 20));
        this.expressionsEditor.setHorizontalAlignment(0);
        this.expressionsEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((LoopNode)LoopCard.this.getNode()).textHasChanged();
                LoopCard.this.selectExpression.setSelected(true);
            }
        });
        this.checkConditionContinuouslyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LoopCard.this.checkConditionContinuouslyCheckBoxItemStateChanged(evt);
            }
        });
    }

    private int calculateIndentOfRadioButtton() {
        JRadioButton button = new JRadioButton();
        int width = button.getIcon().getIconWidth();
        width += button.getIconTextGap();
        width += button.getMargin().left;
        return width += button.getMargin().right;
    }

    private JPanel indent(int indent, Component subcomponent) {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(0, indent, 0, 0));
        panel.setLayout(new GridLayout(0, 1));
        panel.add(subcomponent);
        return panel;
    }

    private void checkConditionContinuouslyCheckBoxItemStateChanged(ItemEvent evt) {
        ((LoopNode)this.getNode()).setCheckConditionInSeperateThread(evt.getStateChange() == 1);
    }

    static {
        LoopCard.ajc$preClinit();
    }

    static final /* synthetic */ void initialSetVariable_aroundBody0(LoopCard ajc$this, JoinPoint joinPoint) {
        if (((LoopNode)ajc$this.getNode()).getVariable() == null) {
            ((LoopNode)ajc$this.getNode()).setVariable(ajc$this.entityFactory.createLoopVariable());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LoopCard.java", LoopCard.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "initialSetVariable", "gui.commandpanels.LoopCard", "", "", "", "void"), 112);
    }

    private class AlwaysLoop
    extends AbstractActionDefinition {
        public AlwaysLoop(TextResource text) {
            this.putValue("Name", text.loopAlways());
        }

        public void actionPerformed(ActionEvent e) {
            if (LoopCard.this.updated && LoopCard.this.selectAlwaysLoop.isSelected()) {
                ((LoopNode)LoopCard.this.getNode()).setTypeAndCheckCondition(LoopNode.Type.FOREVER);
            }
        }
    }

    private class CountLoop
    extends AbstractActionDefinition {
        public CountLoop(TextResource text) {
            this.putValue("Name", HTML.html((String)text.loopForCount()));
        }

        public void actionPerformed(ActionEvent e) {
            if (LoopCard.this.updated && LoopCard.this.selectCounter.isSelected()) {
                ((LoopNode)LoopCard.this.getNode()).setTypeAndCheckCondition(LoopNode.Type.COUNTING);
            }
        }
    }

    private class ExpressionLoop
    extends AbstractActionDefinition {
        public ExpressionLoop(TextResource text) {
            this.putValue("Name", HTML.html((String)text.loopWhileTrue()));
        }

        public void actionPerformed(ActionEvent e) {
            if (LoopCard.this.updated && LoopCard.this.selectExpression.isSelected()) {
                LoopCard.this.checkConditionContinuouslyCheckBox.setEnabled(true);
                ((LoopNode)LoopCard.this.getNode()).setTypeAndCheckCondition(LoopNode.Type.WHILE);
            } else {
                LoopCard.this.checkConditionContinuouslyCheckBox.setEnabled(false);
            }
        }
    }
}

