/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputField;
import com.ur.swing.LabelProvider;
import com.ur.swing.PostProcess;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.Conjunction;
import com.ur.util.Predicate;
import com.ur.view.naming.UniqueByName;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.program.PopupNode;
import gui.swing.renderers.VariableComboBoxModel;
import gui.swing.renderers.VariableRenderingStrategy;
import gui.tools.LegacyURDialogCreator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PopupCard
extends CommandPanel<PopupNode> {
    public static final String MESSAGE_TYPE = "messageType.gui.commandpanels.PoupCard";
    public static final String WARNING_TYPE = "warningType.gui.commandpanels.PoupCard";
    public static final String ERROR_TYPE = "errorType.gui.commandpanels.PoupCard";
    public static final String INPUT_FIELD = "inputField.gui.commandpanels.PopupCard";
    public static final String HALT_ON_POPUP = "haltOnPopup.gui.commandpanels.PopupCard";
    private static final int MAX_MESSAGE_LENGTH = 255;
    private static final String TEXT_MSG_CARD = "TextMsgCard";
    private static final String VARIABLE_SELECT_CARD = "VariableSelectCard";
    private final VariableLookupService lookupService;
    private EnumButtonGroup popupTypeButtonGroup;
    private JCheckBox haltCheckBox;
    private JComboBox variableDropDown;
    private JComboBox inputTypeDropDown;
    private InputField popupMessageTextField;

    @Inject
    PopupCard(ViewContext viewContext, VariableLookupService lookupService) {
        super(PopupNode.class, viewContext);
        this.lookupService = lookupService;
        this.initComponents();
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_popup");
    }

    @Override
    protected void updateCard() {
        PopupNode node = (PopupNode)this.getNode();
        this.inputTypeDropDown.setSelectedItem((Object)node.getInputType());
        this.variableDropDown.setModel(this.makeVariableSelectorComboBox());
        this.popupMessageTextField.setText(node.getMessage());
        if (this.popupTypeButtonGroup.hasReference((Enum)node.getType())) {
            this.popupTypeButtonGroup.select((Enum)node.getType());
        }
        this.haltCheckBox.setSelected(node.isHaltProgram());
    }

    JCheckBox getHaltCheckBox() {
        return this.haltCheckBox;
    }

    JTextField getPopupMessageTextField() {
        return this.popupMessageTextField;
    }

    AbstractButton getMessageTypeRadioButton(MessageDialogType messageDialogType) {
        return this.popupTypeButtonGroup.get((Enum)messageDialogType);
    }

    JComboBox getVariableDropDown() {
        return this.variableDropDown;
    }

    private void initComponents() {
        ViewContext viewContext = this.getViewContext();
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        CommandNamesResource command = (CommandNamesResource)viewContext.getTextResource(CommandNamesResource.class);
        TextResource resource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.popupMessageTextField = widgetFactory.createInputField(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PopupNode)PopupCard.this.getNode()).setMessage(PopupCard.this.popupMessageTextField.getText());
            }
        });
        this.popupMessageTextField.setPostProcessor(new PostProcess(){

            public String transform(String original) {
                return original.replaceAll("\"", "'");
            }
        });
        this.popupMessageTextField.setErrorValidationStrategy(new ValidationStrategy[]{new AllowEmptyWithMaxSizeLimitOf(255)});
        this.popupMessageTextField.setHorizontalAlignment(0);
        this.popupMessageTextField.setName(INPUT_FIELD);
        this.popupMessageTextField.setFocusable(false);
        this.popupMessageTextField.setAllowEmpty(true);
        this.variableDropDown = widgetFactory.createComboBox();
        this.variableDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupCard.this.variableComboBoxActionPerformed();
            }
        });
        ComboBoxRenderer.bindRenderer((JComboBox)this.variableDropDown, (RenderingStrategy)new ProgramVariableRenderingStrategy());
        this.haltCheckBox = new JCheckBox(resource.haltProgramExecutionAtThisPopup());
        this.haltCheckBox.setName(HALT_ON_POPUP);
        this.haltCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((PopupNode)PopupCard.this.getNode()).setHaltProgram(PopupCard.this.haltCheckBox.isSelected());
            }
        });
        this.popupTypeButtonGroup = new EnumButtonGroup(MessageDialogType.class);
        JRadioButton messageButton = new JRadioButton(resource.Message());
        messageButton.setName(MESSAGE_TYPE);
        messageButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((PopupNode)PopupCard.this.getNode()).setType(MessageDialogType.MESSAGE);
            }
        });
        this.popupTypeButtonGroup.add((Enum)MessageDialogType.MESSAGE, (AbstractButton)messageButton);
        JRadioButton warningButton = new JRadioButton(resource.Warning());
        warningButton.setName(WARNING_TYPE);
        warningButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((PopupNode)PopupCard.this.getNode()).setType(MessageDialogType.WARNING);
            }
        });
        this.popupTypeButtonGroup.add((Enum)MessageDialogType.WARNING, (AbstractButton)warningButton);
        JRadioButton errorButton = new JRadioButton(resource.Error());
        errorButton.setName(ERROR_TYPE);
        errorButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ((PopupNode)PopupCard.this.getNode()).setType(MessageDialogType.ERROR);
            }
        });
        this.popupTypeButtonGroup.add((Enum)MessageDialogType.ERROR, (AbstractButton)errorButton);
        this.inputTypeDropDown = widgetFactory.createComboBox((LabelProvider)new InputOptionsProvider(resource), (Object[])PopupNode.InputType.values());
        JPanel cards = this.createInputCards(viewContext, resource, this.inputTypeDropDown);
        JPanel headerPanel = viewContext.createFormBuilder().headerLabel(command.Popup(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).component((JComponent)this.inputTypeDropDown, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)cards, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_ROWS, FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end(5).getPanel();
        JPanel center = viewContext.createFormBuilder().label(resource.popupType(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().component((JComponent)messageButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().component((JComponent)warningButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().component((JComponent)errorButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end(5).getPanel();
        JPanel footer = viewContext.createFormBuilder().component((JComponent)this.haltCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).getPanel();
        this.setLayout(new BorderLayout(0, 0));
        this.add(headerPanel, "North");
        this.add(center, "Center");
        this.add(footer, "South");
    }

    private JPanel createInputCards(ViewContext context, TextResource resource, final JComboBox inputTypeDropDown) {
        JButton previewPopup = new JButton(resource.previewPopup());
        previewPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupCard.this.previewPopupButtonActionPerformed();
            }
        });
        JPanel textPanel = context.createFormBuilder().description(resource.commandPopup(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).component((JComponent)this.popupMessageTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().buttonRow((JComponent)previewPopup, new FormBuilder.PanelConstraints[0]).end().getRow();
        JPanel variablePanel = context.createFormBuilder().description(resource.commandVariablePopup(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).component((JComponent)this.variableDropDown, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getRow();
        CardLayout cardLayout = new CardLayout();
        final JPanel cards = new JPanel(cardLayout);
        cards.setBorder(BorderFactory.createEmptyBorder());
        cards.add((Component)textPanel, TEXT_MSG_CARD);
        cards.add((Component)variablePanel, VARIABLE_SELECT_CARD);
        inputTypeDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardLayout cardLayout = (CardLayout)cards.getLayout();
                PopupNode.InputType selectedItem = (PopupNode.InputType)((Object)inputTypeDropDown.getSelectedItem());
                ((PopupNode)PopupCard.this.getNode()).setInputType(selectedItem);
                if (selectedItem == PopupNode.InputType.TEXT) {
                    cardLayout.show(cards, PopupCard.TEXT_MSG_CARD);
                } else {
                    cardLayout.show(cards, PopupCard.VARIABLE_SELECT_CARD);
                }
            }
        });
        return cards;
    }

    private void variableComboBoxActionPerformed() {
        Object selectedItem = this.variableDropDown.getSelectedItem();
        if (selectedItem instanceof Variable) {
            ((PopupNode)this.getNode()).setVariable((Variable)selectedItem);
        } else {
            ((PopupNode)this.getNode()).setVariable(null);
        }
    }

    private void previewPopupButtonActionPerformed() {
        String title;
        PopupNode node = (PopupNode)this.getNode();
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        switch (node.getType()) {
            case MESSAGE: {
                title = textResource.Message();
                break;
            }
            case WARNING: {
                title = textResource.Warning();
                break;
            }
            case ERROR: {
                title = textResource.Error();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown message type: " + node.getType());
            }
        }
        LegacyURDialogCreator.showTitledMessageDialog(title, node.getMessage(), node.getType());
    }

    private VariableComboBoxModel makeVariableSelectorComboBox() {
        PopupNode node = (PopupNode)this.getNode();
        Collection<NamedEntity> variables = this.lookupService.getAllNamedEntities();
        VariableComboBoxModel comboBoxModel = new VariableComboBoxModel();
        comboBoxModel.addElement(((TextResource)this.getViewContext().getTextResource(TextResource.class)).placeholderVariable());
        comboBoxModel.addVariables(CollectionUtils.filter(variables, (Predicate)new Conjunction(new Predicate[]{new UniqueByName(), new Predicate.ByType(Variable.class)})));
        if (node.getVariable() == null) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        } else {
            comboBoxModel.selectVariable(node.getVariable());
        }
        return comboBoxModel;
    }

    static class AllowEmptyWithMaxSizeLimitOf
    implements ValidationStrategy {
        final ValidationStrategy maxLength;

        public AllowEmptyWithMaxSizeLimitOf(int maxMessageLength) {
            this.maxLength = ValidationFactory.getTextWidthLimitValidator((int)maxMessageLength);
        }

        public boolean isValid(String s) {
            return s.isEmpty() || this.maxLength.isValid(s);
        }

        public String getErrorMessage(String s) {
            return this.maxLength.getErrorMessage(s);
        }
    }

    public static class InputOptionsProvider
    implements LabelProvider<PopupNode.InputType> {
        private final TextResource resource;

        public InputOptionsProvider(TextResource resource) {
            this.resource = resource;
        }

        public String getText(PopupNode.InputType value) {
            switch (value) {
                case TEXT: {
                    return this.resource.popupTextInput();
                }
                case VARIABLE: {
                    return this.resource.popupVariableInput();
                }
            }
            throw new IllegalStateException("Not a supported state '" + (Object)((Object)value) + "'");
        }
    }

    class ProgramVariableRenderingStrategy
    extends VariableRenderingStrategy {
        ProgramVariableRenderingStrategy() {
        }

        @Override
        public boolean hasError(Object value) {
            if (super.hasError(value)) {
                return true;
            }
            if (value instanceof Variable) {
                return ((PopupNode)PopupCard.this.getNode()).isVariableUndefined((Variable)value);
            }
            return false;
        }
    }
}

