/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.swing.ViewContext;
import com.ur.util.swing.HTML;
import com.ur.view.action.DeleteNodeAction;
import com.ur.view.program.CommandPanel;
import gui.polyscope.program.InsertNodeStrategy;
import gui.program.EntityFactory;
import gui.program.MainProgram;
import gui.program.ProgramRootNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class ProgramCard
extends CommandPanel<MainProgram> {
    public static final String INITIAL_VARS_CHECKBOX = "initialVarsCheckbox." + ProgramCard.class.getSimpleName();
    private final EntityFactory entityFactory;
    private final DeleteNodeAction deleteNodeAction;
    private final InsertNodeStrategy insertNodeStrategy;
    private JCheckBox addBeforeStartSequenceCheckBox;
    private JCheckBox loopForeverCheckbox;
    private JCheckBox setInitialVariableValuesCheckBox;

    @Inject
    protected ProgramCard(ViewContext viewContext, EntityFactory entityFactory, DeleteNodeAction deleteNodeAction) {
        super(MainProgram.class, viewContext);
        this.entityFactory = entityFactory;
        this.deleteNodeAction = deleteNodeAction;
        this.insertNodeStrategy = new InsertNodeStrategy.AfterPlacementStrategy(entityFactory, (TextResource)viewContext.getTextResource(TextResource.class));
        this.initComponents();
        this.setInitialVariableValuesCheckBox.setName(INITIAL_VARS_CHECKBOX);
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.getViewContext().getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_program");
    }

    @Override
    public void enter(Object o) {
        if (o instanceof ProgramRootNode) {
            ProgramRootNode rootNode = (ProgramRootNode)o;
            MainProgram mainProgram = rootNode.getMainProgram();
            mainProgram.setSelected();
            o = mainProgram;
        }
        super.enter(o);
    }

    @Override
    protected void updateCard() {
        this.loopForeverCheckbox.setSelected(!((MainProgram)this.getNode()).isRunOnlyOnce());
        ProgramRootNode programRootNode = ProgramRootNode.get((AbstractProgramNode)this.getNode());
        this.setInitialVariableValuesCheckBox.setSelected(programRootNode.hasInitVariables());
        this.addBeforeStartSequenceCheckBox.setSelected(programRootNode.hasBeforeStart());
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.addBeforeStartSequenceCheckBox = new JCheckBox();
        this.setInitialVariableValuesCheckBox = new JCheckBox();
        this.loopForeverCheckbox = new JCheckBox();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.setName("ProgramRootCard");
        this.setLayout(new BorderLayout());
        jPanel2.setName("ProgramRootCard");
        jPanel2.setLayout(new BorderLayout());
        jPanel1.setLayout(new BoxLayout(jPanel1, 3));
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class);
        this.addBeforeStartSequenceCheckBox.setText(textResource.addBeforeStartSequence());
        this.addBeforeStartSequenceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProgramCard.this.addBeforeStartSequenceCheckBoxItemStateChanged();
            }
        });
        this.addBeforeStartSequenceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgramCard.this.addBeforeStartSequenceCheckBoxActionPerformed();
            }
        });
        jPanel1.add(this.addBeforeStartSequenceCheckBox);
        this.setInitialVariableValuesCheckBox.setText(textResource.setInitialVariableValues());
        this.setInitialVariableValuesCheckBox.setName("setInitialVariableValues");
        this.setInitialVariableValuesCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProgramCard.this.setInitialVariableValuesCheckBoxItemStateChanged();
            }
        });
        jPanel1.add(this.setInitialVariableValuesCheckBox);
        this.loopForeverCheckbox.setText(textResource.programLoopsForever());
        this.loopForeverCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ProgramCard.this.loopForeverCheckboxItemStateChanged();
            }
        });
        jPanel1.add(this.loopForeverCheckbox);
        jPanel2.add((Component)jPanel1, "South");
        jPanel3.setLayout(new BorderLayout());
        jLabel3.setText(HTML.html((String)HTML.h1((String)commandNamesResource.Program())));
        jPanel3.add((Component)jLabel3, "North");
        jLabel2.setText(textResource.commandProgram());
        jPanel3.add((Component)jLabel2, "Center");
        jPanel2.add((Component)jPanel3, "North");
        this.add(jPanel2, "Center");
    }

    private void loopForeverCheckboxItemStateChanged() {
        ((MainProgram)this.getNode()).setRunOnlyOnce(!this.loopForeverCheckbox.isSelected());
    }

    private void setInitialVariableValuesCheckBoxItemStateChanged() {
        ProgramRootNode programRootNode = ProgramRootNode.get((AbstractProgramNode)this.getNode());
        boolean selected = this.setInitialVariableValuesCheckBox.isSelected();
        ((MainProgram)this.getNode()).setInitVarsEnabled(selected);
        if (selected == programRootNode.hasInitVariables()) {
            return;
        }
        if (selected) {
            this.insertNodeStrategy.insertChild(this.entityFactory.createInitVariablesNode(), (AbstractProgramNode)programRootNode.getFirstChild(), 0);
        } else {
            this.deleteNodeAction.execute((AbstractProgramNode)programRootNode.getFirstChild());
            programRootNode.getComponent(ProgramSelectionModel.class).setSelected((AbstractProgramNode)programRootNode.getMainProgram());
        }
    }

    private void addBeforeStartSequenceCheckBoxItemStateChanged() {
        MainProgram node = (MainProgram)this.getNode();
        ProgramRootNode programRootNode = ProgramRootNode.get(node);
        boolean selected = this.addBeforeStartSequenceCheckBox.isSelected();
        if (selected == programRootNode.hasBeforeStart()) {
            return;
        }
        if (selected) {
            this.insertNodeStrategy.insertChild(this.entityFactory.createBeforeStartNode(), node, programRootNode.getIndex((TreeNode)((Object)node)));
        } else {
            this.deleteNodeAction.execute(programRootNode.getBeforeStart());
            programRootNode.getComponent(ProgramSelectionModel.class).setSelected((AbstractProgramNode)programRootNode.getMainProgram());
        }
    }

    private void addBeforeStartSequenceCheckBoxActionPerformed() {
    }
}

