/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.move.legacy.MoveRequester;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvas.UpdateRobotGraphicsRunnable;
import com.ur.resources.ViewImageResource;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelContribution;
import gui.commandpanels.SafeHomeCard$1$AjcClosure1;
import gui.commandpanels.SafeHomeCard$2$AjcClosure1;
import gui.commandpanels.SafeHomeCard$3$AjcClosure1;
import gui.commandpanels.SafeHomeCard$4$AjcClosure1;
import gui.commandpanels.SafeHomeCard$5$AjcClosure1;
import gui.commandpanels.SafeHomeCard$AjcClosure1;
import gui.program.AdvancedPositionOptionType;
import gui.program.SafeHomeNode;
import gui.program.position.ImagePlaceHolder;
import gui.program.validation.CommonValidations;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.Format;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SafeHomeCard
extends CommandPanel<SafeHomeNode>
implements CommandPanelContribution {
    private static final Dimension ROBOT_3D_IMAGE_SIZE;
    private static final int TEXT_FIELD_COLUMNS = 3;
    private static final int RADIO_TEXT_WIDTH = 240;
    private static DecimalFormat speedFormat;
    private static final String SHOW_POSE = "DEFINED";
    private static final String UNDEFINED_POSE = "UNDEFINED";
    private final CommonValidations commonValidations;
    private WidgetFactory factory;
    private JLabel safetyLabel;
    private JLabel safeHomeOutputLabel;
    private JPanel syncPanel;
    private JPanel imagePlaceholder;
    private JRadioButton speedAccelerationRadioButton;
    private JRadioButton timeRadioButton;
    private NumberField accelerationField;
    private NumberField speedField;
    private NumberField timeField;
    private MoveRequester moveRequester;
    private RobotCanvas3DFactory robotCanvas3DFactory;
    private JButton moveHereButton;
    private boolean isUpdating = false;
    private RobotCanvas3D robotCanvas3D;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        SafeHomeCard.ajc$preClinit();
        ROBOT_3D_IMAGE_SIZE = new Dimension(180, 180);
        speedFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.#");
    }

    @Inject
    public SafeHomeCard(ViewContext viewContext, CommonValidations commonValidations, MoveRequester moveRequester, RobotCanvas3DFactory robotCanvas3DFactory) {
        super(SafeHomeNode.class, viewContext);
        this.commonValidations = commonValidations;
        this.moveRequester = moveRequester;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
        this.initComponents();
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_home");
    }

    @Override
    public CardPanel getCardPanel() {
        return this;
    }

    @Override
    public Class<? extends CardPanel> getCardPanelClass() {
        return SafeHomeCard.class;
    }

    private void initComponents() {
        ViewContext viewContext = this.getViewContext();
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.factory = viewContext.createWidgetFactory();
        this.safetyLabel = new JLabel(textResource.safeHomeSafetyConfiguredLongDesc());
        this.syncPanel = this.factory.createWarningMessagePanel(textResource.safeHomeOutOfSync());
        this.safeHomeOutputLabel = this.factory.createLabel("");
        this.safeHomeOutputLabel.setHorizontalAlignment(0);
        JLabel safeHomeLabel = this.factory.createLabel(textResource.safeHome());
        safeHomeLabel.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        JLabel outputsLabel = this.factory.createLabel(textResource.Outputs());
        outputsLabel.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        outputsLabel.setHorizontalAlignment(0);
        viewContext.createFormBuilder().headerLabel(((CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class)).Home(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().description(textResource.safeHomeNodeDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.createTopPanel(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(10).end(2).component(this.factory.createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().description(textResource.safeHomeOutputDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().label(safeHomeLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(outputsLabel, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.safetyLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.safeHomeOutputLabel, new FormBuilder.PanelConstraints[0]).end(2).component((JComponent)this.syncPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().setOnPanel((JPanel)((Object)this));
        this.selectionChanged();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JPanel createTopPanel() {
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this.timeField = this.factory.createNumberField(new ActionListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @CompoundProgramChange
            public void actionPerformed(ActionEvent evt) {
                ActionEvent actionEvent = evt;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
                Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
                SafeHomeCard$1$AjcClosure1 safeHomeCard$1$AjcClosure1 = new SafeHomeCard$1$AjcClosure1(objectArray);
                ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(safeHomeCard$1$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ void actionPerformed_aroundBody0(1 ajc$this, ActionEvent evt, JoinPoint joinPoint) {
                if (!ajc$this.SafeHomeCard.this.isUpdating) {
                    double value = PrimitiveUtils.parseDouble((String)ajc$this.SafeHomeCard.this.timeField.getText());
                    ((SafeHomeNode)ajc$this.SafeHomeCard.this.getNode()).setMotionTime(value);
                }
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SafeHomeCard.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "gui.commandpanels.SafeHomeCard$1", "java.awt.event.ActionEvent", "evt", "", "void"), 156);
            }
        });
        this.timeField.setColumns(3);
        this.timeField.setUnitWidth(58);
        this.timeField.setUnit(Units.getText().unitS());
        this.timeField.setMode(Mode.PositiveNumbers);
        this.timeField.setErrorValidationStrategy(new ValidationStrategy[]{this.commonValidations.getNextMotionTimeValidator()});
        this.timeField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        this.speedField = this.factory.createNumberField(new ActionListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @CompoundProgramChange
            public void actionPerformed(ActionEvent evt) {
                ActionEvent actionEvent = evt;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
                Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
                SafeHomeCard$2$AjcClosure1 safeHomeCard$2$AjcClosure1 = new SafeHomeCard$2$AjcClosure1(objectArray);
                ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(safeHomeCard$2$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                2.ajc$preClinit();
            }

            static final /* synthetic */ void actionPerformed_aroundBody0(2 ajc$this, ActionEvent evt, JoinPoint joinPoint) {
                if (!ajc$this.SafeHomeCard.this.isUpdating) {
                    ((SafeHomeNode)ajc$this.SafeHomeCard.this.getNode()).setSpeed(Math.toRadians(PrimitiveUtils.parseDouble((String)ajc$this.SafeHomeCard.this.speedField.getText())));
                }
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SafeHomeCard.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "gui.commandpanels.SafeHomeCard$2", "java.awt.event.ActionEvent", "evt", "", "void"), 174);
            }
        });
        this.speedField.setColumns(3);
        this.speedField.setUnitWidth(58);
        this.speedField.setErrorValidationStrategy(new ValidationStrategy[]{this.commonValidations.getJointSpeedLimitValidator()});
        this.speedField.setMode(Mode.PositiveNumbers);
        this.speedField.setUnit(Units.getText().unitDegS());
        this.speedField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        this.accelerationField = this.factory.createNumberField(new ActionListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @CompoundProgramChange
            public void actionPerformed(ActionEvent evt) {
                ActionEvent actionEvent = evt;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
                Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
                SafeHomeCard$3$AjcClosure1 safeHomeCard$3$AjcClosure1 = new SafeHomeCard$3$AjcClosure1(objectArray);
                ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(safeHomeCard$3$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                3.ajc$preClinit();
            }

            static final /* synthetic */ void actionPerformed_aroundBody0(3 ajc$this, ActionEvent evt, JoinPoint joinPoint) {
                ajc$this.SafeHomeCard.this.accelerationFieldActionPerformed();
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SafeHomeCard.java", 3.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "gui.commandpanels.SafeHomeCard$3", "java.awt.event.ActionEvent", "evt", "", "void"), 191);
            }
        });
        this.accelerationField.setColumns(3);
        this.accelerationField.setUnitWidth(58);
        this.accelerationField.setErrorValidationStrategy(new ValidationStrategy[]{this.commonValidations.getJointAccelerationLimitValidator()});
        this.accelerationField.setMode(Mode.PositiveNumbers);
        this.accelerationField.setUnit(Units.getText().unitDegS2());
        this.accelerationField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        this.timeRadioButton = new JRadioButton(textResource.time());
        this.timeRadioButton.setMaximumSize(new Dimension(240, 250));
        this.timeRadioButton.setPreferredSize(new Dimension(240, 250));
        this.speedAccelerationRadioButton = new JRadioButton(textResource.jointSpeed());
        this.speedAccelerationRadioButton.setMaximumSize(new Dimension(240, 250));
        this.speedAccelerationRadioButton.setPreferredSize(new Dimension(240, 250));
        JLabel accelerationLabel = new JLabel(textResource.jointAcceleration());
        accelerationLabel.setBorder(BorderFactory.createEmptyBorder(0, 36, 0, 0));
        accelerationLabel.setMaximumSize(new Dimension(240, 250));
        accelerationLabel.setPreferredSize(new Dimension(240, 250));
        this.moveHereButton = new JButton(textResource.moveRobotHere());
        Dimension moveButtonSize = new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 40);
        this.moveHereButton.setPreferredSize(moveButtonSize);
        this.moveHereButton.setMinimumSize(moveButtonSize);
        this.moveHereButton.addActionListener(actionEvent -> this.moveRequester.moveTo(this.flipManager, ((SafeHomeNode)this.getNode()).getJointPositionVector()));
        JCheckBox useJointAnglesCheckBox = this.factory.createCheckBox(textResource.useJointAngles());
        useJointAnglesCheckBox.setSelected(true);
        useJointAnglesCheckBox.setEnabled(false);
        JLabel movejLabel = this.factory.createLabel(((CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class)).MoveJ());
        movejLabel.setFont(this.getViewContext().getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        JPanel radioButtonPanel = this.getViewContext().createFormBuilder().label(movejLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().component((JComponent)this.speedAccelerationRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.speedField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)accelerationLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.accelerationField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.timeRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.timeField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(4).component((JComponent)useJointAnglesCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).getPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.timeRadioButton);
        this.timeRadioButton.addItemListener(new ItemListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @CompoundProgramChange
            public void itemStateChanged(ItemEvent evt) {
                ItemEvent itemEvent = evt;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)itemEvent);
                Object[] objectArray = new Object[]{this, itemEvent, joinPoint};
                SafeHomeCard$4$AjcClosure1 safeHomeCard$4$AjcClosure1 = new SafeHomeCard$4$AjcClosure1(objectArray);
                ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(safeHomeCard$4$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                4.ajc$preClinit();
            }

            static final /* synthetic */ void itemStateChanged_aroundBody0(4 ajc$this, ItemEvent evt, JoinPoint joinPoint) {
                if (evt.getStateChange() == 1 && !ajc$this.SafeHomeCard.this.isUpdating) {
                    ((SafeHomeNode)ajc$this.SafeHomeCard.this.getNode()).setAdvancedPositionOptionType(AdvancedPositionOptionType.TIME);
                    ajc$this.SafeHomeCard.this.selectionChanged();
                }
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SafeHomeCard.java", 4.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "itemStateChanged", "gui.commandpanels.SafeHomeCard$4", "java.awt.event.ItemEvent", "evt", "", "void"), 242);
            }
        });
        buttonGroup.add(this.speedAccelerationRadioButton);
        this.speedAccelerationRadioButton.addItemListener(new ItemListener(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            @Override
            @CompoundProgramChange
            public void itemStateChanged(ItemEvent evt) {
                ItemEvent itemEvent = evt;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)itemEvent);
                Object[] objectArray = new Object[]{this, itemEvent, joinPoint};
                SafeHomeCard$5$AjcClosure1 safeHomeCard$5$AjcClosure1 = new SafeHomeCard$5$AjcClosure1(objectArray);
                ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(safeHomeCard$5$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                5.ajc$preClinit();
            }

            static final /* synthetic */ void itemStateChanged_aroundBody0(5 ajc$this, ItemEvent evt, JoinPoint joinPoint) {
                if (evt.getStateChange() == 1 && !ajc$this.SafeHomeCard.this.isUpdating) {
                    ((SafeHomeNode)ajc$this.SafeHomeCard.this.getNode()).setAdvancedPositionOptionType(AdvancedPositionOptionType.SPEED_AND_ACCELERATION);
                    ajc$this.SafeHomeCard.this.selectionChanged();
                }
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SafeHomeCard.java", 5.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "itemStateChanged", "gui.commandpanels.SafeHomeCard$5", "java.awt.event.ItemEvent", "evt", "", "void"), 255);
            }
        });
        topPanel.add(radioButtonPanel);
        topPanel.add(Box.createHorizontalStrut(20));
        topPanel.add(this.createRobotPanel());
        topPanel.add(Box.createHorizontalStrut(50));
        return topPanel;
    }

    private JPanel createRobotPanel() {
        this.robotCanvas3D = this.robotCanvas3DFactory.buildPositionRobot();
        this.robotCanvas3D.setDebugName("Safe Home Card 3D Canvas");
        this.robotCanvas3D.setVisible(false);
        this.robotCanvas3D.getComponent().setPreferredSize(ROBOT_3D_IMAGE_SIZE);
        this.robotCanvas3D.getComponent().setMaximumSize(ROBOT_3D_IMAGE_SIZE);
        Icon unreachableInfoIcon = ViewImageResource.metalQuestion();
        int spacerWidth = 2;
        int rightSpacerWidth = unreachableInfoIcon.getIconWidth() + spacerWidth;
        this.imagePlaceholder = new JPanel(new CardLayout());
        this.imagePlaceholder.setBorder(BorderFactory.createLineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR, 3));
        this.imagePlaceholder.setPreferredSize(ROBOT_3D_IMAGE_SIZE);
        this.imagePlaceholder.setMaximumSize(ROBOT_3D_IMAGE_SIZE);
        this.imagePlaceholder.add((Component)new ImagePlaceHolder(true, false, this.getViewContext(), ROBOT_3D_IMAGE_SIZE), UNDEFINED_POSE);
        this.imagePlaceholder.add(this.robotCanvas3D.getComponent(), SHOW_POSE);
        JPanel moveButtonPanel = new JPanel();
        moveButtonPanel.setLayout(new BorderLayout());
        moveButtonPanel.add((Component)this.moveHereButton, "West");
        moveButtonPanel.setMaximumSize(new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 40));
        moveButtonPanel.setMinimumSize(new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 40));
        moveButtonPanel.setPreferredSize(new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 40));
        JPanel moveButtonSpacer = new JPanel();
        moveButtonSpacer.setSize(rightSpacerWidth, 40);
        moveButtonPanel.add((Component)moveButtonSpacer, "East");
        JPanel posePanel = new JPanel();
        posePanel.setLayout(new BorderLayout());
        posePanel.add((Component)this.imagePlaceholder, "Center");
        JPanel robotPanel = new JPanel(new BorderLayout(10, 10));
        robotPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        robotPanel.setMaximumSize(new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 250));
        robotPanel.setMinimumSize(new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 250));
        robotPanel.setPreferredSize(new Dimension(SafeHomeCard.ROBOT_3D_IMAGE_SIZE.width, 250));
        robotPanel.add((Component)posePanel, "Center");
        robotPanel.add((Component)moveButtonPanel, "South");
        return robotPanel;
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        this.robotCanvas3D.setVisible(!((SafeHomeNode)this.getNode()).isUndefined());
        if (this.robotCanvas3D.getComponent().isVisible()) {
            this.robotCanvas3D.addQueue((Runnable)new UpdateRobotGraphicsRunnable(this.robotCanvas3D, ((SafeHomeNode)this.getNode()).getActualJointPositionVector()));
        }
    }

    public Object exit() {
        CardLayoutUtil.flipToCard((JPanel)this.imagePlaceholder, (String)UNDEFINED_POSE);
        this.robotCanvas3D.setVisible(false);
        return super.exit();
    }

    NumberField getAccelerationField() {
        return this.accelerationField;
    }

    NumberField getSpeedField() {
        return this.speedField;
    }

    NumberField getTimeField() {
        return this.timeField;
    }

    JLabel getSafeHomeOutputLabel() {
        return this.safeHomeOutputLabel;
    }

    public void setFlipManager(FlipManager flipManager) {
        this.flipManager = flipManager;
    }

    private void selectionChanged() {
        if (this.speedAccelerationRadioButton.isSelected()) {
            this.speedField.setEnabled(true);
            this.accelerationField.setEnabled(true);
            this.timeField.setEnabled(false);
        } else {
            this.speedField.setEnabled(false);
            this.accelerationField.setEnabled(false);
            this.timeField.setEnabled(true);
        }
    }

    private void setSafeHomeOutputLabel() {
        SafeHomeNode node = (SafeHomeNode)this.getNode();
        if (node.isSafeHomeAssignedToOutputs()) {
            String configOutDefaultName = "config_out";
            this.safeHomeOutputLabel.setText(String.valueOf(configOutDefaultName) + "[" + node.getSafeHomeOutputs()[0] + "], " + configOutDefaultName + "[" + node.getSafeHomeOutputs()[1] + "]");
        } else {
            this.safeHomeOutputLabel.setText(((TextResource)this.getViewContext().getTextResource(TextResource.class)).safeHomeOutputNotAssigned());
        }
    }

    @Override
    protected void updateCard() {
        this.isUpdating = true;
        SafeHomeNode node = (SafeHomeNode)this.getNode();
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        this.syncPanel.setVisible(node.isSafetyEnabled() && !node.isSyncedToSafety());
        CardLayoutUtil.flipToCard((JPanel)this.imagePlaceholder, (String)(node.isUndefined() ? UNDEFINED_POSE : SHOW_POSE));
        this.safetyLabel.setText(node.isSafetyEnabled() ? textResource.safeHomeSafetyConfiguredLongDesc() : textResource.safeHomeNotConfigured());
        this.setSafeHomeOutputLabel();
        if (node.getAdvancedPositionOptionType() == AdvancedPositionOptionType.TIME) {
            this.timeRadioButton.setSelected(true);
        } else {
            this.speedAccelerationRadioButton.setSelected(true);
        }
        this.speedField.setText(speedFormat.format(Math.toDegrees(node.getSpeed())));
        this.accelerationField.setText(speedFormat.format(Math.toDegrees(node.getAcceleration())));
        this.timeField.setText("" + node.getMotionTime());
        this.moveHereButton.setEnabled(!node.isUndefined());
        this.selectionChanged();
        this.isUpdating = false;
    }

    @CompoundProgramChange
    private void accelerationFieldActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SafeHomeCard$AjcClosure1 safeHomeCard$AjcClosure1 = new SafeHomeCard$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(safeHomeCard$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void accelerationFieldActionPerformed_aroundBody0(SafeHomeCard ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.isUpdating) {
            ((SafeHomeNode)ajc$this.getNode()).setAcceleration(Math.toRadians(PrimitiveUtils.parseDouble((String)ajc$this.accelerationField.getText())));
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SafeHomeCard.java", SafeHomeCard.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "accelerationFieldActionPerformed", "gui.commandpanels.SafeHomeCard", "", "", "", "void"), 407);
    }
}

