/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.ExpressionValidator;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import gui.controllerinterface.RawScriptExpressionValidatorImpl;
import gui.main.OnScreenFileEditor;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.program.ScriptNode;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.URFileUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.File;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ScriptCard
extends CommandPanel<ScriptNode> {
    public static final String KEYBOARD = "keyboardButton.ScriptCard";
    public static final String EXPRESSION_EDITOR = "expressionEditorButton." + ScriptCard.class.getSimpleName();
    private final ExpressionField expEditTextField;
    private FileContainer fileContainer;
    private JButton clearButton;
    private JButton editButton;
    private JTextField fileNameTextField;
    private JButton saveButton;
    private JPanel scriptCodeTypePanel;
    private JTextArea scriptTextArea;
    private JComboBox typeComboBox;

    @Inject
    ScriptCard(ViewContext viewContext, ExpressionField expEditor) {
        super(ScriptNode.class, viewContext);
        this.expEditTextField = expEditor;
        this.expEditTextField.setExpressionValidator((ExpressionValidator)new RawScriptExpressionValidatorImpl());
        this.initComponents();
        new URFingerDragScrollMouseListener((Component)this.scriptTextArea);
        this.assignHelpIds();
    }

    public static void setComboBoxWidth(JComboBox cBox, String[] strings) {
        int maxWidth = 0;
        String maxVal = "";
        Font font = cBox.getFont();
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        int i = 0;
        while (i < strings.length) {
            int textWidth = (int)Math.ceil(font.getStringBounds(strings[i], frc).getWidth());
            if (textWidth > maxWidth) {
                maxWidth = textWidth;
                maxVal = strings[i];
            }
            ++i;
        }
        cBox.setPrototypeDisplayValue(String.valueOf(maxVal) + " ");
    }

    private void assignHelpIds() {
        this.getViewContext().getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_script");
    }

    public Object exit() {
        if (((ScriptNode)this.getNode()).isLoadedFileContentChanged()) {
            this.saveChangesToFile();
        }
        return super.exit();
    }

    private void saveChangesToFile() {
        ScriptNode node = (ScriptNode)this.getNode();
        if (node != null && node.getFile() != null) {
            try {
                URFileUtils.backupFile(node.getFile(), "bak");
            }
            catch (Exception exception) {
                Log.error((String)("Was not able to create backup file for file: " + node.getFile().getAbsolutePath()));
            }
            boolean didSave = node.saveChangesToFile();
            if (!didSave) {
                ProgramRootNode programRootNode;
                if (node.getFile() != null) {
                    String file = node.getFile().getAbsolutePath();
                    LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().unableToSaveScriptFile(file));
                }
                if ((programRootNode = ProgramRootNode.get(node)) != null) {
                    FileManagementProgramComponent component = ProgramRootNode.get(node).getComponent(FileManagementProgramComponent.class);
                    String fileDirectory = component.getProgramDirectory();
                    File otherFile = new File(String.valueOf(fileDirectory) + File.separator + node.getFile().getName());
                    if (otherFile.exists()) {
                        otherFile = new File(otherFile.getAbsoluteFile() + "_bak");
                    }
                    node.setFile(otherFile);
                    node.saveChangesToFile();
                }
            }
        }
    }

    @Override
    protected void updateCard() {
        ScriptNode node = (ScriptNode)this.getNode();
        if (this.fileContainer != null && (this.fileContainer.getAction().equals((Object)FileContainer.Action.Open) || this.fileContainer.getAction().equals((Object)FileContainer.Action.SaveAs))) {
            node.setAndReadFile(this.fileContainer.getFile());
            node.textHasChanged();
            this.fileContainer = null;
        } else {
            this.expEditTextField.setNodeWithExpression((ExpressionNodeProperty)node);
        }
        if (node.getType() == ScriptNode.Type.LINE_TYPE) {
            this.typeComboBox.setSelectedIndex(0);
            CardLayout cl = (CardLayout)this.scriptCodeTypePanel.getLayout();
            cl.show(this.scriptCodeTypePanel, "lineCard");
        } else {
            TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
            this.typeComboBox.setSelectedIndex(1);
            CardLayout cl = (CardLayout)this.scriptCodeTypePanel.getLayout();
            cl.show(this.scriptCodeTypePanel, "fileCard");
            if (node.getFile() == null) {
                this.fileNameTextField.setText(textResource.noFileSelected());
                this.scriptTextArea.setText("");
                this.editButton.setText(textResource.Edit());
                this.scriptTextArea.setEditable(false);
                this.clearButton.setEnabled(false);
            } else {
                this.fileNameTextField.setText(node.getFile().getName());
                this.scriptTextArea.setText(node.getLoadedFileContents());
                this.editButton.setText(textResource.Edit());
                this.scriptTextArea.setEditable(true);
                this.clearButton.setEnabled(true);
            }
            this.saveButton.setEnabled(node.isLoadedFileContentChanged());
        }
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.scriptCodeTypePanel = new JPanel();
        JPanel linePanel = new JPanel();
        ExpressionField expressionTextField = this.expEditTextField;
        JLabel jLabel3 = new JLabel();
        JPanel filePanel = new JPanel();
        this.fileNameTextField = new JTextField();
        this.editButton = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.scriptTextArea = new JTextArea();
        JLabel jLabel2 = new JLabel();
        this.clearButton = new JButton();
        this.saveButton = new JButton();
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        jLabel1.setText(HTML.html((String)HTML.h1((String)((CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class)).scriptCode())));
        String scriptLine = textResource.scriptLine();
        String scriptFile = textResource.scriptFile();
        String[] scriptChoices = new String[]{scriptLine, scriptFile};
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(scriptChoices));
        ScriptCard.setComboBoxWidth(this.typeComboBox, scriptChoices);
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ScriptCard.this.typeComboBoxItemStateChanged();
            }
        });
        this.scriptCodeTypePanel.setLayout(new CardLayout());
        expressionTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ScriptNode)ScriptCard.this.getNode()).textHasChanged();
            }
        });
        expressionTextField.setHorizontalAlignment(0);
        expressionTextField.setPreferredSize(new Dimension(300, 28));
        jLabel3.setText(textResource.commandScript());
        GroupLayout linePanelLayout = new GroupLayout(linePanel);
        linePanel.setLayout(linePanelLayout);
        linePanelLayout.setHorizontalGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 718, Short.MAX_VALUE).addGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addContainerGap().addGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)expressionTextField, GroupLayout.Alignment.LEADING, -1, 694, Short.MAX_VALUE).addComponent(jLabel3, -1, 689, Short.MAX_VALUE)).addContainerGap())));
        linePanelLayout.setVerticalGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 311, Short.MAX_VALUE).addGroup(linePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(linePanelLayout.createSequentialGroup().addContainerGap().addComponent(jLabel3).addGap(35, 35, 35).addComponent((Component)expressionTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addContainerGap(180, Short.MAX_VALUE))));
        this.scriptCodeTypePanel.add((Component)linePanel, "lineCard");
        this.fileNameTextField.setEditable(false);
        this.fileNameTextField.setBackground(this.getBackground());
        this.fileNameTextField.setText(textResource.noFileSelected());
        this.editButton.setText(textResource.Edit());
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptCard.this.editButtonActionPerformed();
            }
        });
        this.scriptTextArea.setColumns(20);
        this.scriptTextArea.setRows(5);
        this.scriptTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ScriptCard.this.scriptTextAreaFocusLost();
            }
        });
        this.scriptTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ScriptCard.this.scriptTextAreaKeyTyped();
            }
        });
        jScrollPane1.setViewportView(this.scriptTextArea);
        jLabel2.setText(textResource.commandScriptLoad());
        this.clearButton.setText(textResource.Clear());
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptCard.this.clearButtonActionPerformed();
            }
        });
        this.saveButton.setText(textResource.Save());
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptCard.this.saveButtonActionPerformed();
            }
        });
        GroupLayout filePanelLayout = new GroupLayout(filePanel);
        filePanel.setLayout(filePanelLayout);
        filePanelLayout.setHorizontalGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filePanelLayout.createSequentialGroup().addContainerGap().addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filePanelLayout.createSequentialGroup().addComponent(jScrollPane1, -1, 580, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearButton, -1, 108, Short.MAX_VALUE).addComponent(this.editButton, GroupLayout.Alignment.TRAILING, -1, 105, Short.MAX_VALUE).addComponent(this.saveButton, GroupLayout.Alignment.TRAILING, -1, 105, Short.MAX_VALUE))).addComponent(jLabel2).addComponent(this.fileNameTextField, -1, 689, Short.MAX_VALUE)).addContainerGap()));
        filePanelLayout.setVerticalGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, filePanelLayout.createSequentialGroup().addContainerGap().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNameTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 231, Short.MAX_VALUE).addGroup(filePanelLayout.createSequentialGroup().addComponent(this.editButton).addGap(18, 18, 18).addComponent(this.saveButton).addGap(18, 18, 18).addComponent(this.clearButton))).addContainerGap()));
        this.scriptCodeTypePanel.add((Component)filePanel, "fileCard");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1, -1, 643, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, -2, -1, -2).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scriptCodeTypePanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.typeComboBox, -2, -1, -2)).addContainerGap(344, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.scriptCodeTypePanel, -1, -1, Short.MAX_VALUE).addContainerGap())));
    }

    private void typeComboBoxItemStateChanged() {
        ScriptNode.Type newType = this.typeComboBox.getSelectedIndex() == 0 ? ScriptNode.Type.LINE_TYPE : ScriptNode.Type.FILE_TYPE;
        ScriptNode node = (ScriptNode)this.getNode();
        if (node.getType() != newType) {
            node.setType(newType);
            this.updateCard();
        }
    }

    private void editButtonActionPerformed() {
        ScriptNode node = (ScriptNode)this.getNode();
        this.fileContainer = new FileContainer();
        this.fileContainer.setAction(node.getFile() == null ? FileContainer.Action.New : FileContainer.Action.Edit);
        this.fileContainer.setFile(node.getFile());
        Log.debug((String)"switching to file load dialog");
        this.stackCurrentCardAndSwitchTo(OnScreenFileEditor.class, this.fileContainer);
    }

    private void clearButtonActionPerformed() {
        ((ScriptNode)this.getNode()).setAndReadFile(null);
        this.updateCard();
    }

    private void saveButtonActionPerformed() {
        this.saveChangesToFile();
        this.saveButton.setEnabled(((ScriptNode)this.getNode()).isLoadedFileContentChanged());
    }

    private void scriptTextAreaKeyTyped() {
        this.saveButton.setEnabled(true);
    }

    private void scriptTextAreaFocusLost() {
        ((ScriptNode)this.getNode()).setLoadedFileContents(this.scriptTextArea.getText());
    }
}

