/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.swing.units.Units;
import gui.program.SpeedValueNode;
import gui.tools.LegacyURDialogCreator;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.text.JTextComponent;

public final class SpeedFieldParser {
    private static DecimalFormat f = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.#");
    private static JointConfigurationSettings jointConfigurationSettings;
    @Inject
    private static TextResource textResource;

    private SpeedFieldParser() {
    }

    @Inject
    public static void setJointConfigurationSettings(JointConfigurationSettings jointConfigurationSettings) {
        SpeedFieldParser.jointConfigurationSettings = jointConfigurationSettings;
    }

    public static void parse(JTextComponent jText, SpeedValueNode node) {
        try {
            double speed = node.isCartesianMotion() ? Units.convert_to_m_s((String)jText.getText()) : Math.toRadians(PrimitiveUtils.parseDouble((String)jText.getText()));
            if (speed < 0.0) {
                speed = -speed;
            }
            Speed maxSpeed = Speed.from((double)URMath.getMaxValue((double[])jointConfigurationSettings.getJointMaxSpeed()), (Speed.Unit)Speed.Unit.SI);
            if (!node.isCartesianMotion() && speed > maxSpeed.asDouble()) {
                node.setSpeed(maxSpeed);
                SpeedFieldParser.update(jText, node);
            } else if (node.isCartesianMotion() && speed > 3.0) {
                node.setSpeed(Speed.from((double)3.0, (Speed.Unit)Speed.Unit.SI));
                SpeedFieldParser.update(jText, node);
            } else {
                node.setSpeed(Speed.from((double)speed, (Speed.Unit)Speed.Unit.SI));
            }
        }
        catch (Exception exception) {
            LegacyURDialogCreator.showErrorDialog(textResource.errorParseerror(), textResource.notANumber(), "");
            SpeedFieldParser.update(jText, node);
        }
    }

    public static void update(JTextComponent jText, SpeedValueNode node) {
        double speedInSI = node.getSpeed().getIn(Speed.Unit.SI);
        if (node.isCartesianMotion()) {
            jText.setText(Units.convert_from_m_s((double)speedInSI, (DecimalFormat)f, (DecimalFormat)f));
        } else {
            jText.setText(f.format(Math.toDegrees(speedInSI)));
        }
    }
}

