/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.ErrorMessage;
import gui.tools.DialogCreator;
import javax.inject.Inject;

public class SubProgramDialogSupport {
    private final TextResource textResource;
    private final DialogCreator dialogCreator;

    @Inject
    public SubProgramDialogSupport(TextResource textResource, DialogCreator dialogCreator) {
        this.textResource = textResource;
        this.dialogCreator = dialogCreator;
    }

    public DialogReturnValue showConfirmClearSelectedProgram(String fileName) {
        ConfirmationMessage confirmationMessage = new ConfirmationMessage(this.textResource.confirmClearSubProgramTitle(), this.textResource.confirmClearSubProgramExplanation(fileName), this.textResource.confirmClearSubProgramAction(), this.textResource.Cancel());
        return this.dialogCreator.showConfirmationDialog(confirmationMessage);
    }

    public DialogReturnValue showConfirmReplaceLoadedSubProgram(String fileName) {
        ConfirmationMessage message = new ConfirmationMessage(this.textResource.confirmLoadSubProgramTitle(), this.textResource.confirmLoadSubProgramExplanation(fileName), this.textResource.confirmLoadSubProgramAction(), this.textResource.Cancel());
        return this.dialogCreator.showConfirmationDialog(message);
    }

    private ErrorMessage subProgramHasSameNameAsProgram() {
        return new ErrorMessage(this.textResource.selfReference(), this.textResource.theNameIsTheSameAsTheCurrentProgram(), this.textResource.chooseADifferentNameForTheSubProgram());
    }

    public void showSubProgramIsSameAsLoadedProgram() {
        this.showErrorDialog(this.subProgramHasSameNameAsProgram());
    }

    private ErrorMessage subProgramIsAlreadyLoaded() {
        return new ErrorMessage(this.textResource.alreadyOpen(), this.textResource.subProgramIsAlreadyLoaded());
    }

    public void showSubProgramAlreadyLoaded() {
        this.showErrorDialog(this.subProgramIsAlreadyLoaded());
    }

    private void showErrorDialog(ErrorMessage errorMessage) {
        this.dialogCreator.showErrorDialog(errorMessage, null);
    }
}

