/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.swing.ViewContext;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import gui.program.ThreadNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ThreadCard
extends CommandPanel<ThreadNode> {
    private JCheckBox loopForeverCheckbox;
    private JCheckBox trackExecutionCheckbox;

    @Inject
    ThreadCard(ViewContext viewContext) {
        super(ThreadNode.class, viewContext);
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.getViewContext().getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_thread");
    }

    @Override
    protected void updateCard() {
        ThreadNode node = (ThreadNode)this.getNode();
        this.loopForeverCheckbox.setSelected(!node.getRunOnlyOnce());
        this.trackExecutionCheckbox.setSelected(node.getTrackProgramExecution());
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(15, 10, 5, 10));
        JLabel jLabel3 = new JLabel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.loopForeverCheckbox = new JCheckBox();
        JPanel jPanel4 = new JPanel();
        this.trackExecutionCheckbox = new JCheckBox();
        this.setName("ProgramRootCard");
        this.setLayout(new BorderLayout());
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class);
        jLabel3.setText(HTML.html((String)HTML.h1((String)commandNamesResource.Thread())));
        this.add(jLabel3, "North");
        jPanel2.setName("ThreadCard");
        jPanel2.setLayout(new BorderLayout());
        jLabel2.setText(textResource.commandThread());
        jPanel2.add((Component)jLabel2, "North");
        jPanel1.setLayout(new BoxLayout(jPanel1, 3));
        jPanel3.setLayout(new FlowLayout(0));
        this.loopForeverCheckbox.setText(textResource.threadLoopsUntilStopped());
        this.loopForeverCheckbox.setPreferredSize(new Dimension(400, 22));
        this.loopForeverCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ThreadCard.this.loopForeverCheckboxItemStateChanged();
            }
        });
        jPanel3.add(this.loopForeverCheckbox);
        jPanel1.add(jPanel3);
        jPanel4.setLayout(new FlowLayout(0));
        this.trackExecutionCheckbox.setText(textResource.trackProgramExecution());
        this.trackExecutionCheckbox.setPreferredSize(new Dimension(400, 22));
        this.trackExecutionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ThreadCard.this.trackExecutionCheckboxActionPerformed();
            }
        });
        jPanel4.add(this.trackExecutionCheckbox);
        jPanel1.add(jPanel4);
        jPanel2.add((Component)jPanel1, "South");
        this.add(jPanel2, "Center");
    }

    private void loopForeverCheckboxItemStateChanged() {
        ((ThreadNode)this.getNode()).setRunOnlyOnce(!this.loopForeverCheckbox.isSelected());
    }

    private void trackExecutionCheckboxActionPerformed() {
        ((ThreadNode)this.getNode()).setTrackProgramExecution(this.trackExecutionCheckbox.isSelected());
    }
}

