/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.ViewContext;
import com.ur.util.CollectionUtils;
import com.ur.util.Conjunction;
import com.ur.util.Predicate;
import com.ur.view.naming.UniqueByName;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.program.EntityFactory;
import gui.program.TimerNode;
import gui.program.TimerVariablePredicate;
import gui.program.validation.TimerNodeValidationStrategyProvider;
import gui.swing.renderers.VariableComboBoxModel;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public abstract class TimerCard
extends CommandPanel<TimerNode> {
    public static final String START_TIMER = "startTimer." + TimerCard.class.getName();
    public static final String STOP_TIMER = "stopTimer." + TimerCard.class.getName();
    public static final String RESET_TIMER = "resetTimer." + TimerCard.class.getName();
    public static final String RENAME_VARIABLE = "renameVariable." + TimerCard.class.getName();
    public static final String VARIABLE_SELECTOR = "variableSelector." + TimerCard.class.getName();
    private static String createNewVariableString;
    private final EntityFactory entityFactory;
    private final VariableLookupService lookupService;
    protected JLabel explanationLabel;
    protected JButton renameVariableButton;
    protected JComboBox variableDropDown;
    protected EnumButtonGroup<TimerNode.TimerAction> radioButtons;
    protected JRadioButton noneSelectedInvisibleRadioButton;
    protected JRadioButton startButton;
    protected JRadioButton stopButton;
    protected JRadioButton resetButton;

    protected TimerCard(TimerNodeValidationStrategyProvider timerNodeValidationStrategyProvider, EntityFactory entityFactory, VariableLookupService lookupService, ViewContext viewContext) {
        super(TimerNode.class, viewContext);
        this.entityFactory = entityFactory;
        this.lookupService = lookupService;
        createNewVariableString = ((TextResource)viewContext.getTextResource(TextResource.class)).createNew();
    }

    @Override
    protected void updateCard() {
        this.makeVariableSelectorComboBoxModel();
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        TimerNode node = (TimerNode)this.getNode();
        this.radioButtons.select((Enum)node.getTimerAction());
        this.variableDropDown.setSelectedItem(node.getVariable());
    }

    protected void timerActionSelectedActionPerformed(TimerNode.TimerAction timerAction) {
        ((TimerNode)this.getNode()).setTimerAction(timerAction);
        this.makeVariableSelectorComboBoxModel();
    }

    protected void variableSelectorComboBoxActionPerformed() {
        Object selectedItem = this.variableDropDown.getSelectedItem();
        if (selectedItem == createNewVariableString) {
            this.makeNewVariableAndAssignToNode();
        }
        if (selectedItem instanceof ProgramVariable && ((ProgramVariable)selectedItem).getProperties().containsKey("TimerVariable")) {
            ((TimerNode)this.getNode()).setVariable((ProgramVariable)selectedItem);
            this.renameVariableButton.setEnabled(true);
        }
    }

    private void makeNewVariableAndAssignToNode() {
        ProgramVariable variable = this.entityFactory.createTimerVariable();
        ((TimerNode)this.getNode()).setVariable(variable);
        this.makeVariableSelectorComboBoxModel();
    }

    private void makeVariableSelectorComboBoxModel() {
        TimerNode node = (TimerNode)this.getNode();
        Collection<NamedEntity> variables = this.lookupService.getVariablesByPredicate(new TimerVariablePredicate());
        VariableComboBoxModel comboBoxModel = new VariableComboBoxModel();
        if (this.hasComboboxTopElement()) {
            comboBoxModel.addElement(createNewVariableString);
        }
        comboBoxModel.addVariables(CollectionUtils.filter(variables, (Predicate)new Conjunction(new Predicate[]{new UniqueByName(), new Predicate.ByType(Variable.class)})));
        if (node.getVariable() == null) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        } else {
            comboBoxModel.selectVariable(node.getVariable());
        }
        this.variableDropDown.setModel(comboBoxModel);
        this.renameVariableButton.setEnabled(true);
    }

    private boolean hasComboboxTopElement() {
        return ((TimerNode)this.getNode()).getTimerAction() == TimerNode.TimerAction.START;
    }
}

