/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.google.inject.Inject;
import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamingService;
import com.ur.swing.TextProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.variables.core.Variable;
import gui.program.InitVariablesNode;
import gui.program.services.GeomFeatureVariable;
import gui.tools.dialogs.input.DescriptionValidationFactory;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VariablesSetupDetailPanel
extends JPanel {
    private static final String SHOW_FAVORITE_CHECKBOX = "VariablesSetupDetailPanel.showFavorite";
    private final Font textFont = new Font("DejaVu", 1, 16);
    private final TextResource textResource;
    private final NamingService namingService;
    private final GridBagConstraints gridBagConstraints;
    private final ViewContext viewContext;
    protected final ExpressionField expressionField;
    protected JTextField nameField;
    protected JTextField descriptionField;
    private JCheckBox keepValueCheckBox;
    private JCheckBox setAsFavoriteCheckBox;
    private JLabel equalsOperatorSignLabel;
    private Variable selectedVariable = null;
    private InitVariablesNode initVariablesNode;

    @Inject
    public VariablesSetupDetailPanel(ViewContext viewContext, NamingService namingService, ExpressionField expressionField) {
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.namingService = namingService;
        this.expressionField = expressionField;
        this.setLayout(new GridBagLayout());
        this.gridBagConstraints = new GridBagConstraints();
        this.initComponents();
    }

    public boolean isKeepValues() {
        return this.keepValueCheckBox.isSelected();
    }

    public boolean isShowAsFavorite() {
        return this.setAsFavoriteCheckBox.isSelected();
    }

    public void setSelectedVariable(Variable selectedVariable) {
        this.selectedVariable = selectedVariable;
        this.updateFields();
    }

    private void updateFields() {
        if (this.selectedVariable == null) {
            this.expressionField.setExpression(new ExpressionBranchNode());
            this.expressionField.setEnabled(false);
            this.nameField.setText("");
            this.descriptionField.setText("");
        } else {
            this.expressionField.setExpression(this.selectedVariable.getExpression().getExpression());
            this.expressionField.setEnabled(true);
            this.nameField.setText(this.selectedVariable.getName());
            this.verifyAndUpdateDescriptionField(this.selectedVariable.getDescription());
        }
        this.updateCheckBoxes();
    }

    private void verifyAndUpdateDescriptionField(Object descriptionValue) {
        if (descriptionValue != null) {
            this.descriptionField.setText(descriptionValue.toString());
        } else {
            this.descriptionField.setText("");
        }
    }

    public void setProgramNode(InitVariablesNode node) {
        this.initVariablesNode = node;
        this.expressionField.setNodeWithExpression((ExpressionNodeProperty)node);
    }

    private void updateCheckBoxes() {
        if (this.isEditable(this.selectedVariable)) {
            this.enableCheckBoxes(this.selectedVariable);
        } else {
            this.disableCheckBoxes();
        }
    }

    private boolean isEditable(Variable v) {
        return v != null && !(v instanceof GeomFeatureVariable);
    }

    public void initComponents() {
        JLabel name = new JLabel(this.textResource.Name());
        name.setFont(this.textFont);
        JLabel expression = new JLabel(((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Expression());
        expression.setFont(this.textFont);
        JLabel descriptionLabel = new JLabel(this.textResource.Description());
        descriptionLabel.setFont(this.textFont);
        this.descriptionField = new JTextField(1);
        this.descriptionField.setEditable(false);
        this.equalsOperatorSignLabel = new JLabel(HTML.html((String)HTML.fontBold((String)" \u2254 ")));
        this.nameField = new JTextField(1);
        this.nameField.setEditable(false);
        this.keepValueCheckBox = new JCheckBox(this.textResource.setToValueFromPreviousRun());
        this.keepValueCheckBox.setFocusable(false);
        this.setAsFavoriteCheckBox = new JCheckBox(this.textResource.favoriteVariable());
        this.setAsFavoriteCheckBox.setFocusable(false);
        this.setAsFavoriteCheckBox.setName(SHOW_FAVORITE_CHECKBOX);
        this.setListenersForButtons();
        TextProvider selectedVariableNameProvider = this.createSelectedVariableNameProvider();
        NameValidationFactory.AutoCorrectVariableNameValidator variableNameValidator = NameValidationFactory.getVariableNameValidator(selectedVariableNameProvider, this.namingService, Variable.class, this.textResource);
        ValidationStrategy descriptionValidation = DescriptionValidationFactory.getDescriptionValidator(this.textResource);
        TextFieldUtils.bindTextPicker((JComponent)this.descriptionField, (TextHolder)this.createDescriptionTextHolder(), (ValidationStrategy)descriptionValidation);
        TextFieldUtils.bindTextPicker((JComponent)this.nameField, (TextHolder)this.createRenameTextHolder(), (ValidationStrategy)variableNameValidator);
        this.arrangeItemsInPanel(name, expression, descriptionLabel);
    }

    private void setListenersForButtons() {
        this.keepValueCheckBox.addActionListener(evt -> this.keepValueCheckBoxActionPerformed());
        this.setAsFavoriteCheckBox.addActionListener(actionEvent -> this.setAsFavoriteActionPerformed());
    }

    protected void clearExpressionButtonActionPerformed() {
        if (this.selectedVariable != null) {
            this.initVariablesNode.clearExpression(this.selectedVariable);
        }
    }

    protected void keepValueCheckBoxActionPerformed() {
        if (this.selectedVariable != null) {
            this.initVariablesNode.setPrefersPersistentValue(this.selectedVariable, this.isKeepValues());
        }
    }

    protected void setAsFavoriteActionPerformed() {
        if (this.selectedVariable != null) {
            this.initVariablesNode.setIsFavoriteValue(this.selectedVariable, this.isShowAsFavorite());
        }
    }

    private void arrangeItemsInPanel(JLabel name, JLabel expression, JLabel description) {
        this.changeGridConstraints(2, 0, 0, 0.5, 0.33, 1);
        this.add((Component)name, this.gridBagConstraints);
        this.changeGridConstraints(2, 4, 0, 0.5, 0.33, 2);
        this.add((Component)expression, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.changeGridConstraints(2, 0, 1, 0.5, 0.33, 3);
        this.add((Component)this.nameField, this.gridBagConstraints);
        this.changeGridConstraints(10, 3, 1, 0.05, 0.33, 1);
        this.add((Component)this.equalsOperatorSignLabel, this.gridBagConstraints);
        this.changeGridConstraints(1, 4, 1, 1.0, 0.33, 2);
        this.add((Component)this.expressionField, this.gridBagConstraints);
        this.changeGridConstraints(2, 0, 2, 0.5, 0.33, 2);
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)description, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.changeGridConstraints(2, 0, 3, 0.5, 0.33, 1);
        this.add((Component)this.descriptionField, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.changeGridConstraints(2, 0, 4, 0.5, 0.33, 2);
        JPanel keepValuesSubPanel = this.getEmptySubPanel();
        keepValuesSubPanel.add((Component)this.keepValueCheckBox, "West");
        this.add((Component)keepValuesSubPanel, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.changeGridConstraints(2, 0, 5, 0.5, 0.33, 2);
        JPanel showAsFavoriteSubPanel = this.getEmptySubPanel();
        showAsFavoriteSubPanel.add((Component)this.setAsFavoriteCheckBox, "West");
        this.add((Component)showAsFavoriteSubPanel, this.gridBagConstraints);
    }

    private JPanel getEmptySubPanel() {
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BorderLayout());
        return subPanel;
    }

    private TextProvider createSelectedVariableNameProvider() {
        return () -> {
            if (this.selectedVariable == null) {
                return "";
            }
            return this.selectedVariable.getName();
        };
    }

    private void changeGridConstraints(int fill, int gridX, int gridY, double weightX, double weightY, int gridWidth) {
        this.gridBagConstraints.fill = fill;
        this.gridBagConstraints.gridx = gridX;
        this.gridBagConstraints.gridy = gridY;
        this.gridBagConstraints.weightx = weightX;
        this.gridBagConstraints.weighty = weightY;
        this.gridBagConstraints.gridwidth = gridWidth;
    }

    private void disableCheckBoxes() {
        this.keepValueCheckBox.setEnabled(false);
        this.keepValueCheckBox.setSelected(false);
        this.setAsFavoriteCheckBox.setEnabled(false);
        this.setAsFavoriteCheckBox.setSelected(false);
    }

    private void enableCheckBoxes(Variable selectedVariable) {
        this.keepValueCheckBox.setSelected(selectedVariable.prefersPersistentValue());
        this.setAsFavoriteCheckBox.setSelected(selectedVariable.isFavourite());
        this.keepValueCheckBox.setEnabled(true);
        this.setAsFavoriteCheckBox.setEnabled(true);
    }

    protected TextHolder createRenameTextHolder() {
        return new TextHolder(){

            public String getText() {
                return VariablesSetupDetailPanel.this.selectedVariable.getName();
            }

            public void setText(String text) {
                VariablesSetupDetailPanel.this.initVariablesNode.setVariableName(VariablesSetupDetailPanel.this.selectedVariable, text);
                VariablesSetupDetailPanel.this.nameField.setText(text);
            }
        };
    }

    protected TextHolder createDescriptionTextHolder() {
        return new TextHolder(){

            public String getText() {
                return VariablesSetupDetailPanel.this.selectedVariable.getDescription();
            }

            public void setText(String text) {
                VariablesSetupDetailPanel.this.initVariablesNode.setVariableDescription(VariablesSetupDetailPanel.this.selectedVariable, text);
                VariablesSetupDetailPanel.this.descriptionField.setText(text);
            }
        };
    }
}

