/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.google.inject.Inject;
import com.ur.i18n.TextResource;
import com.ur.swing.ViewContext;
import com.ur.util.event.EventManager;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.core.Variable;
import gui.commandpanels.VariablesSetupDetailPanel;
import gui.commandpanels.VariablesSetupTablePanel;
import gui.commandpanels.VariablesTableSelectionChangedListener;
import gui.program.InitVariablesNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class VariablesSetupPanel
extends CommandPanel<InitVariablesNode>
implements VariablesTableSelectionChangedListener {
    private final VariablesSetupDetailPanel variablesDetailPanel;
    private final VariablesSetupTablePanel variablesSetupTablePanel;
    private final TextResource textResource;

    @Inject
    protected VariablesSetupPanel(ViewContext viewContext, EventManager eventManager, VariablesSetupDetailPanel variablesButtonPanel, VariablesSetupTablePanel variablesSetupTablePanel) {
        super(InitVariablesNode.class, viewContext);
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.variablesDetailPanel = variablesButtonPanel;
        this.variablesSetupTablePanel = variablesSetupTablePanel;
        eventManager.addStrongListener(VariablesTableSelectionChangedListener.class, (Object)this);
        this.initComponents();
    }

    @Override
    protected void updateCard() {
        ((InitVariablesNode)this.getNode()).setCurrentVariable(this.variablesSetupTablePanel.getSelectedVariable());
        this.variablesDetailPanel.setProgramNode((InitVariablesNode)this.getNode());
        this.setSelectedVariable(this.variablesSetupTablePanel.getSelectedVariable());
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        this.variablesSetupTablePanel.enter(this.getNode());
        SwingUtilities.invokeLater(this::updateCard);
    }

    public Object exit() {
        ((InitVariablesNode)this.getNode()).setCurrentVariable(null);
        this.variablesSetupTablePanel.exit();
        return super.exit();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.initHeaderPanel();
        this.add(this.variablesSetupTablePanel);
        this.add(this.variablesDetailPanel, "Last");
    }

    private void initHeaderPanel() {
        JPanel headerPanel = new JPanel(new BorderLayout());
        JLabel headerLabel = new JLabel(this.textResource.VariablesSetup());
        headerLabel.setFont(new Font("DejaVu", 1, 26));
        headerPanel.add((Component)headerLabel, "West");
        this.add(headerPanel, "First");
    }

    private void setSelectedVariable(Variable v) {
        ((InitVariablesNode)this.getNode()).setCurrentVariable(v);
        this.variablesDetailPanel.setSelectedVariable(v);
    }

    @Override
    public void selectedVariableChanged(Variable variable) {
        this.setSelectedVariable(variable);
    }
}

