/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.card.EnterExitCard;
import com.ur.util.event.EventManager;
import com.ur.view.gui.tables.VariablesSetupTableModel;
import com.ur.view.gui.tables.VariablesTable;
import com.ur.view.gui.tables.VariablesTablePanel;
import com.ur.view.variables.core.Variable;
import gui.commandpanels.VariablesTableSelectionChangedListener;
import gui.program.InitVariablesNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class VariablesSetupTablePanel
extends JPanel
implements EnterExitCard {
    private static final String VARIABLES_SETUP_TABLE_NAME = "ImprovedVariablesSetupTable";
    private final TextResource textResource;
    private final EventManager eventManager;
    private final String[] columnNames;
    protected VariablesTable variablesTable;
    private Variable selectedVariable;

    @Inject
    public VariablesSetupTablePanel(EventManager eventManager, ViewContext viewContext) {
        this.eventManager = eventManager;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.columnNames = new String[]{this.textResource.favoriteColumn(), this.textResource.Name(), this.textResource.InitialValue(), this.textResource.Description()};
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        this.variablesTable = new VariablesTable();
        this.variablesTable.setName(VARIABLES_SETUP_TABLE_NAME);
        this.variablesTable.setModel(new VariablesSetupTableModel(new ArrayList<Variable>(), this.columnNames, this.textResource, this.eventManager));
        this.variablesTable.addMouseListener(this.createTableMouseListener());
        this.variablesTable.setColumnWidthsByPixels(33, 190, 190, 242);
        VariablesTablePanel variablesTablePanel = VariablesTablePanel.createTableWithFourColumns(this.variablesTable);
        variablesTablePanel.addMouseListenerToScrollPane(this.createScrollPaneMouseListener());
        variablesTablePanel.addColumnCollapseButton();
        variablesTablePanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.add((Component)variablesTablePanel, "Center");
    }

    protected MouseAdapter createTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int selectedRow = VariablesSetupTablePanel.this.variablesTable.getSelectedRow();
                if (selectedRow >= 0) {
                    VariablesSetupTablePanel.this.setSelectedVariable(VariablesSetupTablePanel.this.variablesTable.getVariableAt(selectedRow));
                } else {
                    VariablesSetupTablePanel.this.setSelectedVariable(null);
                }
            }
        };
    }

    protected MouseAdapter createScrollPaneMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                VariablesSetupTablePanel.this.setSelectedVariable(null);
            }
        };
    }

    private void setSelectedVariable(Variable v) {
        this.selectedVariable = v;
        if (v == null) {
            this.variablesTable.clearSelection();
        }
        this.eventManager.fireEvent(VariablesTableSelectionChangedListener.class, listener -> listener.selectedVariableChanged(this.selectedVariable));
    }

    private void makeModels(Collection<Variable> variables) {
        ((VariablesSetupTableModel)this.variablesTable.getModel()).setVariables(variables);
        for (Variable v : variables) {
            if (v != this.getSelectedVariable()) continue;
            return;
        }
        this.setSelectedVariable(null);
    }

    private void setSelectionIfThereIsAnythingToSelect() {
        int selectedRow = -1;
        if (this.selectedVariable != null) {
            selectedRow = this.variablesTable.getRow(this.selectedVariable);
        }
        if (selectedRow >= 0 && selectedRow <= this.variablesTable.getRowCount()) {
            this.variablesTable.setRowSelectionInterval(selectedRow, selectedRow);
        } else {
            this.variablesTable.clearSelection();
            this.setSelectedVariable(null);
        }
    }

    public Variable getSelectedVariable() {
        return this.selectedVariable;
    }

    public void enter(Object o) {
        if (o instanceof InitVariablesNode) {
            this.makeModels(((InitVariablesNode)o).getVariables());
        }
        this.variablesTable.restoreSortOrder();
        this.setSelectionIfThereIsAnythingToSelect();
    }

    public Object exit() {
        this.variablesTable.saveSortOrder();
        return null;
    }
}

