/*
 * Decompiled with CFR 0.152.
 */
package gui.commandpanels;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.ProgramNodeCardContribution;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.units.Units;
import com.ur.view.program.CommandPanel;
import gui.program.position.WaypointNode;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class WaypointCard
extends CommandPanel<WaypointNode> {
    public static final String SELECT_WAYPOINT_TYPE = "selectWaypointType." + WaypointCard.class.getSimpleName();
    public static final String SET_WAYPOINT = "SetWaypoint." + WaypointCard.class.getSimpleName();
    public static final String EDIT_POSE = "EditPose." + WaypointCard.class.getSimpleName();
    public static final String MOVE_ROBOT_HERE = "MOVE_ROBOT_HERE." + WaypointCard.class.getSimpleName();
    public static final String CHANGE_THIS_FEATURE_BUTTON = "changeThisFeatureButton." + WaypointCard.class.getSimpleName();
    public static final String TIME_OPTION = "timerOption." + WaypointCard.class.getSimpleName();
    public static final String TIME_FIELD = "timerField." + WaypointCard.class.getSimpleName();
    public static final String SPEED_AND_ACCELERATION_OPTION = "speedAndAccelerationOption." + WaypointCard.class.getSimpleName();
    public static final String SPEED_FIELD = "speedOption." + WaypointCard.class.getSimpleName();
    public static final String ACCELERATION_FIELD = "accelerationOption." + WaypointCard.class.getSimpleName();
    public static final String SHARED_PARAMETERS_OPTION = "sharedParametersOption." + WaypointCard.class.getSimpleName();
    public static final String SELECT_PARAMETERS_TYPE = "selectParametersType." + WaypointCard.class.getSimpleName();
    protected final Set<ProgramNodeCardContribution> programNodeCardContributions;
    protected final ViewContext viewContext;
    private TextResource textResource;

    @Inject
    protected WaypointCard(ViewContext viewContext, Set<ProgramNodeCardContribution> programNodeCardContributions) {
        super(WaypointNode.class);
        this.viewContext = viewContext;
        this.programNodeCardContributions = programNodeCardContributions;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
    }

    protected void parseBlendValue(JTextField blendRadiusField) {
        WaypointNode node = (WaypointNode)this.getNode();
        try {
            double blendRadius = Units.convert_to_m((String)blendRadiusField.getText());
            node.setBlendRadius(blendRadius);
        }
        catch (Exception exception) {
            LegacyURDialogCreator.showErrorDialog(LanguagePack.getErrorMessages().validationError(this.textResource.notANumber()));
            blendRadiusField.setText(Units.convert_from_m((double)node.getBlendRadius()));
        }
    }

    public JPanel addContributions() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        ProgramNodeCardContribution[] contributions = this.programNodeCardContributions.toArray(new ProgramNodeCardContribution[this.programNodeCardContributions.size()]);
        Arrays.sort(contributions, (a, b) -> a.getPriority() < b.getPriority() ? 1 : 0);
        ProgramNodeCardContribution[] programNodeCardContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            ProgramNodeCardContribution contribution = programNodeCardContributionArray[n2];
            formBuilder.component(contribution.getContribution(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end();
            ++n2;
        }
        return formBuilder.getPanel();
    }
}

